/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.preferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.spi.preferences.AbstractPreferences;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.spi.preferences.Setting;

public class MemoryPreferences
extends AbstractPreferences {
    private final Map<String, Setting<?>> settings = new HashMap();

    @Override
    public boolean putSetting(String key, Setting<?> setting) {
        Setting<?> current = this.settings.get(key);
        if (setting == null) {
            this.settings.remove(key);
        } else {
            this.settings.put(key, setting);
        }
        return Objects.equals(setting, current);
    }

    @Override
    public <T extends Setting<?>> T getSetting(String key, T def, Class<T> klass) {
        Setting<?> current = this.settings.get(key);
        if (current != null && klass.isInstance(current)) {
            Setting<?> result = current;
            return (T)result;
        }
        return def;
    }

    @Override
    public Set<String> getKeySet() {
        return Collections.unmodifiableSet(this.settings.keySet());
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangedListener listener) {
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangedListener listener) {
    }

    @Override
    public void addKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
    }

    @Override
    public void removeKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
    }
}

