/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.KeyValuePair;

public class HashNode
extends Node
implements ILiteralNode {
    private final List<KeyValuePair<Node, Node>> pairs = new ArrayList<KeyValuePair<Node, Node>>();
    private boolean hasOnlySymbolKeys = true;

    public HashNode(ISourcePosition position) {
        super(position, false);
    }

    public HashNode(ISourcePosition position, KeyValuePair<Node, Node> pair) {
        this(position);
        this.add(pair);
    }

    public boolean hasOnlySymbolKeys() {
        return this.hasOnlySymbolKeys;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashNode add(KeyValuePair<Node, Node> pair) {
        if (pair.getKey() != null && pair.getKey().containsVariableAssignment() || pair.getValue() != null && pair.getValue().containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        if (!(pair.getKey() instanceof SymbolNode) || pair.getKey() == null) {
            this.hasOnlySymbolKeys = false;
        }
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<KeyValuePair<Node, Node>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<Node> childNodes() {
        ArrayList<Node> children2 = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            children2.add(pair.getKey());
            children2.add(pair.getValue());
        }
        return children2;
    }
}

