/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Comparable<Version>,
ToXContentFragment {
    public static final int V_5_0_0_alpha1_ID = 5000001;
    public static final Version V_5_0_0_alpha1 = new Version(5000001, org.apache.lucene.util.Version.LUCENE_6_0_0);
    public static final int V_5_0_0_alpha2_ID = 5000002;
    public static final Version V_5_0_0_alpha2 = new Version(5000002, org.apache.lucene.util.Version.LUCENE_6_0_0);
    public static final int V_5_0_0_alpha3_ID = 5000003;
    public static final Version V_5_0_0_alpha3 = new Version(5000003, org.apache.lucene.util.Version.LUCENE_6_0_0);
    public static final int V_5_0_0_alpha4_ID = 0x4C4B44;
    public static final Version V_5_0_0_alpha4 = new Version(0x4C4B44, org.apache.lucene.util.Version.LUCENE_6_1_0);
    public static final int V_5_0_0_alpha5_ID = 5000005;
    public static final Version V_5_0_0_alpha5 = new Version(5000005, org.apache.lucene.util.Version.LUCENE_6_1_0);
    public static final int V_5_0_0_beta1_ID = 5000026;
    public static final Version V_5_0_0_beta1 = new Version(5000026, org.apache.lucene.util.Version.LUCENE_6_2_0);
    public static final int V_5_0_0_rc1_ID = 5000051;
    public static final Version V_5_0_0_rc1 = new Version(5000051, org.apache.lucene.util.Version.LUCENE_6_2_0);
    public static final int V_5_0_0_ID = 5000099;
    public static final Version V_5_0_0 = new Version(5000099, org.apache.lucene.util.Version.LUCENE_6_2_0);
    public static final int V_5_0_1_ID = 5000199;
    public static final Version V_5_0_1 = new Version(5000199, org.apache.lucene.util.Version.LUCENE_6_2_1);
    public static final int V_5_0_2_ID = 5000299;
    public static final Version V_5_0_2 = new Version(5000299, org.apache.lucene.util.Version.LUCENE_6_2_1);
    public static final int V_5_1_1_ID = 5010199;
    public static final Version V_5_1_1 = new Version(5010199, org.apache.lucene.util.Version.LUCENE_6_3_0);
    public static final int V_5_1_2_ID = 5010299;
    public static final Version V_5_1_2 = new Version(5010299, org.apache.lucene.util.Version.LUCENE_6_3_0);
    public static final int V_5_2_0_ID = 5020099;
    public static final Version V_5_2_0 = new Version(5020099, org.apache.lucene.util.Version.LUCENE_6_4_0);
    public static final int V_5_2_1_ID = 5020199;
    public static final Version V_5_2_1 = new Version(5020199, org.apache.lucene.util.Version.LUCENE_6_4_1);
    public static final int V_5_2_2_ID = 5020299;
    public static final Version V_5_2_2 = new Version(5020299, org.apache.lucene.util.Version.LUCENE_6_4_1);
    public static final int V_5_3_0_ID = 5030099;
    public static final Version V_5_3_0 = new Version(5030099, org.apache.lucene.util.Version.LUCENE_6_4_1);
    public static final int V_5_3_1_ID = 5030199;
    public static final Version V_5_3_1 = new Version(5030199, org.apache.lucene.util.Version.LUCENE_6_4_2);
    public static final int V_5_3_2_ID = 5030299;
    public static final Version V_5_3_2 = new Version(5030299, org.apache.lucene.util.Version.LUCENE_6_4_2);
    public static final int V_5_3_3_ID = 5030399;
    public static final Version V_5_3_3 = new Version(5030399, org.apache.lucene.util.Version.LUCENE_6_4_2);
    public static final int V_5_4_0_ID = 5040099;
    public static final Version V_5_4_0 = new Version(5040099, org.apache.lucene.util.Version.LUCENE_6_5_0);
    public static final int V_5_4_1_ID = 5040199;
    public static final Version V_5_4_1 = new Version(5040199, org.apache.lucene.util.Version.LUCENE_6_5_1);
    public static final int V_5_4_2_ID = 5040299;
    public static final Version V_5_4_2 = new Version(5040299, org.apache.lucene.util.Version.LUCENE_6_5_1);
    public static final int V_5_4_3_ID = 5040399;
    public static final Version V_5_4_3 = new Version(5040399, org.apache.lucene.util.Version.LUCENE_6_5_1);
    public static final int V_5_5_0_ID = 5050099;
    public static final Version V_5_5_0 = new Version(5050099, org.apache.lucene.util.Version.LUCENE_6_6_0);
    public static final int V_5_5_1_ID = 5050199;
    public static final Version V_5_5_1 = new Version(5050199, org.apache.lucene.util.Version.LUCENE_6_6_0);
    public static final int V_5_5_2_ID = 5050299;
    public static final Version V_5_5_2 = new Version(5050299, org.apache.lucene.util.Version.LUCENE_6_6_0);
    public static final int V_5_5_3_ID = 5050399;
    public static final Version V_5_5_3 = new Version(5050399, org.apache.lucene.util.Version.LUCENE_6_6_0);
    public static final int V_5_6_0_ID = 5060099;
    public static final Version V_5_6_0 = new Version(5060099, org.apache.lucene.util.Version.LUCENE_6_6_0);
    public static final int V_5_6_1_ID = 5060199;
    public static final Version V_5_6_1 = new Version(5060199, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_2_ID = 5060299;
    public static final Version V_5_6_2 = new Version(5060299, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_3_ID = 5060399;
    public static final Version V_5_6_3 = new Version(5060399, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_4_ID = 5060499;
    public static final Version V_5_6_4 = new Version(5060499, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_5_ID = 5060599;
    public static final Version V_5_6_5 = new Version(5060599, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_6_ID = 5060699;
    public static final Version V_5_6_6 = new Version(5060699, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_7_ID = 5060799;
    public static final Version V_5_6_7 = new Version(5060799, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_8_ID = 5060899;
    public static final Version V_5_6_8 = new Version(5060899, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_9_ID = 5060999;
    public static final Version V_5_6_9 = new Version(5060999, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_10_ID = 5061099;
    public static final Version V_5_6_10 = new Version(5061099, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_5_6_11_ID = 5061199;
    public static final Version V_5_6_11 = new Version(5061199, org.apache.lucene.util.Version.LUCENE_6_6_1);
    public static final int V_6_0_0_alpha1_ID = 6000001;
    public static final Version V_6_0_0_alpha1 = new Version(6000001, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_alpha2_ID = 6000002;
    public static final Version V_6_0_0_alpha2 = new Version(6000002, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_beta1_ID = 6000026;
    public static final Version V_6_0_0_beta1 = new Version(6000026, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_beta2_ID = 6000027;
    public static final Version V_6_0_0_beta2 = new Version(6000027, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_rc1_ID = 6000051;
    public static final Version V_6_0_0_rc1 = new Version(6000051, org.apache.lucene.util.Version.LUCENE_7_0_0);
    public static final int V_6_0_0_rc2_ID = 6000052;
    public static final Version V_6_0_0_rc2 = new Version(6000052, org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final int V_6_0_0_ID = 6000099;
    public static final Version V_6_0_0 = new Version(6000099, org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final int V_6_0_1_ID = 6000199;
    public static final Version V_6_0_1 = new Version(6000199, org.apache.lucene.util.Version.LUCENE_7_0_1);
    public static final int V_6_1_0_ID = 6010099;
    public static final Version V_6_1_0 = new Version(6010099, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_1_ID = 0x5BB557;
    public static final Version V_6_1_1 = new Version(0x5BB557, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_2_ID = 0x5BB5BB;
    public static final Version V_6_1_2 = new Version(0x5BB5BB, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_3_ID = 6010399;
    public static final Version V_6_1_3 = new Version(6010399, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final int V_6_1_4_ID = 6010499;
    public static final Version V_6_1_4 = new Version(6010499, org.apache.lucene.util.Version.LUCENE_7_1_0);
    private static final org.apache.lucene.util.Version LUCENE_7_2_1 = org.apache.lucene.util.Version.fromBits(7, 2, 1);
    public static final int V_6_2_0_ID = 6020099;
    public static final Version V_6_2_0 = new Version(6020099, LUCENE_7_2_1);
    public static final int V_6_2_1_ID = 6020199;
    public static final Version V_6_2_1 = new Version(6020199, LUCENE_7_2_1);
    public static final int V_6_2_2_ID = 6020299;
    public static final Version V_6_2_2 = new Version(6020299, LUCENE_7_2_1);
    public static final int V_6_2_3_ID = 6020399;
    public static final Version V_6_2_3 = new Version(6020399, LUCENE_7_2_1);
    public static final int V_6_2_4_ID = 6020499;
    public static final Version V_6_2_4 = new Version(6020499, LUCENE_7_2_1);
    public static final int V_6_3_0_ID = 6030099;
    public static final Version V_6_3_0 = new Version(6030099, org.apache.lucene.util.Version.LUCENE_7_3_1);
    public static final int V_6_3_1_ID = 6030199;
    public static final Version V_6_3_1;
    public static final Version CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        switch (id) {
            case 6030199: {
                return V_6_3_1;
            }
            case 6030099: {
                return V_6_3_0;
            }
            case 6020499: {
                return V_6_2_4;
            }
            case 6020399: {
                return V_6_2_3;
            }
            case 6020299: {
                return V_6_2_2;
            }
            case 6020199: {
                return V_6_2_1;
            }
            case 6020099: {
                return V_6_2_0;
            }
            case 6010499: {
                return V_6_1_4;
            }
            case 6010399: {
                return V_6_1_3;
            }
            case 0x5BB5BB: {
                return V_6_1_2;
            }
            case 0x5BB557: {
                return V_6_1_1;
            }
            case 6010099: {
                return V_6_1_0;
            }
            case 6000199: {
                return V_6_0_1;
            }
            case 6000099: {
                return V_6_0_0;
            }
            case 6000052: {
                return V_6_0_0_rc2;
            }
            case 6000051: {
                return V_6_0_0_rc1;
            }
            case 6000027: {
                return V_6_0_0_beta2;
            }
            case 6000026: {
                return V_6_0_0_beta1;
            }
            case 6000002: {
                return V_6_0_0_alpha2;
            }
            case 6000001: {
                return V_6_0_0_alpha1;
            }
            case 5061199: {
                return V_5_6_11;
            }
            case 5061099: {
                return V_5_6_10;
            }
            case 5060999: {
                return V_5_6_9;
            }
            case 5060899: {
                return V_5_6_8;
            }
            case 5060799: {
                return V_5_6_7;
            }
            case 5060699: {
                return V_5_6_6;
            }
            case 5060599: {
                return V_5_6_5;
            }
            case 5060499: {
                return V_5_6_4;
            }
            case 5060399: {
                return V_5_6_3;
            }
            case 5060299: {
                return V_5_6_2;
            }
            case 5060199: {
                return V_5_6_1;
            }
            case 5060099: {
                return V_5_6_0;
            }
            case 5050399: {
                return V_5_5_3;
            }
            case 5050299: {
                return V_5_5_2;
            }
            case 5050199: {
                return V_5_5_1;
            }
            case 5050099: {
                return V_5_5_0;
            }
            case 5040399: {
                return V_5_4_3;
            }
            case 5040299: {
                return V_5_4_2;
            }
            case 5040199: {
                return V_5_4_1;
            }
            case 5040099: {
                return V_5_4_0;
            }
            case 5030399: {
                return V_5_3_3;
            }
            case 5030299: {
                return V_5_3_2;
            }
            case 5030199: {
                return V_5_3_1;
            }
            case 5030099: {
                return V_5_3_0;
            }
            case 5020299: {
                return V_5_2_2;
            }
            case 5020199: {
                return V_5_2_1;
            }
            case 5020099: {
                return V_5_2_0;
            }
            case 5010299: {
                return V_5_1_2;
            }
            case 5010199: {
                return V_5_1_1;
            }
            case 5000299: {
                return V_5_0_2;
            }
            case 5000199: {
                return V_5_0_1;
            }
            case 5000099: {
                return V_5_0_0;
            }
            case 5000051: {
                return V_5_0_0_rc1;
            }
            case 5000026: {
                return V_5_0_0_beta1;
            }
            case 5000005: {
                return V_5_0_0_alpha5;
            }
            case 0x4C4B44: {
                return V_5_0_0_alpha4;
            }
            case 5000003: {
                return V_5_0_0_alpha3;
            }
            case 5000002: {
                return V_5_0_0_alpha2;
            }
            case 5000001: {
                return V_5_0_0_alpha1;
            }
        }
        return new Version(id, org.apache.lucene.util.Version.LATEST);
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = indexSettings.getAsVersion("index.version.created", null);
        if (indexVersion == null) {
            throw new IllegalStateException("[index.version.created] is not present in the index settings for index with uuid: [" + indexSettings.get("index.uuid") + "]");
        }
        return indexVersion;
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        String[] parts;
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a beta build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = luceneVersion;
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.id, other.id);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        if (this.major >= 6) {
            Version bwcVersion = null;
            for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
                Version candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
                if (candidateVersion.major != this.major - 1 || !candidateVersion.isRelease() || !this.after(candidateVersion)) continue;
                if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
                bwcVersion = candidateVersion;
            }
            return bwcVersion == null ? this : bwcVersion;
        }
        return Version.min(this, Version.fromId(this.major * 1000000 + 0 + 99));
    }

    public Version minimumIndexCompatibilityVersion() {
        int bwcMajor = this.major == 5 ? 2 : this.major - 1;
        boolean bwcMinor = false;
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + 0 + 99));
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Version.displayVersion(CURRENT, Build.CURRENT.isSnapshot()), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.shortHash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public static String displayVersion(Version version, boolean isSnapshot) {
        return version + (isSnapshot ? "-SNAPSHOT" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isBeta() {
        return this.major < 5 ? this.build < 50 : this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.major < 5 ? false : this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class || "CURRENT".equals(field.getName())) continue;
            assert (field.getName().matches("V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
            try {
                versions.add((Version)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Collections.sort(versions);
        return versions;
    }

    static {
        CURRENT = V_6_3_1 = new Version(6030199, org.apache.lucene.util.Version.LUCENE_7_3_1);
        assert (Version.CURRENT.luceneVersion.equals(org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + org.apache.lucene.util.Version.LATEST + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }
}

