/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli.command;

import java.sql.SQLException;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.client.shared.ClientException;
import org.elasticsearch.xpack.sql.client.shared.Version;

public class CliSession {
    private final HttpClient httpClient;
    private int fetchSize = 1000;
    private String fetchSeparator = "";
    private boolean debug;

    public CliSession(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getClient() {
        return this.httpClient;
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("Must be > 0.");
        }
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSeparator(String fetchSeparator) {
        this.fetchSeparator = fetchSeparator;
    }

    public String getFetchSeparator() {
        return this.fetchSeparator;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void checkConnection() throws ClientException {
        MainResponse response;
        try {
            response = this.httpClient.serverInfo();
        }
        catch (SQLException ex) {
            throw new ClientException(ex);
        }
        if (response.getVersion().major != Version.CURRENT.major || response.getVersion().minor != Version.CURRENT.minor) {
            throw new ClientException("This alpha version of CLI is only compatible with Elasticsearch version " + Version.CURRENT.toString());
        }
    }
}

