/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.support.CharArrays;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;

abstract class PoolingSessionFactory
extends SessionFactory
implements Releasable {
    private final boolean useConnectionPool;
    private final LDAPConnectionPool connectionPool;
    final SimpleBindRequest bindCredentials;
    final LdapMetaDataResolver metaDataResolver;
    final LdapSession.GroupsResolver groupResolver;

    PoolingSessionFactory(RealmConfig config, SSLService sslService, LdapSession.GroupsResolver groupResolver, Setting<Boolean> poolingEnabled, @Nullable String bindDn, Supplier<String> healthCheckDNSupplier, ThreadPool threadPool) throws LDAPException {
        super(config, sslService, threadPool);
        byte[] bindPassword;
        this.groupResolver = groupResolver;
        this.metaDataResolver = new LdapMetaDataResolver(config.settings(), this.ignoreReferralErrors);
        if (PoolingSessionFactorySettings.LEGACY_BIND_PASSWORD.exists(config.settings())) {
            if (PoolingSessionFactorySettings.SECURE_BIND_PASSWORD.exists(config.settings())) {
                throw new IllegalArgumentException("You cannot specify both [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting)PoolingSessionFactorySettings.LEGACY_BIND_PASSWORD) + "] and [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting)PoolingSessionFactorySettings.SECURE_BIND_PASSWORD) + "]");
            }
            bindPassword = CharArrays.toUtf8Bytes((char[])((SecureString)PoolingSessionFactorySettings.LEGACY_BIND_PASSWORD.get(config.settings())).getChars());
        } else {
            bindPassword = PoolingSessionFactorySettings.SECURE_BIND_PASSWORD.exists(config.settings()) ? CharArrays.toUtf8Bytes((char[])((SecureString)PoolingSessionFactorySettings.SECURE_BIND_PASSWORD.get(config.settings())).getChars()) : null;
        }
        this.bindCredentials = bindDn == null ? new SimpleBindRequest() : new SimpleBindRequest(bindDn, bindPassword);
        this.useConnectionPool = (Boolean)poolingEnabled.get(config.settings());
        this.connectionPool = this.useConnectionPool ? PoolingSessionFactory.createConnectionPool(config, this.serverSet, this.timeout, this.logger, (BindRequest)this.bindCredentials, healthCheckDNSupplier) : null;
    }

    @Override
    public final void session(String user, SecureString password, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getSessionWithPool(this.connectionPool, user, password, listener);
        } else {
            this.getSessionWithoutPool(user, password, listener);
        }
    }

    @Override
    public final void unauthenticatedSession(String user, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getUnauthenticatedSessionWithPool(this.connectionPool, user, listener);
        } else {
            this.getUnauthenticatedSessionWithoutPool(user, listener);
        }
    }

    abstract void getSessionWithPool(LDAPConnectionPool var1, String var2, SecureString var3, ActionListener<LdapSession> var4);

    abstract void getSessionWithoutPool(String var1, SecureString var2, ActionListener<LdapSession> var3);

    abstract void getUnauthenticatedSessionWithPool(LDAPConnectionPool var1, String var2, ActionListener<LdapSession> var3);

    abstract void getUnauthenticatedSessionWithoutPool(String var1, ActionListener<LdapSession> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LDAPConnectionPool createConnectionPool(RealmConfig config, ServerSet serverSet, TimeValue timeout, Logger logger, BindRequest bindRequest, Supplier<String> healthCheckDnSupplier) throws LDAPException {
        Settings settings = config.settings();
        int initialSize = (Integer)PoolingSessionFactorySettings.POOL_INITIAL_SIZE.get(settings);
        int size = (Integer)PoolingSessionFactorySettings.POOL_SIZE.get(settings);
        LDAPConnectionPool pool = null;
        boolean success = false;
        try {
            pool = (LDAPConnectionPool)LdapUtils.privilegedConnect(() -> new LDAPConnectionPool(serverSet, bindRequest, initialSize, size));
            pool.setRetryFailedOperationsDueToInvalidConnections(true);
            if (((Boolean)PoolingSessionFactorySettings.HEALTH_CHECK_ENABLED.get(settings)).booleanValue()) {
                String entryDn = ((Optional)PoolingSessionFactorySettings.HEALTH_CHECK_DN.get(settings)).orElseGet(healthCheckDnSupplier);
                long healthCheckInterval = ((TimeValue)PoolingSessionFactorySettings.HEALTH_CHECK_INTERVAL.get(settings)).millis();
                if (entryDn != null) {
                    GetEntryLDAPConnectionPoolHealthCheck healthCheck = new GetEntryLDAPConnectionPoolHealthCheck(entryDn, timeout.millis(), false, false, false, true, false);
                    pool.setHealthCheck((LDAPConnectionPoolHealthCheck)healthCheck);
                    pool.setHealthCheckIntervalMillis(healthCheckInterval);
                } else {
                    logger.warn((Message)new ParameterizedMessage("[{}] and [{}} have not been specified or are not valid distinguished names,so connection health checking is disabled", (Object)RealmSettings.getFullSettingKey((RealmConfig)config, (Setting)PoolingSessionFactorySettings.BIND_DN), (Object)RealmSettings.getFullSettingKey((RealmConfig)config, (Setting)PoolingSessionFactorySettings.HEALTH_CHECK_DN)));
                }
            }
            success = true;
            LDAPConnectionPool lDAPConnectionPool = pool;
            return lDAPConnectionPool;
        }
        finally {
            if (!success && pool != null) {
                pool.close();
            }
        }
    }

    public final void close() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
        }
    }

    LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }
}

