/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptUtils {
    private static final int minimumPadding = 20;
    private static final byte[] salt = new byte[]{-87, -94, -75, -34, 42, -118, -102, -26};
    private static final int iterationCount = 1024;
    private static final int aesKeyLength = 128;
    private static final String keyAlgorithm = "RSA";
    private static final String passHashAlgorithm = "SHA-512";
    private static final String DEFAULT_PASS_PHRASE = "elasticsearch-license";
    private static final SecureRandom random = new SecureRandom();

    public static PrivateKey readEncryptedPrivateKey(byte[] fileContents) {
        try {
            return CryptUtils.readEncryptedPrivateKey(fileContents, CryptUtils.hashPassPhrase(DEFAULT_PASS_PHRASE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey readEncryptedPublicKey(byte[] fileContents) {
        try {
            return CryptUtils.readEncryptedPublicKey(fileContents, CryptUtils.hashPassPhrase(DEFAULT_PASS_PHRASE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] writeEncryptedPublicKey(PublicKey publicKey) {
        try {
            return CryptUtils.writeEncryptedPublicKey(publicKey, CryptUtils.hashPassPhrase(DEFAULT_PASS_PHRASE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] writeEncryptedPrivateKey(PrivateKey privateKey) {
        try {
            return CryptUtils.writeEncryptedPrivateKey(privateKey, CryptUtils.hashPassPhrase(DEFAULT_PASS_PHRASE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PrivateKey readEncryptedPrivateKey(byte[] fileContents, char[] passPhrase) {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(CryptUtils.decrypt(fileContents, passPhrase));
        try {
            return KeyFactory.getInstance(keyAlgorithm).generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey readEncryptedPublicKey(byte[] fileContents, char[] passPhrase) {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(CryptUtils.decrypt(fileContents, passPhrase));
        try {
            return KeyFactory.getInstance(keyAlgorithm).generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] writeEncryptedPublicKey(PublicKey publicKey, char[] passPhrase) {
        X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        return CryptUtils.encrypt(encodedKeySpec.getEncoded(), passPhrase);
    }

    public static byte[] writeEncryptedPrivateKey(PrivateKey privateKey, char[] passPhrase) {
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return CryptUtils.encrypt(encodedKeySpec.getEncoded(), passPhrase);
    }

    public static byte[] encrypt(byte[] data) {
        try {
            return CryptUtils.encrypt(data, CryptUtils.hashPassPhrase(DEFAULT_PASS_PHRASE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] decrypt(byte[] encryptedData) {
        try {
            return CryptUtils.decrypt(encryptedData, CryptUtils.hashPassPhrase(DEFAULT_PASS_PHRASE));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] encrypt(byte[] data, char[] passPhrase) {
        try {
            Cipher encryptionCipher = CryptUtils.getEncryptionCipher(CryptUtils.getSecretKey(passPhrase));
            return encryptionCipher.doFinal(CryptUtils.pad(data, 20));
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] decrypt(byte[] encryptedData, char[] passPhrase) {
        try {
            Cipher cipher = CryptUtils.getDecryptionCipher(CryptUtils.getSecretKey(passPhrase));
            return CryptUtils.unPad(cipher.doFinal(encryptedData));
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }

    private static SecretKey getSecretKey(char[] passPhrase) throws InvalidKeySpecException {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase, salt, 1024, 128);
            byte[] shortKey = SecretKeyFactory.getInstance("PBEWithSHA1AndDESede").generateSecret(keySpec).getEncoded();
            byte[] intermediaryKey = new byte[16];
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                intermediaryKey[i] = shortKey[j];
                if (++j != shortKey.length) continue;
                j = 0;
            }
            return new SecretKeySpec(intermediaryKey, "AES");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Cipher getEncryptionCipher(SecretKey secretKey) {
        return CryptUtils.getCipher(1, secretKey);
    }

    private static Cipher getDecryptionCipher(SecretKey secretKey) {
        return CryptUtils.getCipher(2, secretKey);
    }

    private static Cipher getCipher(int mode, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(mode, (Key)secretKey, random);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] pad(byte[] bytes, int length) {
        int i;
        if (bytes.length >= length) {
            byte[] out = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, out, 0, bytes.length);
            out[bytes.length] = 1;
            return out;
        }
        byte[] out = new byte[length + 1];
        for (i = 0; i < bytes.length; ++i) {
            out[i] = bytes[i];
        }
        int padded = length - i;
        byte[] fill = new byte[padded - 1];
        random.nextBytes(fill);
        System.arraycopy(fill, 0, out, i, padded - 1);
        out[length] = (byte)(padded + 1);
        return out;
    }

    private static byte[] unPad(byte[] bytes) {
        byte padded = bytes[bytes.length - 1];
        int targetLength = bytes.length - padded;
        byte[] out = new byte[targetLength];
        System.arraycopy(bytes, 0, out, 0, targetLength);
        return out;
    }

    private static char[] hashPassPhrase(String passPhrase) throws NoSuchAlgorithmException {
        byte[] passBytes = passPhrase.getBytes(StandardCharsets.UTF_8);
        byte[] digest = MessageDigest.getInstance(passHashAlgorithm).digest(passBytes);
        return Base64.getEncoder().encodeToString(digest).toCharArray();
    }
}

