/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.DeleteLicenseRequest;
import org.elasticsearch.license.DeleteLicenseResponse;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteLicenseAction
extends TransportMasterNodeAction<DeleteLicenseRequest, DeleteLicenseResponse> {
    private final LicenseService licenseService;

    @Inject
    public TransportDeleteLicenseAction(Settings settings, TransportService transportService, ClusterService clusterService, LicenseService licenseService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/xpack/license/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteLicenseRequest::new);
        this.licenseService = licenseService;
    }

    protected String executor() {
        return "management";
    }

    protected DeleteLicenseResponse newResponse() {
        return new DeleteLicenseResponse();
    }

    protected ClusterBlockException checkBlock(DeleteLicenseRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(DeleteLicenseRequest request, ClusterState state, final ActionListener<DeleteLicenseResponse> listener) throws ElasticsearchException {
        this.licenseService.removeLicense(request, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse clusterStateUpdateResponse) {
                listener.onResponse((Object)new DeleteLicenseResponse(clusterStateUpdateResponse.isAcknowledged()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

