/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class InvalidateTokenRequest
extends ActionRequest {
    private String tokenString;
    private Type tokenType;

    public InvalidateTokenRequest() {
    }

    public InvalidateTokenRequest(String tokenString, Type type) {
        this.tokenString = tokenString;
        this.tokenType = type;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.tokenString)) {
            validationException = ValidateActions.addValidationError((String)"token string must be provided", null);
        }
        if (this.tokenType == null) {
            validationException = ValidateActions.addValidationError((String)"token type must be provided", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    void setTokenString(String token) {
        this.tokenString = token;
    }

    public Type getTokenType() {
        return this.tokenType;
    }

    void setTokenType(Type tokenType) {
        this.tokenType = tokenType;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.tokenString);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeVInt(this.tokenType.ordinal());
        } else if (this.tokenType == Type.REFRESH_TOKEN) {
            throw new IllegalArgumentException("refresh token invalidation cannot be serialized with version [" + out.getVersion() + "]");
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tokenString = in.readString();
        this.tokenType = in.getVersion().onOrAfter(Version.V_6_2_0) ? Type.values()[in.readVInt()] : Type.ACCESS_TOKEN;
    }

    public static enum Type {
        ACCESS_TOKEN,
        REFRESH_TOKEN;

    }
}

