/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.pki;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.support.mapper.CompositeRoleMapperSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class PkiRealmSettings {
    public static final String TYPE = "pki";
    public static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    public static final Setting<Pattern> USERNAME_PATTERN_SETTING = new Setting("username_pattern", "CN=(.*?)(?:,|$)", s -> Pattern.compile(s, 2), new Setting.Property[]{Setting.Property.NodeScope});
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"cache.ttl", (TimeValue)DEFAULT_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final int DEFAULT_MAX_USERS = 100000;
    public static final Setting<Integer> CACHE_MAX_USERS_SETTING = Setting.intSetting((String)"cache.max_users", (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final SSLConfigurationSettings SSL_SETTINGS = SSLConfigurationSettings.withoutPrefix();

    private PkiRealmSettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(USERNAME_PATTERN_SETTING);
        settings.add(CACHE_TTL_SETTING);
        settings.add(CACHE_MAX_USERS_SETTING);
        settings.add(PkiRealmSettings.SSL_SETTINGS.truststorePath);
        settings.add(PkiRealmSettings.SSL_SETTINGS.truststorePassword);
        settings.add(PkiRealmSettings.SSL_SETTINGS.legacyTruststorePassword);
        settings.add(PkiRealmSettings.SSL_SETTINGS.truststoreAlgorithm);
        settings.add(PkiRealmSettings.SSL_SETTINGS.caPaths);
        settings.addAll(CompositeRoleMapperSettings.getSettings());
        return settings;
    }
}

