/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SRVRecord;
import com.unboundid.ldap.sdk.SRVRecordPrioritySet;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.naming.directory.InitialDirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SRVRecordSet
implements Serializable {
    private static final String JNDI_DNS_CONTEXT_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String DNS_ATTR_SRV = "SRV";
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final long serialVersionUID = 7075112952759306499L;
    private final int totalRecords;
    private final List<SRVRecord> allRecords;
    private final List<SRVRecordPrioritySet> recordSets;
    private final long expirationTime;

    SRVRecordSet(long expirationTime, List<SRVRecord> records) {
        this.expirationTime = expirationTime;
        this.allRecords = Collections.unmodifiableList(records);
        this.totalRecords = records.size();
        TreeMap<Long, ArrayList<SRVRecord>> m = new TreeMap<Long, ArrayList<SRVRecord>>();
        for (SRVRecord r : records) {
            Long priority = r.getPriority();
            ArrayList<SRVRecord> l = (ArrayList<SRVRecord>)m.get(priority);
            if (l == null) {
                l = new ArrayList<SRVRecord>(records.size());
                m.put(priority, l);
            }
            l.add(r);
        }
        ArrayList<SRVRecordPrioritySet> l = new ArrayList<SRVRecordPrioritySet>(m.size());
        for (Map.Entry e : m.entrySet()) {
            l.add(new SRVRecordPrioritySet((Long)e.getKey(), (List)e.getValue()));
        }
        this.recordSets = Collections.unmodifiableList(l);
    }

    long getExpirationTime() {
        return this.expirationTime;
    }

    boolean isExpired() {
        return System.currentTimeMillis() >= this.expirationTime;
    }

    List<SRVRecord> getOrderedRecords() {
        ArrayList<SRVRecord> l = new ArrayList<SRVRecord>(this.totalRecords);
        for (SRVRecordPrioritySet s : this.recordSets) {
            l.addAll(s.getOrderedRecords());
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    static SRVRecordSet getRecordSet(String name, Hashtable<String, String> jndiProperties, long ttlMillis) throws LDAPException {
        block15: {
            recordStrings = new ArrayList<String>(10);
            context = null;
            try {
                if (Debug.debugEnabled(DebugType.CONNECT)) {
                    Debug.debug(Level.INFO, DebugType.CONNECT, "Issuing JNDI query to retrieve DNS SRV record '" + name + "' using properties '" + jndiProperties + "'.");
                }
                context = new InitialDirContext(jndiProperties);
                recordAttributes = context.getAttributes(name, SRVRecordSet.ATTRIBUTE_IDS);
                context.close();
                srvAttr = recordAttributes.get("SRV");
                if (srvAttr == null) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SRV_RECORD_SET_NO_RECORDS.get(new Object[]{name}));
                }
                values = srvAttr.getAll();
                while (values.hasMore()) {
                    value = values.next();
                    recordStrings.add(String.valueOf(value));
                }
                values.close();
                var11_11 = null;
                ** if (context == null) goto lbl-1000
            }
            catch (Throwable var10_15) {
                var11_12 = null;
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                throw var10_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    context.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (LDAPException le) {
                    Debug.debugException(le);
                    throw le;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SRV_RECORD_SET_ERROR_QUERYING_DNS.get(new Object[]{name, StaticUtils.getExceptionMessage(e)}), e);
                }
            }
        }
        if (recordStrings.isEmpty()) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SRV_RECORD_SET_NO_RECORDS.get(new Object[]{name}));
        }
        recordList = new ArrayList<SRVRecord>(recordStrings.size());
        for (String s : recordStrings) {
            r = new SRVRecord(s);
            recordList.add(r);
            if (!Debug.debugEnabled(DebugType.CONNECT)) continue;
            Debug.debug(Level.INFO, DebugType.CONNECT, "Decoded DNS SRV record " + r.toString());
        }
        return new SRVRecordSet(System.currentTimeMillis() + ttlMillis, recordList);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(StringBuilder buffer) {
        buffer.append("SRVRecordSet(records={");
        Iterator<SRVRecord> iterator = this.allRecords.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

