/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.listener.LDAPDebuggerRequestHandler;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ProxyRequestHandler;
import com.unboundid.ldap.listener.ToCodeRequestHandler;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.examples.LDAPDebuggerShutdownListener;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.MinimalLogFormatter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.StreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPDebugger
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = -8942937427428190983L;
    private BooleanArgument listenUsingSSL;
    private FileArgument codeLogFile;
    private FileArgument outputFile;
    private IntegerArgument listenPort;
    private LDAPDebuggerShutdownListener shutdownListener;
    private LDAPListener listener;
    private StringArgument listenAddress;

    public static void main(String[] args) {
        ResultCode resultCode = LDAPDebugger.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        LDAPDebugger ldapDebugger = new LDAPDebugger(outStream, errStream);
        return ldapDebugger.runTool(args);
    }

    public LDAPDebugger(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "ldap-debugger";
    }

    @Override
    public String getToolDescription() {
        return "Intercept and decode LDAP communication.";
    }

    @Override
    public String getToolVersion() {
        return "3.2.0";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The address on which to listen for client connections.  If this is not provided, then it will listen on all interfaces.";
        this.listenAddress = new StringArgument(Character.valueOf('a'), "listenAddress", false, 1, "{address}", description);
        this.listenAddress.addLongIdentifier("listen-address");
        parser.addArgument(this.listenAddress);
        description = "The port on which to listen for client connections.  If no value is provided, then a free port will be automatically selected.";
        this.listenPort = new IntegerArgument(Character.valueOf('L'), "listenPort", true, 1, "{port}", description, 0, 65535, 0);
        this.listenPort.addLongIdentifier("listen-port");
        parser.addArgument(this.listenPort);
        description = "Use SSL when accepting client connections.  This is independent of the '--useSSL' option, which applies only to communication between the LDAP debugger and the backend server.";
        this.listenUsingSSL = new BooleanArgument(Character.valueOf('S'), "listenUsingSSL", 1, description);
        this.listenUsingSSL.addLongIdentifier("listen-using-ssl");
        parser.addArgument(this.listenUsingSSL);
        description = "The path to the output file to be written.  If no value is provided, then the output will be written to standard output.";
        this.outputFile = new FileArgument(Character.valueOf('f'), "outputFile", false, 1, "{path}", description, false, true, true, false);
        this.outputFile.addLongIdentifier("output-file");
        parser.addArgument(this.outputFile);
        description = "The path to the a code log file to be written.  If a value is provided, then the tool will generate sample code that corresponds to the requests received from clients.  If no value is provided, then no code log will be generated.";
        this.codeLogFile = new FileArgument(Character.valueOf('c'), "codeLogFile", false, 1, "{path}", description, false, true, true, false);
        this.codeLogFile.addLongIdentifier("code-log-file");
        parser.addArgument(this.codeLogFile);
    }

    @Override
    public ResultCode doToolProcessing() {
        StreamHandler logHandler;
        ProxyRequestHandler proxyHandler;
        try {
            proxyHandler = new ProxyRequestHandler(this.createServerSet());
        }
        catch (LDAPException le) {
            this.err("Unable to prepare to connect to the target server:  ", le.getMessage());
            return le.getResultCode();
        }
        if (this.outputFile.isPresent()) {
            try {
                logHandler = new FileHandler(this.outputFile.getValue().getAbsolutePath());
            }
            catch (IOException ioe) {
                this.err("Unable to open the output file for writing:  ", StaticUtils.getExceptionMessage(ioe));
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            logHandler = new ConsoleHandler();
        }
        logHandler.setLevel(Level.INFO);
        logHandler.setFormatter(new MinimalLogFormatter("'['dd/MMM/yyyy:HH:mm:ss Z']'", false, false, true));
        LDAPListenerRequestHandler requestHandler = new LDAPDebuggerRequestHandler(logHandler, proxyHandler);
        if (this.codeLogFile.isPresent()) {
            try {
                requestHandler = new ToCodeRequestHandler(this.codeLogFile.getValue(), true, requestHandler);
            }
            catch (Exception e) {
                this.err("Unable to open code log file '", this.codeLogFile.getValue().getAbsolutePath(), "' for writing:  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        LDAPListenerConfig config = new LDAPListenerConfig(this.listenPort.getValue(), requestHandler);
        if (this.listenAddress.isPresent()) {
            try {
                config.setListenAddress(InetAddress.getByName(this.listenAddress.getValue()));
            }
            catch (Exception e) {
                this.err("Unable to resolve '", this.listenAddress.getValue(), "' as a valid address:  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.PARAM_ERROR;
            }
        }
        if (this.listenUsingSSL.isPresent()) {
            try {
                config.setServerSocketFactory(this.createSSLUtil(true).createSSLServerSocketFactory());
            }
            catch (Exception e) {
                this.err("Unable to create a server socket factory to accept SSL-based client connections:  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        this.listener = new LDAPListener(config);
        try {
            this.listener.startListening();
        }
        catch (Exception e) {
            this.err("Unable to start listening for client connections:  ", StaticUtils.getExceptionMessage(e));
            return ResultCode.LOCAL_ERROR;
        }
        int port = this.listener.getListenPort();
        while (port <= 0) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            port = this.listener.getListenPort();
        }
        if (this.listenUsingSSL.isPresent()) {
            this.out("Listening for SSL-based LDAP client connections on port ", port);
        } else {
            this.out("Listening for LDAP client connections on port ", port);
        }
        this.shutdownListener = new LDAPDebuggerShutdownListener(this.listener, logHandler);
        Runtime.getRuntime().addShutdownHook(this.shutdownListener);
        return ResultCode.SUCCESS;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--listenPort", "1389", "--outputFile", "/tmp/ldap-debugger.log"};
        String description = "Listen for client connections on port 1389 on all interfaces and forward any traffic received to server.example.com:389.  The decoded LDAP communication will be written to the /tmp/ldap-debugger.log log file.";
        examples.put(args, "Listen for client connections on port 1389 on all interfaces and forward any traffic received to server.example.com:389.  The decoded LDAP communication will be written to the /tmp/ldap-debugger.log log file.");
        return examples;
    }

    public LDAPListener getListener() {
        return this.listener;
    }

    public void shutDown() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownListener);
        this.shutdownListener.run();
    }
}

