/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.ResultCodeCounter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SearchRateAsyncListener
implements AsyncSearchResultListener {
    private static final long serialVersionUID = 4929527281011834420L;
    private final AtomicLong entryCounter;
    private final AtomicLong errorCounter;
    private final AtomicLong searchCounter;
    private final AtomicLong searchDurations;
    private final AtomicReference<ResultCode> resultCode;
    private final long startTime;
    private final ResultCodeCounter rcCounter;
    private final Semaphore asyncSemaphore;

    SearchRateAsyncListener(AtomicLong searchCounter, AtomicLong entryCounter, AtomicLong searchDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, Semaphore asyncSemaphore, AtomicReference<ResultCode> resultCode) {
        this.searchCounter = searchCounter;
        this.entryCounter = entryCounter;
        this.searchDurations = searchDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.asyncSemaphore = asyncSemaphore;
        this.resultCode = resultCode;
        this.startTime = System.nanoTime();
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
    }

    @Override
    public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
        this.searchDurations.addAndGet(System.nanoTime() - this.startTime);
        if (this.asyncSemaphore != null) {
            this.asyncSemaphore.release();
        }
        this.searchCounter.incrementAndGet();
        this.entryCounter.addAndGet(searchResult.getEntryCount());
        ResultCode rc = searchResult.getResultCode();
        if (rc != ResultCode.SUCCESS) {
            this.errorCounter.incrementAndGet();
            this.rcCounter.increment(rc);
            this.resultCode.compareAndSet(null, rc);
        }
    }
}

