/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReaderChangeRecordTranslator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AggregateLDIFReaderChangeRecordTranslator
implements LDIFReaderChangeRecordTranslator {
    private final List<LDIFReaderChangeRecordTranslator> translators;

    public AggregateLDIFReaderChangeRecordTranslator(LDIFReaderChangeRecordTranslator ... translators) {
        this(StaticUtils.toList(translators));
    }

    public AggregateLDIFReaderChangeRecordTranslator(Collection<? extends LDIFReaderChangeRecordTranslator> translators) {
        this.translators = translators == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<LDIFReaderChangeRecordTranslator>(translators));
    }

    @Override
    public LDIFChangeRecord translate(LDIFChangeRecord original, long firstLineNumber) throws LDIFException {
        if (original == null) {
            return null;
        }
        LDIFChangeRecord r = original;
        for (LDIFReaderChangeRecordTranslator t : this.translators) {
            r = t.translate(r, firstLineNumber);
            if (r != null) continue;
            return null;
        }
        return r;
    }
}

