/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.input.http.HttpInput;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.XContentFilterKeysUtils;

public class ExecutableHttpInput
extends ExecutableInput<HttpInput, HttpInput.Result> {
    private final HttpClient client;
    private final TextTemplateEngine templateEngine;

    public ExecutableHttpInput(HttpInput input, Logger logger, HttpClient client, TextTemplateEngine templateEngine) {
        super((Input)input, logger);
        this.client = client;
        this.templateEngine = templateEngine;
    }

    public HttpInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        HttpRequest request = null;
        try {
            Map<String, Object> model = Variables.createCtxModel(ctx, payload);
            request = ((HttpInput)this.input).getRequest().render(this.templateEngine, model);
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for watch [{}], reason [{}]", (Object)"http", (Object)ctx.watch().id(), (Object)e.getMessage());
            return new HttpInput.Result(request, e);
        }
    }

    HttpInput.Result doExecute(WatchExecutionContext ctx, HttpRequest request) throws Exception {
        HashMap<String, Object> payloadMap;
        HttpResponse response;
        block24: {
            XContentType contentType;
            response = this.client.execute(request);
            Map<String, List<String>> headers = response.headers();
            payloadMap = new HashMap<String, Object>();
            payloadMap.put("_status_code", response.status());
            if (!headers.isEmpty()) {
                payloadMap.put("_headers", headers);
            }
            if (!response.hasContent()) {
                return new HttpInput.Result(request, response.status(), (Payload)new Payload.Simple(payloadMap));
            }
            XContentType responseContentType = response.xContentType();
            if (((HttpInput)this.input).getExpectedResponseXContentType() == null) {
                contentType = responseContentType != null ? responseContentType : XContentHelper.xContentType((BytesReference)response.body());
            } else {
                contentType = ((HttpInput)this.input).getExpectedResponseXContentType().contentType();
                if (responseContentType != contentType) {
                    this.logger.warn("[{}] [{}] input expected content type [{}] but read [{}] from headers, using expected one", (Object)this.type(), (Object)ctx.id(), (Object)((HttpInput)this.input).getExpectedResponseXContentType(), (Object)responseContentType);
                }
            }
            if (contentType != null) {
                try (StreamInput stream = response.body().streamInput();
                     XContentParser parser = contentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    if (((HttpInput)this.input).getExtractKeys() != null) {
                        payloadMap.putAll(XContentFilterKeysUtils.filterMapOrdered(((HttpInput)this.input).getExtractKeys(), parser));
                    } else {
                        XContentParser.Token token = parser.nextToken();
                        if (token == XContentParser.Token.START_ARRAY) {
                            payloadMap.put("data", parser.listOrderedMap());
                        } else {
                            payloadMap.putAll(parser.mapOrdered());
                        }
                    }
                    break block24;
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("could not parse response body [{}] it does not appear to be [{}]", new Object[]{this.type(), ctx.id(), response.body().utf8ToString(), contentType.shortName()});
                }
            }
            payloadMap.put("_value", response.body().utf8ToString());
        }
        return new HttpInput.Result(request, response.status(), (Payload)new Payload.Simple(payloadMap));
    }
}

