/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email.attachment;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpMethod;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.common.http.auth.HttpAuth;
import org.elasticsearch.xpack.watcher.common.http.auth.HttpAuthRegistry;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.email.Attachment;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.ReportingAttachment;
import org.elasticsearch.xpack.watcher.support.Variables;

public class ReportingAttachmentParser
implements EmailAttachmentParser<ReportingAttachment> {
    public static final String TYPE = "reporting";
    public static final Setting<TimeValue> INTERVAL_SETTING = Setting.timeSetting((String)"xpack.notification.reporting.interval", (TimeValue)TimeValue.timeValueSeconds((long)15L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> RETRIES_SETTING = Setting.intSetting((String)"xpack.notification.reporting.retries", (int)40, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final ObjectParser<Builder, AuthParseContext> PARSER = new ObjectParser("reporting_attachment");
    private static final ObjectParser<KibanaReportingPayload, Void> PAYLOAD_PARSER = new ObjectParser("reporting_attachment_kibana_payload", true, null);
    private final Logger logger;
    private final TimeValue interval;
    private final int retries;
    private HttpClient httpClient;
    private final TextTemplateEngine templateEngine;
    private HttpAuthRegistry authRegistry;

    public ReportingAttachmentParser(Settings settings, HttpClient httpClient, TextTemplateEngine templateEngine, HttpAuthRegistry authRegistry) {
        this.interval = (TimeValue)INTERVAL_SETTING.get(settings);
        this.retries = (Integer)RETRIES_SETTING.get(settings);
        this.httpClient = httpClient;
        this.templateEngine = templateEngine;
        this.authRegistry = authRegistry;
        this.logger = Loggers.getLogger(this.getClass());
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public ReportingAttachment parse(String id, XContentParser parser) throws IOException {
        Builder builder = new Builder(id);
        PARSER.parse(parser, (Object)builder, (Object)new AuthParseContext(this.authRegistry));
        return builder.build();
    }

    @Override
    public Attachment toAttachment(WatchExecutionContext context, Payload payload, ReportingAttachment attachment) throws IOException {
        Map<String, Object> model = Variables.createCtxModel(context, payload);
        String initialUrl = this.templateEngine.render(new TextTemplate(attachment.url()), model);
        HttpRequestTemplate requestTemplate = HttpRequestTemplate.builder(initialUrl).connectionTimeout(TimeValue.timeValueSeconds((long)15L)).readTimeout(TimeValue.timeValueSeconds((long)15L)).method(HttpMethod.POST).auth(attachment.auth()).proxy(attachment.proxy()).putHeader("kbn-xsrf", new TextTemplate(TYPE)).build();
        HttpRequest request = requestTemplate.render(this.templateEngine, model);
        HttpResponse reportGenerationResponse = this.requestReportGeneration(context.watch().id(), attachment.id(), request);
        String path = this.extractIdFromJson(context.watch().id(), attachment.id(), reportGenerationResponse.body());
        HttpRequestTemplate pollingRequestTemplate = HttpRequestTemplate.builder(request.host(), request.port()).connectionTimeout(TimeValue.timeValueSeconds((long)10L)).readTimeout(TimeValue.timeValueSeconds((long)10L)).auth(attachment.auth()).path(path).scheme(request.scheme()).proxy(attachment.proxy()).putHeader("kbn-xsrf", new TextTemplate(TYPE)).build();
        HttpRequest pollingRequest = pollingRequestTemplate.render(this.templateEngine, model);
        int maxRetries = attachment.retries() != null ? attachment.retries() : this.retries;
        long sleepMillis = this.getSleepMillis(context, attachment);
        for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
            this.sleep(sleepMillis, context, attachment);
            HttpResponse response = this.httpClient.execute(pollingRequest);
            if (response.status() == 503) {
                this.logger.trace("Watch[{}] reporting[{}] pdf is not ready, polling in [{}] again", (Object)context.watch().id(), (Object)attachment.id(), (Object)TimeValue.timeValueMillis((long)sleepMillis));
                continue;
            }
            if (response.status() >= 400) {
                String body = response.body() != null ? response.body().utf8ToString() : null;
                throw new ElasticsearchException("Watch[{}] reporting[{}] Error when polling pdf from host[{}], port[{}], method[{}], path[{}], status[{}], body[{}]", new Object[]{context.watch().id(), attachment.id(), request.host(), request.port(), request.method(), request.path(), response.status(), body});
            }
            if (response.status() == 200) {
                return new Attachment.Bytes(attachment.id(), BytesReference.toBytes((BytesReference)response.body()), response.contentType(), attachment.inline());
            }
            String body = response.body() != null ? response.body().utf8ToString() : null;
            String message = LoggerMessageFormat.format((String)"", (String)"Watch[{}] reporting[{}] Unexpected status code host[{}], port[{}], method[{}], path[{}], status[{}], body[{}]", (Object[])new Object[]{context.watch().id(), attachment.id(), request.host(), request.port(), request.method(), request.path(), response.status(), body});
            throw new IllegalStateException(message);
        }
        throw new ElasticsearchException("Watch[{}] reporting[{}]: Aborting due to maximum number of retries hit [{}]", new Object[]{context.watch().id(), attachment.id(), maxRetries});
    }

    private void sleep(long sleepMillis, WatchExecutionContext context, ReportingAttachment attachment) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchException("Watch[{}] reporting[{}] thread was interrupted, while waiting for polling. Aborting.", new Object[]{context.watch().id(), attachment.id()});
        }
    }

    private long getSleepMillis(WatchExecutionContext context, ReportingAttachment attachment) {
        long sleepMillis;
        if (attachment.interval() == null) {
            sleepMillis = this.interval.millis();
            this.logger.trace("Watch[{}] reporting[{}] invalid interval configuration [{}], using configured default [{}]", (Object)context.watch().id(), (Object)attachment.id(), (Object)attachment.interval(), (Object)this.interval);
        } else {
            sleepMillis = attachment.interval().millis();
        }
        return sleepMillis;
    }

    private HttpResponse requestReportGeneration(String watchId, String attachmentId, HttpRequest request) throws IOException {
        HttpResponse response = this.httpClient.execute(request);
        if (response.status() != 200) {
            throw new ElasticsearchException("Watch[{}] reporting[{}] Error response when trying to trigger reporting generation host[{}], port[{}] method[{}], path[{}], status[{}]", new Object[]{watchId, attachmentId, request.host(), request.port(), request.method(), request.path(), response.status()});
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    private String extractIdFromJson(String watchId, String attachmentId, BytesReference body) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        PARSER.declareInt(Builder::retries, ReportingAttachment.RETRIES);
        PARSER.declareBoolean(Builder::inline, ReportingAttachment.INLINE);
        PARSER.declareString(Builder::interval, ReportingAttachment.INTERVAL);
        PARSER.declareString(Builder::url, ReportingAttachment.URL);
        PARSER.declareObjectOrDefault(Builder::auth, (p, s) -> s.parseAuth((XContentParser)p), () -> null, ReportingAttachment.AUTH);
        PARSER.declareObjectOrDefault(Builder::proxy, (p, s) -> s.parseProxy((XContentParser)p), () -> null, ReportingAttachment.PROXY);
        PAYLOAD_PARSER.declareString(KibanaReportingPayload::setPath, new ParseField("path", new String[0]));
    }

    static class Builder {
        private final String id;
        private boolean inline;
        private String url;
        private TimeValue interval;
        private Integer retries;
        private HttpAuth auth;
        private HttpProxy proxy;

        Builder(String id) {
            this.id = id;
        }

        Builder url(String url) {
            this.url = url;
            return this;
        }

        Builder interval(String waitTime) {
            this.interval = TimeValue.parseTimeValue((String)waitTime, (String)"attachment.reporting.interval");
            return this;
        }

        Builder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        Builder inline(boolean inline) {
            this.inline = inline;
            return this;
        }

        Builder auth(HttpAuth auth) {
            this.auth = auth;
            return this;
        }

        Builder proxy(HttpProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        ReportingAttachment build() {
            return new ReportingAttachment(this.id, this.url, this.inline, this.interval, this.retries, this.auth, this.proxy);
        }
    }

    static class KibanaReportingPayload {
        private String path;

        KibanaReportingPayload() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    private static class AuthParseContext {
        private final HttpAuthRegistry authRegistry;

        AuthParseContext(HttpAuthRegistry authRegistry) {
            this.authRegistry = authRegistry;
        }

        HttpAuth parseAuth(XContentParser parser) {
            try {
                return this.authRegistry.parse(parser);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        HttpProxy parseProxy(XContentParser parser) {
            try {
                return HttpProxy.parse(parser);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

