/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.index;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.sql.analysis.index.EsIndex;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.analysis.index.MappingException;
import org.elasticsearch.xpack.sql.type.EsField;
import org.elasticsearch.xpack.sql.type.Types;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class IndexResolver {
    private final Client client;
    private final String clusterName;

    public IndexResolver(Client client, String clusterName) {
        this.client = client;
        this.clusterName = clusterName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void resolveNames(String indexWildcard, String javaRegex, EnumSet<IndexType> types, ActionListener<Set<IndexInfo>> listener) {
        boolean retrieveIndices;
        boolean retrieveAliases = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.ALIAS);
        boolean bl = retrieveIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.INDEX);
        if (retrieveAliases) {
            GetAliasesRequest aliasRequest = ((GetAliasesRequest)new GetAliasesRequest().local(true)).aliases(new String[]{indexWildcard}).indicesOptions(IndicesOptions.lenientExpandOpen());
            this.client.admin().indices().getAliases(aliasRequest, ActionListener.wrap(aliases -> this.resolveIndices(indexWildcard, javaRegex, (GetAliasesResponse)aliases, retrieveIndices, listener), ex -> {
                if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                    this.resolveIndices(indexWildcard, javaRegex, null, retrieveIndices, listener);
                } else {
                    listener.onFailure(ex);
                }
            }));
        } else {
            this.resolveIndices(indexWildcard, javaRegex, null, retrieveIndices, listener);
        }
    }

    private void resolveIndices(String indexWildcard, String javaRegex, GetAliasesResponse aliases, boolean retrieveIndices, ActionListener<Set<IndexInfo>> listener) {
        if (retrieveIndices) {
            GetIndexRequest indexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().local(true)).indices(new String[]{indexWildcard})).indicesOptions(IndicesOptions.lenientExpandOpen());
            this.client.admin().indices().getIndex(indexRequest, ActionListener.wrap(indices -> this.filterResults(indexWildcard, javaRegex, aliases, (GetIndexResponse)indices, listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.filterResults(indexWildcard, javaRegex, aliases, null, listener);
        }
    }

    private void filterResults(String indexWildcard, String javaRegex, GetAliasesResponse aliases, GetIndexResponse indices, ActionListener<Set<IndexInfo>> listener) {
        String[] indicesNames;
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<IndexInfo> result = new TreeSet<IndexInfo>(Comparator.comparing(IndexInfo::name));
        if (aliases != null) {
            for (ObjectCursor cursor : aliases.getAliases().values()) {
                for (AliasMetaData amd : (List)cursor.value) {
                    String alias = amd.alias();
                    if (alias == null || pattern != null && !pattern.matcher(alias).matches()) continue;
                    result.add(new IndexInfo(alias, IndexType.ALIAS));
                }
            }
        }
        String[] stringArray = indicesNames = indices != null ? indices.indices() : null;
        if (indicesNames != null) {
            for (String indexName : indicesNames) {
                if (pattern != null && !pattern.matcher(indexName).matches()) continue;
                result.add(new IndexInfo(indexName, IndexType.INDEX));
            }
        }
        listener.onResponse(result);
    }

    public void resolveWithSameMapping(String indexWildcard, String javaRegex, ActionListener<IndexResolution> listener) {
        GetIndexRequest getIndexRequest = IndexResolver.createGetIndexRequest(indexWildcard);
        this.client.admin().indices().getIndex(getIndexRequest, ActionListener.wrap(response -> {
            List<IndexResolution> resolutions;
            ImmutableOpenMap mappings = response.getMappings();
            if (mappings.size() > 0) {
                resolutions = new ArrayList(mappings.size());
                Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
                for (ObjectObjectCursor indexMappings : mappings) {
                    String concreteIndex = (String)indexMappings.key;
                    if (pattern != null && !pattern.matcher(concreteIndex).matches()) continue;
                    resolutions.add(IndexResolver.buildGetIndexResult(concreteIndex, concreteIndex, (ImmutableOpenMap<String, MappingMetaData>)((ImmutableOpenMap)indexMappings.value)));
                }
            } else {
                resolutions = Collections.emptyList();
            }
            listener.onResponse((Object)IndexResolver.merge(resolutions, indexWildcard));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static IndexResolution merge(List<IndexResolution> resolutions, String indexWildcard) {
        IndexResolution merged = null;
        for (IndexResolution resolution : resolutions) {
            if (!resolution.isValid()) {
                return resolution;
            }
            if (merged == null) {
                merged = resolution;
            }
            if (merged.get().mapping().equals(resolution.get().mapping())) continue;
            return IndexResolution.invalid("[" + indexWildcard + "] points to indices [" + resolution.get().name() + "] and [" + resolution.get().name() + "] which have different mappings. When using multiple indices, the mappings must be identical.");
        }
        merged = merged != null ? IndexResolution.valid(new EsIndex(indexWildcard, merged.get().mapping())) : IndexResolution.notFound(indexWildcard);
        return merged;
    }

    public void resolveAsSeparateMappings(String indexWildcard, String javaRegex, ActionListener<List<EsIndex>> listener) {
        GetIndexRequest getIndexRequest = IndexResolver.createGetIndexRequest(indexWildcard);
        this.client.admin().indices().getIndex(getIndexRequest, ActionListener.wrap(getIndexResponse -> {
            ImmutableOpenMap mappings = getIndexResponse.getMappings();
            ArrayList<EsIndex> results = new ArrayList<EsIndex>(mappings.size());
            Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
            for (ObjectObjectCursor indexMappings : mappings) {
                IndexResolution getIndexResult;
                String concreteIndex = (String)indexMappings.key;
                if (pattern != null && !pattern.matcher(concreteIndex).matches() || !(getIndexResult = IndexResolver.buildGetIndexResult(concreteIndex, concreteIndex, (ImmutableOpenMap<String, MappingMetaData>)((ImmutableOpenMap)indexMappings.value))).isValid()) continue;
                results.add(getIndexResult.get());
            }
            results.sort(Comparator.comparing(EsIndex::name));
            listener.onResponse(results);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static GetIndexRequest createGetIndexRequest(String index) {
        return (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().local(true)).indices(new String[]{index})).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.MAPPINGS}).indicesOptions(IndicesOptions.lenientExpandOpen());
    }

    private static IndexResolution buildGetIndexResult(String concreteIndex, String indexOrAlias, ImmutableOpenMap<String, MappingMetaData> mappings) {
        MappingMetaData singleType = null;
        ArrayList<String> typeNames = null;
        for (ObjectObjectCursor type : mappings) {
            if ("_default_".equals(type.key)) continue;
            if (singleType != null) {
                if (typeNames == null) {
                    typeNames = new ArrayList<String>();
                    typeNames.add(singleType.type());
                }
                typeNames.add((String)type.key);
            }
            singleType = (MappingMetaData)type.value;
        }
        if (singleType == null) {
            return IndexResolution.invalid("[" + indexOrAlias + "] doesn't have any types so it is incompatible with sql");
        }
        if (typeNames != null) {
            Collections.sort(typeNames);
            return IndexResolution.invalid("[" + indexOrAlias + "] contains more than one type " + typeNames + " so it is incompatible with sql");
        }
        try {
            Map<String, EsField> mapping = Types.fromEs(singleType.sourceAsMap());
            return IndexResolution.valid(new EsIndex(indexOrAlias, mapping));
        }
        catch (MappingException ex) {
            return IndexResolution.invalid(ex.getMessage());
        }
    }

    public static class IndexInfo {
        private final String name;
        private final IndexType type;

        public IndexInfo(String name, IndexType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public IndexType type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IndexInfo other = (IndexInfo)obj;
            return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type);
        }
    }

    public static enum IndexType {
        INDEX("BASE TABLE"),
        ALIAS("ALIAS"),
        UNKNOWN("UKNOWN");

        public static final EnumSet<IndexType> VALID;
        private final String toSql;

        private IndexType(String sql) {
            this.toSql = sql;
        }

        public String toSql() {
            return this.toSql;
        }

        public static IndexType from(String name) {
            if (name != null) {
                name = name.toUpperCase(Locale.ROOT);
                for (IndexType type : VALID) {
                    if (!type.toSql.equals(name)) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }

        static {
            VALID = EnumSet.of(INDEX, ALIAS);
        }
    }
}

