/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.UnaryExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class Order
extends UnaryExpression {
    private final OrderDirection direction;

    public Order(Location location, Expression child, OrderDirection direction) {
        super(location, child);
        this.direction = direction;
    }

    @Override
    protected NodeInfo<Order> info() {
        return NodeInfo.create(this, Order::new, this.child(), this.direction);
    }

    @Override
    protected UnaryExpression replaceChild(Expression newChild) {
        return new Order(this.location(), newChild, this.direction);
    }

    public OrderDirection direction() {
        return this.direction;
    }

    @Override
    public boolean foldable() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.child(), this.direction});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.child(), other.child());
    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }
}

