/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;

public class DateTimeProcessor
implements Processor {
    public static final String NAME = "dt";
    private final DateTimeExtractor extractor;
    private final TimeZone timeZone;

    public DateTimeProcessor(DateTimeExtractor extractor, TimeZone timeZone) {
        this.extractor = extractor;
        this.timeZone = timeZone;
    }

    public DateTimeProcessor(StreamInput in) throws IOException {
        this.extractor = (DateTimeExtractor)in.readEnum(DateTimeExtractor.class);
        this.timeZone = TimeZone.getTimeZone(in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.extractor);
        out.writeString(this.timeZone.getID());
    }

    public String getWriteableName() {
        return NAME;
    }

    DateTimeExtractor extractor() {
        return this.extractor;
    }

    @Override
    public Object process(Object l) {
        if (l == null) {
            return null;
        }
        if (!(l instanceof ReadableDateTime)) {
            throw new SqlIllegalArgumentException("A date/time is required; received {}", l);
        }
        ReadableDateTime dt = (ReadableDateTime)l;
        if (!TimeZone.getTimeZone("UTC").equals(this.timeZone)) {
            dt = dt.toDateTime().withZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
        }
        return this.extractor.extract(dt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extractor, this.timeZone});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DateTimeProcessor other = (DateTimeProcessor)obj;
        return Objects.equals((Object)this.extractor, (Object)other.extractor) && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return this.extractor.toString();
    }

    public static enum DateTimeExtractor {
        DAY_OF_MONTH(DateTimeFieldType.dayOfMonth()),
        DAY_OF_WEEK(DateTimeFieldType.dayOfWeek()),
        DAY_OF_YEAR(DateTimeFieldType.dayOfYear()),
        HOUR_OF_DAY(DateTimeFieldType.hourOfDay()),
        MINUTE_OF_DAY(DateTimeFieldType.minuteOfDay()),
        MINUTE_OF_HOUR(DateTimeFieldType.minuteOfHour()),
        MONTH_OF_YEAR(DateTimeFieldType.monthOfYear()),
        SECOND_OF_MINUTE(DateTimeFieldType.secondOfMinute()),
        WEEK_OF_YEAR(DateTimeFieldType.weekOfWeekyear()),
        YEAR(DateTimeFieldType.year());

        private final DateTimeFieldType field;

        private DateTimeExtractor(DateTimeFieldType field) {
            this.field = field;
        }

        public int extract(ReadableDateTime dt) {
            return dt.get(this.field);
        }
    }
}

