/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.BinaryProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class BinaryMathProcessorDefinition
extends BinaryProcessorDefinition {
    private final BinaryMathProcessor.BinaryMathOperation operation;

    public BinaryMathProcessorDefinition(Location location, Expression expression, ProcessorDefinition left, ProcessorDefinition right, BinaryMathProcessor.BinaryMathOperation operation) {
        super(location, expression, left, right);
        this.operation = operation;
    }

    @Override
    protected NodeInfo<BinaryMathProcessorDefinition> info() {
        return NodeInfo.create(this, BinaryMathProcessorDefinition::new, this.expression(), this.left(), this.right(), this.operation);
    }

    public BinaryMathProcessor.BinaryMathOperation operation() {
        return this.operation;
    }

    @Override
    protected BinaryProcessorDefinition replaceChildren(ProcessorDefinition left, ProcessorDefinition right) {
        return new BinaryMathProcessorDefinition(this.location(), this.expression(), left, right, this.operation);
    }

    @Override
    public BinaryMathProcessor asProcessor() {
        return new BinaryMathProcessor(this.left().asProcessor(), this.right().asProcessor(), this.operation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryMathProcessorDefinition other = (BinaryMathProcessorDefinition)obj;
        return Objects.equals(this.operation, other.operation) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }
}

