/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.ChainingProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public final class UnaryProcessorDefinition
extends ProcessorDefinition {
    private final ProcessorDefinition child;
    private final Processor action;

    public UnaryProcessorDefinition(Location location, Expression expression, ProcessorDefinition child, Processor action) {
        super(location, expression, Collections.singletonList(child));
        this.child = child;
        this.action = action;
    }

    @Override
    protected NodeInfo<UnaryProcessorDefinition> info() {
        return NodeInfo.create(this, UnaryProcessorDefinition::new, this.expression(), this.child, this.action);
    }

    @Override
    public ProcessorDefinition replaceChildren(List<ProcessorDefinition> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new UnaryProcessorDefinition(this.location(), this.expression(), newChildren.get(0), this.action);
    }

    public ProcessorDefinition child() {
        return this.child;
    }

    public Processor action() {
        return this.action;
    }

    @Override
    public boolean resolved() {
        return this.child.resolved();
    }

    @Override
    public Processor asProcessor() {
        return new ChainingProcessor(this.child.asProcessor(), this.action);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.child.supportedByAggsOnlyQuery();
    }

    @Override
    public ProcessorDefinition resolveAttributes(ProcessorDefinition.AttributeResolver resolver) {
        ProcessorDefinition newChild = this.child.resolveAttributes(resolver);
        if (newChild == this.child) {
            return this;
        }
        return new UnaryProcessorDefinition(this.location(), this.expression(), newChild, this.action);
    }

    @Override
    public void collectFields(SqlSourceBuilder sourceBuilder) {
        this.child.collectFields(sourceBuilder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression(), this.child, this.action);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryProcessorDefinition other = (UnaryProcessorDefinition)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.child, other.child) && Objects.equals(this.expression(), other.expression());
    }
}

