/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.tree.Location;

public class NestedQuery
extends Query {
    private static final int MAX_INNER_HITS = 99;
    private static final List<String> NO_STORED_FIELD = Collections.singletonList("_none_");
    private final String path;
    private final Map<String, Boolean> fields;
    private final Query child;

    public NestedQuery(Location location, String path, Query child) {
        this(location, path, Collections.emptyMap(), child);
    }

    public NestedQuery(Location location, String path, Map<String, Boolean> fields, Query child) {
        super(location);
        if (path == null) {
            throw new IllegalArgumentException("path is required");
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields is required");
        }
        if (child == null) {
            throw new IllegalArgumentException("child is required");
        }
        this.path = path;
        this.fields = fields;
        this.child = child;
    }

    @Override
    public boolean containsNestedField(String path, String field) {
        boolean iContainThisField = this.path.equals(path) && this.fields.containsKey(field);
        boolean myChildContainsThisField = this.child.containsNestedField(path, field);
        return iContainThisField || myChildContainsThisField;
    }

    @Override
    public Query addNestedField(String path, String field, boolean hasDocValues) {
        if (!this.path.equals(path)) {
            Query rewrittenChild = this.child.addNestedField(path, field, hasDocValues);
            if (rewrittenChild == this.child) {
                return this;
            }
            return new NestedQuery(this.location(), path, this.fields, rewrittenChild);
        }
        if (this.fields.containsKey(field)) {
            return this;
        }
        HashMap<String, Boolean> newFields = new HashMap<String, Boolean>(this.fields.size() + 1);
        newFields.putAll(this.fields);
        newFields.put(field, hasDocValues);
        return new NestedQuery(this.location(), path, Collections.unmodifiableMap(newFields), this.child);
    }

    @Override
    public void enrichNestedSort(NestedSortBuilder sort) {
        this.child.enrichNestedSort(sort);
        if (!sort.getPath().equals(this.path)) {
            return;
        }
        QueryBuilder childAsBuilder = this.child.asBuilder();
        if (sort.getFilter() != null && !sort.getFilter().equals(childAsBuilder)) {
            throw new SqlIllegalArgumentException("nested query should have been grouped in one place");
        }
        sort.setFilter(childAsBuilder);
    }

    @Override
    public QueryBuilder asBuilder() {
        NestedQueryBuilder query = QueryBuilders.nestedQuery((String)this.path, (QueryBuilder)this.child.asBuilder(), (ScoreMode)ScoreMode.None);
        if (!this.fields.isEmpty()) {
            InnerHitBuilder ihb = new InnerHitBuilder();
            ihb.setSize(0);
            ihb.setSize(99);
            boolean noSourceNeeded = true;
            ArrayList<String> sourceFields = new ArrayList<String>();
            for (Map.Entry<String, Boolean> entry : this.fields.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    ihb.addDocValueField(entry.getKey());
                    continue;
                }
                sourceFields.add(entry.getKey());
                noSourceNeeded = false;
            }
            if (noSourceNeeded) {
                ihb.setFetchSourceContext(FetchSourceContext.DO_NOT_FETCH_SOURCE);
                ihb.setStoredFieldNames(NO_STORED_FIELD);
            } else {
                ihb.setFetchSourceContext(new FetchSourceContext(true, sourceFields.toArray(new String[sourceFields.size()]), null));
            }
            query.innerHit(ihb);
        }
        return query;
    }

    String path() {
        return this.path;
    }

    Map<String, Boolean> fields() {
        return this.fields;
    }

    Query child() {
        return this.child;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.fields, this.child);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NestedQuery other = (NestedQuery)obj;
        return this.path.equals(other.path) && this.fields.equals(other.fields) && this.child.equals(other.child);
    }

    @Override
    protected String innerToString() {
        return this.path + "." + this.fields + "[" + this.child + "]";
    }
}

