/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.plugin.ColumnInfo;
import org.elasticsearch.xpack.sql.plugin.SqlQueryRequest;
import org.joda.time.ReadableDateTime;

public class SqlQueryResponse
extends ActionResponse
implements ToXContentObject {
    public static final ConstructingObjectParser<SqlQueryResponse, Void> PARSER = new ConstructingObjectParser("sql", true, objects -> new SqlQueryResponse(objects[0] == null ? "" : (String)objects[0], (List)objects[1], (List)objects[2]));
    public static final ParseField CURSOR = new ParseField("cursor", new String[0]);
    public static final ParseField COLUMNS = new ParseField("columns", new String[0]);
    public static final ParseField ROWS = new ParseField("rows", new String[0]);
    private String cursor;
    private List<ColumnInfo> columns;
    private List<List<Object>> rows;

    public SqlQueryResponse() {
    }

    public SqlQueryResponse(String cursor, @Nullable List<ColumnInfo> columns, List<List<Object>> rows) {
        this.cursor = cursor;
        this.columns = columns;
        this.rows = rows;
    }

    public String cursor() {
        return this.cursor;
    }

    public long size() {
        return this.rows.size();
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public SqlQueryResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public SqlQueryResponse columns(List<ColumnInfo> columns) {
        this.columns = columns;
        return this;
    }

    public SqlQueryResponse rows(List<List<Object>> rows) {
        this.rows = rows;
        return this;
    }

    public void readFrom(StreamInput in) throws IOException {
        this.cursor = in.readString();
        if (in.readBoolean()) {
            int columnCount = in.readVInt();
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>(columnCount);
            for (int c = 0; c < columnCount; ++c) {
                columns.add(new ColumnInfo(in));
            }
            this.columns = Collections.unmodifiableList(columns);
        } else {
            this.columns = null;
        }
        int rowCount = in.readVInt();
        ArrayList rows = new ArrayList(rowCount);
        if (rowCount > 0) {
            int columnCount = in.readVInt();
            for (int r = 0; r < rowCount; ++r) {
                ArrayList<Object> row = new ArrayList<Object>(columnCount);
                for (int c = 0; c < columnCount; ++c) {
                    row.add(in.readGenericValue());
                }
                rows.add(Collections.unmodifiableList(row));
            }
        }
        this.rows = Collections.unmodifiableList(rows);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.cursor);
        if (this.columns == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.columns.size());
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.writeTo(out);
            }
        }
        out.writeVInt(this.rows.size());
        if (this.rows.size() > 0) {
            out.writeVInt(this.rows.get(0).size());
            for (List list : this.rows) {
                for (Object value : list) {
                    out.writeGenericValue(value);
                }
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        AbstractSqlRequest.Mode mode = AbstractSqlRequest.Mode.fromString(params.param("mode"));
        builder.startObject();
        if (this.columns != null) {
            builder.startArray("columns");
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.startArray("rows");
        for (List list : this.rows()) {
            builder.startArray();
            for (Object value : list) {
                SqlQueryResponse.value(builder, mode, value);
            }
            builder.endArray();
        }
        builder.endArray();
        if (!this.cursor.equals("")) {
            builder.field(SqlQueryRequest.CURSOR.getPreferredName(), this.cursor);
        }
        return builder.endObject();
    }

    public static XContentBuilder value(XContentBuilder builder, AbstractSqlRequest.Mode mode, Object value) throws IOException {
        if (mode == AbstractSqlRequest.Mode.JDBC && value instanceof ReadableDateTime) {
            builder.value(((ReadableDateTime)value).getMillis());
        } else {
            builder.value(value);
        }
        return builder;
    }

    public static SqlQueryResponse fromXContent(XContentParser parser) {
        return (SqlQueryResponse)((Object)PARSER.apply(parser, null));
    }

    public static List<List<Object>> parseRows(XContentParser parser) throws IOException {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                list.add(SqlQueryResponse.parseRow(parser));
                continue;
            }
            throw new IllegalStateException("expected start array but got [" + parser.currentToken() + "]");
        }
        return list;
    }

    public static List<Object> parseRow(XContentParser parser) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken().isValue()) {
                list.add(XContentParserUtils.parseFieldsValue((XContentParser)parser));
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                list.add(null);
                continue;
            }
            throw new IllegalStateException("expected value but got [" + parser.currentToken() + "]");
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlQueryResponse that = (SqlQueryResponse)((Object)o);
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.columns, this.rows);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CURSOR);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ColumnInfo.fromXContent(p), COLUMNS);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> SqlQueryResponse.parseRows(p), ROWS, ObjectParser.ValueType.OBJECT_ARRAY);
    }
}

