/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xpack.sql.type.DataType;

public class SqlTypedParamValue
implements ToXContentObject,
Writeable {
    private static final ConstructingObjectParser<SqlTypedParamValue, Void> PARSER = new ConstructingObjectParser("params", true, objects -> new SqlTypedParamValue(objects[0], DataType.fromEsType((String)objects[1])));
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField TYPE = new ParseField("type", new String[0]);
    public final Object value;
    public final DataType dataType;

    public SqlTypedParamValue(Object value, DataType dataType) {
        this.value = value;
        this.dataType = dataType;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.dataType.esType);
        builder.field("value", this.value);
        builder.endObject();
        return builder;
    }

    public static SqlTypedParamValue fromXContent(XContentParser parser) {
        return (SqlTypedParamValue)PARSER.apply(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.dataType);
        out.writeGenericValue(this.value);
    }

    public SqlTypedParamValue(StreamInput in) throws IOException {
        this.dataType = (DataType)in.readEnum(DataType.class);
        this.value = in.readGenericValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTypedParamValue that = (SqlTypedParamValue)o;
        return Objects.equals(this.value, that.value) && this.dataType == that.dataType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.dataType});
    }

    public String toString() {
        return String.valueOf(this.value) + "[" + (Object)((Object)this.dataType) + "]";
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), VALUE, ObjectParser.ValueType.VALUE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
    }
}

