/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessorFactory;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.RejectedBySelectorVersion;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.ResolveExceptionAnalyzer;
import org.gradle.internal.resolve.caching.ComponentMetadataSupplierRuleExecutor;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ComponentSelectionContext;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVersionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVersionResolver.class);
    private final List<ModuleComponentRepository> repositories = new ArrayList<ModuleComponentRepository>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final VersionedComponentChooser versionedComponentChooser;
    private final VersionParser versionParser;
    private final Transformer<ModuleComponentResolveMetadata, RepositoryChainModuleResolution> metaDataFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final ComponentMetadataProcessorFactory componentMetadataProcessor;
    private final ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor;
    private final CachePolicy cachePolicy;

    public DynamicVersionResolver(VersionedComponentChooser versionedComponentChooser, VersionParser versionParser, Transformer<ModuleComponentResolveMetadata, RepositoryChainModuleResolution> metaDataFactory, ImmutableAttributesFactory attributesFactory, ComponentMetadataProcessorFactory componentMetadataProcessor, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor, CachePolicy cachePolicy) {
        this.versionedComponentChooser = versionedComponentChooser;
        this.versionParser = versionParser;
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.componentMetadataProcessor = componentMetadataProcessor;
        this.componentMetadataSupplierRuleExecutor = componentMetadataSupplierRuleExecutor;
        this.cachePolicy = cachePolicy;
    }

    public void add(ModuleComponentRepository repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    public void resolve(ModuleDependencyMetadata dependency, VersionSelector versionSelector, VersionSelector rejectedVersionSelector, AttributeContainer consumerAttributes, BuildableComponentIdResolveResult result) {
        ModuleComponentSelector requested = dependency.getSelector();
        LOGGER.debug("Attempting to resolve version for {} using repositories {}", (Object)requested, this.repositoryNames);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList resolveStates = Lists.newArrayListWithCapacity((int)this.repositories.size());
        for (ModuleComponentRepository repository : this.repositories) {
            resolveStates.add(new RepositoryResolveState(this.versionedComponentChooser, dependency, repository, versionSelector, rejectedVersionSelector, this.versionParser, consumerAttributes, this.attributesFactory, this.componentMetadataProcessor, this.componentMetadataSupplierRuleExecutor, this.cachePolicy));
        }
        RepositoryChainModuleResolution latestResolved = this.findLatestModule(resolveStates, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using {} from {}", (Object)latestResolved.module.getModuleVersionId(), (Object)latestResolved.repository);
            for (Throwable error : errors) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            this.found(result, resolveStates, latestResolved);
            return;
        }
        if (!errors.isEmpty()) {
            result.failed(new ModuleVersionResolveException((ComponentSelector)requested, errors));
        } else {
            this.notFound(result, requested, resolveStates);
        }
    }

    private void found(BuildableComponentIdResolveResult result, List<RepositoryResolveState> resolveStates, RepositoryChainModuleResolution latestResolved) {
        for (RepositoryResolveState resolveState : resolveStates) {
            resolveState.registerAttempts(result);
        }
        result.resolved((ComponentResolveMetadata)this.metaDataFactory.transform((Object)latestResolved));
    }

    private void notFound(BuildableComponentIdResolveResult result, ModuleComponentSelector requested, List<RepositoryResolveState> resolveStates) {
        for (RepositoryResolveState resolveState : resolveStates) {
            resolveState.applyTo(result);
        }
        if (result.isRejected()) {
            return;
        }
        LinkedHashSet<String> unmatched = new LinkedHashSet<String>();
        for (RejectedBySelectorVersion rejected : result.getUnmatchedVersions()) {
            unmatched.add(rejected.getId().getVersion());
        }
        result.failed(new ModuleVersionNotFoundException(requested, result.getAttempted(), unmatched, result.getRejectedVersions()));
    }

    private RepositoryChainModuleResolution findLatestModule(List<RepositoryResolveState> resolveStates, Collection<Throwable> failures) {
        LinkedList<RepositoryResolveState> queue = new LinkedList<RepositoryResolveState>();
        queue.addAll(resolveStates);
        LinkedList<RepositoryResolveState> missing = new LinkedList<RepositoryResolveState>();
        RepositoryChainModuleResolution best = this.findLatestModule(queue, failures, missing);
        if (ResolveExceptionAnalyzer.hasCriticalFailure(failures)) {
            return null;
        }
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findLatestModule(queue, failures, missing);
    }

    private RepositoryChainModuleResolution findLatestModule(LinkedList<RepositoryResolveState> queue, Collection<Throwable> failures, Collection<RepositoryResolveState> missing) {
        RepositoryChainModuleResolution best = null;
        block7: while (!queue.isEmpty()) {
            RepositoryResolveState request = queue.removeFirst();
            try {
                request.resolve();
            }
            catch (Throwable t) {
                failures.add(t);
                if (!ResolveExceptionAnalyzer.isCriticalFailure(t)) continue;
                queue.clear();
                continue;
            }
            switch (request.resolvedVersionMetadata.getState()) {
                case Failed: {
                    failures.add((Throwable)((Object)request.resolvedVersionMetadata.getFailure()));
                    if (!ResolveExceptionAnalyzer.isCriticalFailure((Throwable)((Object)request.resolvedVersionMetadata.getFailure()))) continue block7;
                    queue.clear();
                    continue block7;
                }
                case Missing: 
                case Unknown: {
                    if (!request.canMakeFurtherAttempts()) continue block7;
                    missing.add(request);
                    continue block7;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, request.resolvedVersionMetadata.getMetaData());
                    best = this.chooseBest(best, moduleResolution);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)request.resolvedVersionMetadata.getState()));
        }
        return best;
    }

    private RepositoryChainModuleResolution chooseBest(RepositoryChainModuleResolution one, RepositoryChainModuleResolution two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        return this.versionedComponentChooser.selectNewestComponent(one.module, two.module) == one.module ? one : two;
    }

    private static class VersionListResult {
        private final DefaultBuildableModuleVersionListingResolveResult result = new DefaultBuildableModuleVersionListingResolveResult();
        private final ModuleComponentRepository repository;
        private final ModuleDependencyMetadata dependency;
        private boolean searchedLocally;
        private boolean searchedRemotely;

        public VersionListResult(ModuleDependencyMetadata dependency, ModuleComponentRepository repository) {
            this.dependency = dependency;
            this.repository = repository;
        }

        void resolve() {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(this.dependency, this.repository.getLocalAccess());
                if (this.result.hasResult()) {
                    if (this.result.isAuthoritative()) {
                        this.searchedRemotely = true;
                    }
                    return;
                }
            }
            if (!this.searchedRemotely) {
                this.searchedRemotely = true;
                this.process(this.dependency, this.repository.getRemoteAccess());
            }
        }

        public boolean canMakeFurtherAttempts() {
            return !this.searchedRemotely;
        }

        public void applyTo(ResourceAwareResolveResult target) {
            this.result.applyTo(target);
        }

        private void process(ModuleDependencyMetadata dynamicVersionDependency, ModuleComponentRepositoryAccess moduleAccess) {
            moduleAccess.listModuleVersions(dynamicVersionDependency, this.result);
        }
    }

    private static class CandidateResult
    implements ModuleComponentResolveState {
        private final ModuleComponentIdentifier identifier;
        private final ModuleComponentRepository repository;
        private final AttemptCollector attemptCollector;
        private final ModuleDependencyMetadata dependencyMetadata;
        private final Version version;
        private final ComponentMetadataProcessorFactory componentMetadataProcessorFactory;
        private final ImmutableAttributesFactory attributesFactory;
        private final ComponentMetadataSupplierRuleExecutor supplierRuleExecutor;
        private boolean searchedLocally;
        private boolean searchedRemotely;
        private final DefaultBuildableModuleComponentMetaDataResolveResult result = new DefaultBuildableModuleComponentMetaDataResolveResult();
        private final CachePolicy cachePolicy;

        public CandidateResult(ModuleDependencyMetadata dependencyMetadata, String version, ModuleComponentRepository repository, AttemptCollector attemptCollector, VersionParser versionParser, ComponentMetadataProcessorFactory componentMetadataProcessorFactory, ImmutableAttributesFactory attributesFactory, ComponentMetadataSupplierRuleExecutor supplierRuleExecutor, CachePolicy cachePolicy) {
            this.dependencyMetadata = dependencyMetadata;
            this.componentMetadataProcessorFactory = componentMetadataProcessorFactory;
            this.attributesFactory = attributesFactory;
            this.supplierRuleExecutor = supplierRuleExecutor;
            this.cachePolicy = cachePolicy;
            this.version = versionParser.transform(version);
            this.repository = repository;
            this.attemptCollector = attemptCollector;
            ModuleComponentSelector requested = dependencyMetadata.getSelector();
            this.identifier = DefaultModuleComponentIdentifier.newId(requested.getModuleIdentifier(), version);
        }

        @Override
        public ModuleComponentIdentifier getId() {
            return this.identifier;
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        @Override
        public BuildableModuleComponentMetaDataResolveResult resolve() {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(this.repository.getLocalAccess(), this.result);
                if (this.result.hasResult() && this.result.isAuthoritative()) {
                    this.searchedRemotely = true;
                }
            }
            if (this.result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved || this.result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
                return this.result;
            }
            if (!this.searchedRemotely) {
                this.searchedRemotely = true;
                this.process(this.repository.getRemoteAccess(), this.result);
            }
            return this.result;
        }

        @Override
        public ComponentMetadataProcessorFactory getComponentMetadataProcessorFactory() {
            return this.componentMetadataProcessorFactory;
        }

        @Override
        public ImmutableAttributesFactory getAttributesFactory() {
            return this.attributesFactory;
        }

        @Override
        public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
            return this.repository.getComponentMetadataSupplier();
        }

        @Override
        public ComponentMetadataSupplierRuleExecutor getComponentMetadataSupplierExecutor() {
            return this.supplierRuleExecutor;
        }

        @Override
        public CachePolicy getCachePolicy() {
            return this.cachePolicy;
        }

        private void process(ModuleComponentRepositoryAccess access, DefaultBuildableModuleComponentMetaDataResolveResult result) {
            ModuleDependencyMetadata dependency = this.dependencyMetadata.withRequestedVersion(new DefaultImmutableVersionConstraint(this.version.getSource()));
            access.resolveComponentMetaData(this.identifier, DefaultComponentOverrideMetadata.forDependency(dependency), result);
            this.attemptCollector.execute(result);
        }

        private void tryResolveMetadata(BuildableModuleComponentMetaDataResolveResult target) {
            BuildableModuleComponentMetaDataResolveResult result = this.resolve();
            switch (result.getState()) {
                case Resolved: {
                    target.resolved(result.getMetaData());
                    return;
                }
                case Missing: {
                    result.applyTo(target);
                    target.missing();
                    return;
                }
                case Failed: {
                    target.failed(result.getFailure());
                    return;
                }
                case Unknown: {
                    return;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class RepositoryResolveState
    implements ComponentSelectionContext {
        private final VersionedComponentChooser versionedComponentChooser;
        private final BuildableModuleComponentMetaDataResolveResult resolvedVersionMetadata = new DefaultBuildableModuleComponentMetaDataResolveResult();
        private final Map<String, CandidateResult> candidateComponents = new LinkedHashMap<String, CandidateResult>();
        private final Set<RejectedBySelectorVersion> unmatchedVersions = Sets.newLinkedHashSet();
        private final Set<RejectedVersion> rejectedVersions = Sets.newLinkedHashSet();
        private final VersionListResult versionListingResult;
        private final ModuleComponentRepository repository;
        private final AttemptCollector attemptCollector;
        private final ModuleDependencyMetadata dependency;
        private final VersionSelector versionSelector;
        private final VersionSelector rejectedVersionSelector;
        private final VersionParser versionParser;
        private final ImmutableAttributes consumerAttributes;
        private final ComponentMetadataProcessorFactory componentMetadataProcessorFactory;
        private final ImmutableAttributesFactory attributesFactory;
        private final ComponentMetadataSupplierRuleExecutor metadataSupplierRuleExecutor;
        private final CachePolicy cachePolicy;
        private ModuleComponentIdentifier firstRejected = null;

        public RepositoryResolveState(VersionedComponentChooser versionedComponentChooser, ModuleDependencyMetadata dependency, ModuleComponentRepository repository, VersionSelector versionSelector, VersionSelector rejectedVersionSelector, VersionParser versionParser, AttributeContainer consumerAttributes, ImmutableAttributesFactory attributesFactory, ComponentMetadataProcessorFactory componentMetadataProcessorFactory, ComponentMetadataSupplierRuleExecutor metadataSupplierRuleExecutor, CachePolicy cachePolicy) {
            this.versionedComponentChooser = versionedComponentChooser;
            this.dependency = dependency;
            this.versionSelector = versionSelector;
            this.rejectedVersionSelector = rejectedVersionSelector;
            this.repository = repository;
            this.versionParser = versionParser;
            this.componentMetadataProcessorFactory = componentMetadataProcessorFactory;
            this.attributesFactory = attributesFactory;
            this.metadataSupplierRuleExecutor = metadataSupplierRuleExecutor;
            this.cachePolicy = cachePolicy;
            this.attemptCollector = new AttemptCollector();
            this.consumerAttributes = this.buildAttributes(consumerAttributes, attributesFactory);
            this.versionListingResult = new VersionListResult(dependency, repository);
        }

        private ImmutableAttributes buildAttributes(AttributeContainer consumerAttributes, ImmutableAttributesFactory attributesFactory) {
            ImmutableAttributes immutableConsumerAttributes = ((AttributeContainerInternal)consumerAttributes).asImmutable();
            ImmutableAttributes dependencyAttributes = ((AttributeContainerInternal)this.dependency.getSelector().getAttributes()).asImmutable();
            return attributesFactory.concat(immutableConsumerAttributes, dependencyAttributes);
        }

        public boolean canMakeFurtherAttempts() {
            return this.versionListingResult.canMakeFurtherAttempts();
        }

        void resolve() {
            this.versionListingResult.resolve();
            switch (this.versionListingResult.result.getState()) {
                case Failed: {
                    this.resolvedVersionMetadata.failed(this.versionListingResult.result.getFailure());
                    break;
                }
                case Listed: {
                    this.selectMatchingVersionAndResolve();
                    break;
                }
                case Unknown: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state for version list result.");
                }
            }
        }

        private void selectMatchingVersionAndResolve() {
            this.versionedComponentChooser.selectNewestMatchingComponent(this.candidates(), this, this.versionSelector, this.rejectedVersionSelector, this.consumerAttributes);
        }

        @Override
        public void matches(ModuleComponentIdentifier moduleComponentIdentifier) {
            String version = moduleComponentIdentifier.getVersion();
            CandidateResult candidateResult = this.candidateComponents.get(version);
            candidateResult.tryResolveMetadata(this.resolvedVersionMetadata);
        }

        @Override
        public void failed(ModuleVersionResolveException failure) {
            this.resolvedVersionMetadata.failed(failure);
        }

        @Override
        public void noMatchFound() {
            this.resolvedVersionMetadata.missing();
        }

        @Override
        public void notMatched(ModuleComponentIdentifier id, VersionSelector requestedVersionMatcher) {
            this.unmatchedVersions.add(new RejectedBySelectorVersion(id, requestedVersionMatcher));
        }

        @Override
        public void rejectedByRule(RejectedByRuleVersion id) {
            this.rejectedVersions.add(id);
        }

        @Override
        public void doesNotMatchConsumerAttributes(RejectedByAttributesVersion rejectedVersion) {
            this.rejectedVersions.add(rejectedVersion);
        }

        @Override
        public void rejectedBySelector(ModuleComponentIdentifier id, VersionSelector versionSelector) {
            if (this.firstRejected == null) {
                this.firstRejected = id;
            }
            this.rejectedVersions.add(new RejectedBySelectorVersion(id, versionSelector));
        }

        private List<CandidateResult> candidates() {
            ArrayList<CandidateResult> candidates = new ArrayList<CandidateResult>();
            for (String version : this.versionListingResult.result.getVersions()) {
                CandidateResult candidateResult = this.candidateComponents.get(version);
                if (candidateResult == null) {
                    candidateResult = new CandidateResult(this.dependency, version, this.repository, this.attemptCollector, this.versionParser, this.componentMetadataProcessorFactory, this.attributesFactory, this.metadataSupplierRuleExecutor, this.cachePolicy);
                    this.candidateComponents.put(version, candidateResult);
                }
                candidates.add(candidateResult);
            }
            return candidates;
        }

        protected void applyTo(BuildableComponentIdResolveResult target) {
            this.registerAttempts(target);
            if (this.firstRejected != null) {
                target.rejected((ComponentIdentifier)this.firstRejected, DefaultModuleVersionIdentifier.newId(this.firstRejected));
            }
        }

        private void registerAttempts(BuildableComponentIdResolveResult target) {
            this.versionListingResult.applyTo(target);
            this.attemptCollector.applyTo(target);
            target.unmatched(this.unmatchedVersions);
            target.rejections(this.rejectedVersions);
        }
    }

    private static class AttemptCollector
    implements Action<ResourceAwareResolveResult> {
        private final List<String> attempts = new ArrayList<String>();

        private AttemptCollector() {
        }

        public void execute(ResourceAwareResolveResult resourceAwareResolveResult) {
            this.attempts.addAll(resourceAwareResolveResult.getAttempted());
        }

        public void applyTo(ResourceAwareResolveResult result) {
            for (String url : this.attempts) {
                result.attempted(url);
            }
        }
    }
}

