/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import org.gradle.api.internal.tasks.TaskDestroyablePropertySpec;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskInputPropertySpec;
import org.gradle.api.internal.tasks.TaskLocalStatePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;

public class CompositePropertyVisitor
implements PropertyVisitor {
    private final PropertyVisitor[] visitors;

    public CompositePropertyVisitor(PropertyVisitor ... visitors) {
        this.visitors = visitors;
    }

    public void visitInputFileProperty(TaskInputFilePropertySpec inputFileProperty) {
        for (PropertyVisitor visitor : this.visitors) {
            visitor.visitInputFileProperty(inputFileProperty);
        }
    }

    public void visitInputProperty(TaskInputPropertySpec inputProperty) {
        for (PropertyVisitor visitor : this.visitors) {
            visitor.visitInputProperty(inputProperty);
        }
    }

    public void visitOutputFileProperty(TaskOutputFilePropertySpec outputFileProperty) {
        for (PropertyVisitor visitor : this.visitors) {
            visitor.visitOutputFileProperty(outputFileProperty);
        }
    }

    public void visitDestroyableProperty(TaskDestroyablePropertySpec destroyableProperty) {
        for (PropertyVisitor visitor : this.visitors) {
            visitor.visitDestroyableProperty(destroyableProperty);
        }
    }

    public void visitLocalStateProperty(TaskLocalStatePropertySpec localStateProperty) {
        for (PropertyVisitor visitor : this.visitors) {
            visitor.visitLocalStateProperty(localStateProperty);
        }
    }
}

