/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.AbstractConditionalExecution;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;
import org.gradle.internal.work.ConditionalExecutionQueueFactory;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerConfiguration;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.SerializingActionExecutionSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerExecutor
implements WorkerExecutor,
Stoppable {
    private final ConditionalExecutionQueue<DefaultWorkResult> executionQueue;
    private final WorkerFactory daemonWorkerFactory;
    private final WorkerFactory isolatedClassloaderWorkerFactory;
    private final WorkerFactory noIsolationWorkerFactory;
    private final FileResolver fileResolver;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final WorkerDirectoryProvider workerDirectoryProvider;

    public DefaultWorkerExecutor(WorkerFactory daemonWorkerFactory, WorkerFactory isolatedClassloaderWorkerFactory, WorkerFactory noIsolationWorkerFactory, FileResolver fileResolver, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, WorkerDirectoryProvider workerDirectoryProvider, ConditionalExecutionQueueFactory conditionalExecutionQueueFactory) {
        this.daemonWorkerFactory = daemonWorkerFactory;
        this.isolatedClassloaderWorkerFactory = isolatedClassloaderWorkerFactory;
        this.noIsolationWorkerFactory = noIsolationWorkerFactory;
        this.fileResolver = fileResolver;
        this.executionQueue = conditionalExecutionQueueFactory.create("WorkerExecutor Queue", DefaultWorkResult.class);
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.workerDirectoryProvider = workerDirectoryProvider;
    }

    public void stop() {
        this.executionQueue.stop();
    }

    @Override
    public void submit(Class<? extends Runnable> actionClass, Action<? super WorkerConfiguration> configAction) {
        SerializingActionExecutionSpec spec;
        DefaultWorkerConfiguration configuration = new DefaultWorkerConfiguration(this.fileResolver);
        configAction.execute((Object)configuration);
        String description = configuration.getDisplayName() != null ? configuration.getDisplayName() : actionClass.getName();
        try {
            spec = new SerializingActionExecutionSpec(actionClass, description, configuration.getForkOptions().getWorkingDir(), configuration.getParams());
        }
        catch (Throwable t) {
            throw new WorkExecutionException(description, t);
        }
        this.submit(spec, configuration.getIsolationMode(), this.getDaemonForkOptions(actionClass, configuration));
    }

    private void submit(final ActionExecutionSpec spec, final IsolationMode isolationMode, final DaemonForkOptions daemonForkOptions) {
        WorkerLeaseRegistry.WorkerLease currentWorkerWorkerLease = this.getCurrentWorkerLease();
        final BuildOperationRef currentBuildOperation = this.buildOperationExecutor.getCurrentOperation();
        WorkerExecution execution = new WorkerExecution(spec.getDisplayName(), currentWorkerWorkerLease, new Callable<DefaultWorkResult>(){

            @Override
            public DefaultWorkResult call() throws Exception {
                try {
                    WorkerFactory workerFactory = DefaultWorkerExecutor.this.getWorkerFactory(isolationMode);
                    Worker worker = workerFactory.getWorker(daemonForkOptions);
                    return worker.execute(spec, currentBuildOperation);
                }
                catch (Throwable t) {
                    throw new WorkExecutionException(spec.getDisplayName(), t);
                }
            }
        });
        this.executionQueue.submit((ConditionalExecution)execution);
        this.asyncWorkTracker.registerWork(currentBuildOperation, (AsyncWorkCompletion)execution);
    }

    private WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        try {
            return this.workerLeaseRegistry.getCurrentWorkerLease();
        }
        catch (NoAvailableWorkerLeaseException e) {
            throw new IllegalStateException("An attempt was made to submit work from a thread not managed by Gradle.  Work may only be submitted from a Gradle-managed thread.", e);
        }
    }

    private WorkerFactory getWorkerFactory(IsolationMode isolationMode) {
        switch (isolationMode) {
            case AUTO: 
            case CLASSLOADER: {
                return this.isolatedClassloaderWorkerFactory;
            }
            case NONE: {
                return this.noIsolationWorkerFactory;
            }
            case PROCESS: {
                return this.daemonWorkerFactory;
            }
        }
        throw new IllegalArgumentException("Unknown isolation mode: " + (Object)((Object)isolationMode));
    }

    @Override
    public void await() throws WorkerExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            this.executionQueue.expand();
            this.asyncWorkTracker.waitForCompletion(currentOperation, false);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private WorkerExecutionException workerExecutionException(List<? extends Throwable> failures) {
        if (failures.size() == 1) {
            throw new WorkerExecutionException("There was a failure while executing work items", failures);
        }
        throw new WorkerExecutionException("There were multiple failures while executing work items", failures);
    }

    DaemonForkOptions getDaemonForkOptions(Class<?> actionClass, WorkerConfiguration configuration) {
        this.validateWorkerConfiguration(configuration);
        List paramTypes = CollectionUtils.collect((Object[])configuration.getParams(), (Transformer)new Transformer<Class<?>, Object>(){

            public Class<?> transform(Object o) {
                return o.getClass();
            }
        });
        return this.toDaemonOptions(actionClass, paramTypes, configuration.getForkOptions(), configuration.getClasspath());
    }

    private void validateWorkerConfiguration(WorkerConfiguration configuration) {
        if (configuration.getIsolationMode() == IsolationMode.NONE && configuration.getClasspath().iterator().hasNext()) {
            throw this.unsupportedWorkerConfigurationException("classpath", configuration.getIsolationMode());
        }
        if (configuration.getIsolationMode() == IsolationMode.NONE || configuration.getIsolationMode() == IsolationMode.CLASSLOADER) {
            if (!configuration.getForkOptions().getBootstrapClasspath().isEmpty()) {
                throw this.unsupportedWorkerConfigurationException("bootstrap classpath", configuration.getIsolationMode());
            }
            if (!configuration.getForkOptions().getJvmArgs().isEmpty()) {
                throw this.unsupportedWorkerConfigurationException("jvm arguments", configuration.getIsolationMode());
            }
            if (configuration.getForkOptions().getMaxHeapSize() != null) {
                throw this.unsupportedWorkerConfigurationException("maximum heap size", configuration.getIsolationMode());
            }
            if (configuration.getForkOptions().getMinHeapSize() != null) {
                throw this.unsupportedWorkerConfigurationException("minimum heap size", configuration.getIsolationMode());
            }
            if (!configuration.getForkOptions().getSystemProperties().isEmpty()) {
                throw this.unsupportedWorkerConfigurationException("system properties", configuration.getIsolationMode());
            }
        }
    }

    private RuntimeException unsupportedWorkerConfigurationException(String propertyDescription, IsolationMode isolationMode) {
        return new UnsupportedOperationException("The worker " + propertyDescription + " cannot be set when using isolation mode " + isolationMode.name());
    }

    private DaemonForkOptions toDaemonOptions(Class<?> actionClass, Iterable<Class<?>> paramClasses, JavaForkOptions userForkOptions, Iterable<File> classpath) {
        ImmutableSet.Builder classpathBuilder = ImmutableSet.builder();
        ImmutableSet.Builder sharedPackagesBuilder = ImmutableSet.builder();
        sharedPackagesBuilder.add((Object)"javax.inject");
        if (classpath != null) {
            classpathBuilder.addAll(classpath);
        }
        DefaultWorkerExecutor.addVisibilityFor(actionClass, (ImmutableSet.Builder<File>)classpathBuilder, (ImmutableSet.Builder<String>)sharedPackagesBuilder, true);
        for (Class<?> paramClass : paramClasses) {
            DefaultWorkerExecutor.addVisibilityFor(paramClass, (ImmutableSet.Builder<File>)classpathBuilder, (ImmutableSet.Builder<String>)sharedPackagesBuilder, false);
        }
        ImmutableSet daemonClasspath = classpathBuilder.build();
        ImmutableSet daemonSharedPackages = sharedPackagesBuilder.build();
        DefaultJavaForkOptions forkOptions = new DefaultJavaForkOptions(this.fileResolver);
        userForkOptions.copyTo((JavaForkOptions)forkOptions);
        forkOptions.setWorkingDir(this.workerDirectoryProvider.getIdleWorkingDirectory());
        return new DaemonForkOptionsBuilder(this.fileResolver).javaForkOptions((JavaForkOptions)forkOptions).classpath((Iterable<File>)daemonClasspath).sharedPackages((Iterable<String>)daemonSharedPackages).keepAliveMode(KeepAliveMode.DAEMON).build();
    }

    private static void addVisibilityFor(Class<?> visibleClass, ImmutableSet.Builder<File> classpathBuilder, ImmutableSet.Builder<String> sharedPackagesBuilder, boolean addToSharedPackages) {
        if (visibleClass.getClassLoader() != null) {
            classpathBuilder.addAll((Iterable)ClasspathUtil.getClasspath((ClassLoader)visibleClass.getClassLoader()).getAsFiles());
        }
        if (addToSharedPackages) {
            DefaultWorkerExecutor.addVisiblePackage(visibleClass, sharedPackagesBuilder);
        }
    }

    private static void addVisiblePackage(Class<?> visibleClass, ImmutableSet.Builder<String> sharedPackagesBuilder) {
        if (visibleClass.getPackage() == null || "".equals(visibleClass.getPackage().getName())) {
            sharedPackagesBuilder.add((Object)"DEFAULT");
        } else {
            sharedPackagesBuilder.add((Object)visibleClass.getPackage().getName());
        }
    }

    private static class LazyChildWorkerLeaseLock
    implements ResourceLock {
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private WorkerLeaseRegistry.WorkerLease child;

        public LazyChildWorkerLeaseLock(WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
            this.parentWorkerLease = parentWorkerLease;
        }

        public boolean isLocked() {
            return this.getChild().isLocked();
        }

        public boolean isLockedByCurrentThread() {
            return this.getChild().isLockedByCurrentThread();
        }

        public boolean tryLock() {
            this.child = this.parentWorkerLease.createChild();
            if (this.child.tryLock()) {
                return true;
            }
            this.child = null;
            return false;
        }

        public void unlock() {
            this.getChild().unlock();
        }

        public String getDisplayName() {
            return this.getChild().getDisplayName();
        }

        private WorkerLeaseRegistry.WorkerLease getChild() {
            if (this.child == null) {
                throw new IllegalStateException("Detected attempt to access LazyChildWorkerLeaseLock before tryLock() has succeeded.  tryLock must be succeed before other methods are called.");
            }
            return this.child;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkerExecution
    extends AbstractConditionalExecution<DefaultWorkResult>
    implements AsyncWorkCompletion {
        private final String description;

        public WorkerExecution(String description, WorkerLeaseRegistry.WorkerLease parentWorkerLease, Callable<DefaultWorkResult> callable) {
            super(callable, (ResourceLock)new LazyChildWorkerLeaseLock(parentWorkerLease));
            this.description = description;
        }

        public void waitForCompletion() {
            DefaultWorkResult result = (DefaultWorkResult)this.await();
            if (!result.isSuccess()) {
                throw new WorkExecutionException(this.description, result.getException());
            }
        }
    }

    @Contextual
    private static class WorkExecutionException
    extends RuntimeException {
        WorkExecutionException(String description, Throwable cause) {
            super("A failure occurred while executing " + description, cause);
        }
    }
}

