/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util.internal;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.cache.internal.HeapProportionalCacheSizer;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingPatternSpecFactory
extends PatternSpecFactory {
    private static final int RESULTS_CACHE_MAX_SIZE = 1200000;
    private static final int INSTANCES_MAX_SIZE = 30000;
    private final Cache<CacheKey, Boolean> specResultCache;
    private final Cache<SpecKey, Spec> specInstanceCache;

    public CachingPatternSpecFactory() {
        HeapProportionalCacheSizer cacheSizer = new HeapProportionalCacheSizer();
        this.specResultCache = CacheBuilder.newBuilder().maximumSize((long)cacheSizer.scaleCacheSize(1200000)).build();
        this.specInstanceCache = CacheBuilder.newBuilder().maximumSize((long)cacheSizer.scaleCacheSize(30000)).build();
    }

    @Override
    protected Spec<FileTreeElement> createSpec(final Collection<String> patterns, final boolean include, final boolean caseSensitive) {
        final SpecKey key = new SpecKey(ImmutableList.copyOf(patterns), include, caseSensitive);
        try {
            return (Spec)Cast.uncheckedCast((Object)this.specInstanceCache.get((Object)key, (Callable)new Callable<Spec<FileTreeElement>>(){

                @Override
                public Spec<FileTreeElement> call() throws Exception {
                    Spec spec = CachingPatternSpecFactory.super.createSpec(patterns, include, caseSensitive);
                    return new CachingSpec(key, (Spec<FileTreeElement>)spec);
                }
            }));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpecKey {
        private final ImmutableList<String> patterns;
        private final boolean include;
        private final boolean caseSensitive;
        private final int hashCode;

        private SpecKey(ImmutableList<String> patterns, boolean include, boolean caseSensitive) {
            this.patterns = patterns;
            this.include = include;
            this.caseSensitive = caseSensitive;
            this.hashCode = Objects.hashCode((Object[])new Object[]{patterns, include, caseSensitive});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecKey that = (SpecKey)o;
            return Objects.equal(this.patterns, that.patterns) && Objects.equal((Object)this.include, (Object)that.include) && Objects.equal((Object)this.caseSensitive, (Object)that.caseSensitive);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("patterns", this.patterns).add("include", this.include).add("caseSensitive", this.caseSensitive).toString();
        }
    }

    private static class CacheKey {
        private final RelativePath relativePath;
        private final SpecKey specKey;
        private final int hashCode;

        private CacheKey(RelativePath relativePath, SpecKey specKey) {
            this.relativePath = relativePath;
            this.specKey = specKey;
            this.hashCode = Objects.hashCode((Object[])new Object[]{relativePath, specKey});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Objects.equal((Object)this.relativePath, (Object)that.relativePath) && Objects.equal((Object)this.specKey, (Object)that.specKey);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("relativePath", (Object)this.relativePath).add("specKey", (Object)this.specKey).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachingSpec
    implements Spec<FileTreeElement> {
        private final SpecKey key;
        private final Spec<FileTreeElement> spec;

        CachingSpec(SpecKey key, Spec<FileTreeElement> spec) {
            this.key = key;
            this.spec = spec;
        }

        public boolean isSatisfiedBy(final FileTreeElement element) {
            CacheKey cacheKey = new CacheKey(element.getRelativePath(), this.key);
            try {
                return (Boolean)CachingPatternSpecFactory.this.specResultCache.get((Object)cacheKey, (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return CachingSpec.this.spec.isSatisfiedBy((Object)element);
                    }
                });
            }
            catch (ExecutionException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("spec", this.spec).toString();
        }
    }
}

