/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.atomdata.AtomData;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.NciCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int ac;
    protected int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    protected int[] downsampleRemainders;
    private boolean getNCIPlanes;
    protected int nData;
    protected boolean readerClosed;
    protected int downsampleFactor;
    protected int nSkipX;
    protected int nSkipY;
    protected int nSkipZ;
    private float[][] yzPlanesRaw;
    private int iPlaneNCI;
    protected P3[] boundingBox;
    private boolean isScaledAlready;

    VolumeFileReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
    }

    void init2VFR(SurfaceGenerator sg, BufferedReader br) {
        this.init2SFR(sg, br);
        this.isXLowToHigh = true;
        this.isProgressive = true;
        this.canDownsample = true;
        this.jvxlData.wasCubic = true;
        this.boundingBox = this.params.boundingBox;
        if (this.params.qmOrbitalType == 4) {
            this.hasColorData = this.params.parameters == null || this.params.parameters[1] >= 0.0f;
            this.getNCIPlanes = true;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    protected float recordData(float value) {
        if (Float.isNaN(value)) {
            return value;
        }
        if (value < this.dataMin) {
            this.dataMin = value;
        }
        if (value > this.dataMax) {
            this.dataMax = value;
        }
        this.dataMean += value;
        ++this.nData;
        return value;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        this.closeReaderSFR();
        if (this.nData == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)this.nData;
        Logger.info((String)("VolumeFileReader closing file: " + this.nData + " points read \ndata min/max/mean = " + this.dataMin + "/" + this.dataMax + "/" + this.dataMean));
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn((String)("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces));
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    @Override
    protected boolean readVolumeData(boolean isMapData) {
        return this.readVolumeDataVFR(isMapData);
    }

    protected boolean readVolumeDataVFR(boolean isMapData) {
        if (!this.gotoAndReadVoxelData(isMapData)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info((String)("JVXL read: " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points"));
        }
        return true;
    }

    private int readVolumetricHeader() {
        try {
            int i;
            boolean downsampling;
            this.readParameters();
            if (this.ac == Integer.MIN_VALUE) {
                return 0;
            }
            if (!this.vertexDataOnly) {
                Logger.info((String)("voxel grid origin:" + this.volumetricOrigin));
            }
            int downsampleFactor = this.params.downsampleFactor;
            boolean bl = downsampling = this.canDownsample && downsampleFactor > 1;
            if (downsampleFactor > 1 && !this.canDownsample) {
                this.jvxlData.msg = this.jvxlData.msg + "\ncannot downsample this file type";
            }
            if (downsampling) {
                this.downsampleRemainders = new int[3];
                Logger.info((String)("downsample factor = " + downsampleFactor));
                for (i = 0; i < 3; ++i) {
                    int n = this.voxelCounts[i];
                    this.downsampleRemainders[i] = n % downsampleFactor;
                    int n2 = i;
                    this.voxelCounts[n2] = this.voxelCounts[n2] / downsampleFactor;
                    if (this.isPeriodic) {
                        int n3 = i;
                        this.voxelCounts[n3] = this.voxelCounts[n3] + 1;
                        int n4 = i;
                        this.downsampleRemainders[n4] = this.downsampleRemainders[n4] - 1;
                    }
                    this.volumetricVectors[i].scale((float)downsampleFactor);
                    Logger.info((String)("downsampling axis " + (i + 1) + " from " + n + " to " + this.voxelCounts[i]));
                }
            }
            if (!this.vertexDataOnly) {
                for (i = 0; i < 3; ++i) {
                    if (!this.isAngstroms) {
                        this.volumetricVectors[i].scale(0.5291772f);
                    }
                    this.line = this.voxelCounts[i] + " " + this.volumetricVectors[i].x + " " + this.volumetricVectors[i].y + " " + this.volumetricVectors[i].z;
                    this.jvxlFileHeaderBuffer.append(this.line).appendC('\n');
                    Logger.info((String)("voxel grid count/vector:" + this.line));
                }
            }
            this.scaleIsosurface(this.params.scale);
            this.volumeData.setVolumetricXml();
            return this.nSurfaces;
        }
        catch (Exception e) {
            Logger.error((String)e.toString());
            return 0;
        }
    }

    protected abstract void readParameters() throws Exception;

    protected String skipComments(boolean allowBlankLines) throws Exception {
        SB sb = new SB();
        while (this.rd() != null && (allowBlankLines && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            sb.append(this.line).appendC('\n');
        }
        return sb.toString();
    }

    protected void readVoxelVector(int voxelVectorIndex) throws Exception {
        this.rd();
        V3 voxelVector = this.volumetricVectors[voxelVectorIndex];
        this.voxelCounts[voxelVectorIndex] = this.parseIntStr(this.line);
        if (this.voxelCounts[voxelVectorIndex] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        voxelVector.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (this.isAnisotropic) {
            this.setVectorAnisotropy((T3)voxelVector);
        }
    }

    void initializeSurfaceData() {
        this.downsampleFactor = this.params.downsampleFactor;
        this.nSkipX = 0;
        this.nSkipY = 0;
        this.nSkipZ = 0;
        if (this.canDownsample && this.downsampleFactor > 0) {
            this.nSkipX = this.downsampleFactor - 1;
            this.nSkipZ = (this.nPointsZ - (this.isPeriodic ? 1 : 0)) * this.downsampleFactor + this.downsampleRemainders[2];
            this.nSkipY = this.downsampleRemainders[2] + (this.downsampleFactor - 1) * this.nSkipZ;
            this.nSkipZ = this.downsampleRemainders[1] * this.nSkipZ + (this.downsampleFactor - 1) * this.nSkipZ * ((this.nPointsY - (this.isPeriodic ? 1 : 0)) * this.downsampleFactor + this.downsampleRemainders[1]);
        }
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.next[0] = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        this.readSurfaceDataVFR(isMapData);
    }

    protected void readSurfaceDataVFR(boolean isMapData) throws Exception {
        this.initializeSurfaceData();
        if (this.isProgressive && !isMapData || this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            if (this.isJvxl) {
                this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            }
        } else if (isMapData && this.volumeData.hasPlane()) {
            this.volumeData.setVoxelMap();
            float f = this.volumeData.getToPlaneParameter();
            for (int x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        float v = this.recordData(this.getNextVoxelValue());
                        if (this.volumeData.isNearPlane(x, y, z, f)) {
                            this.volumeData.setVoxelMapValue(x, y, z, v);
                        }
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        } else {
            this.voxelData = AU.newFloat3((int)this.nPointsX, (int)-1);
            for (int x = 0; x < this.nPointsX; ++x) {
                float[][] plane = AU.newFloat2((int)this.nPointsY);
                this.voxelData[x] = plane;
                for (int y = 0; y < this.nPointsY; ++y) {
                    float[] strip = new float[this.nPointsZ];
                    plane[y] = strip;
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        strip[z] = this.recordData(this.getNextVoxelValue());
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        }
        this.volumeData.setVoxelDataAsArray(this.voxelData);
    }

    @Override
    public float[] getPlane(int x) {
        if (x == 0) {
            this.initPlanes();
        }
        if (this.getNCIPlanes) {
            return this.getPlaneNCI(x);
        }
        float[] plane = this.getPlaneSR(x);
        if (this.qpc == null) {
            this.getPlaneVFR(plane, true);
        }
        return plane;
    }

    public float[] getPlaneNCI(int x) {
        float[] plane;
        if (this.iPlaneNCI == 0) {
            this.qpc = (NciCalculation)Interface.getOption((String)"quantum.NciCalculation", (Viewer)((Viewer)this.sg.atomDataServer), null);
            AtomData atomData = new AtomData();
            atomData.modelIndex = -1;
            atomData.bsSelected = this.params.bsSelected;
            this.sg.fillAtomData(atomData, 1);
            ((NciCalculation)this.qpc).setupCalculation(this.volumeData, this.sg.params.bsSelected, null, null, (T3[])atomData.atoms, -1, true, null, this.params.parameters, this.params.testFlags);
            this.iPlaneNCI = 1;
            this.yzPlanesRaw = new float[4][this.yzCount];
            this.qpc.setPlanes(this.yzPlanesRaw);
            if (this.hasColorData) {
                this.getPlaneVFR(this.yzPlanesRaw[0], false);
                this.getPlaneVFR(this.yzPlanesRaw[1], false);
                float[] plane2 = this.yzPlanes[0];
                for (int i = 0; i < this.yzCount; ++i) {
                    plane2[i] = Float.NaN;
                }
                return plane2;
            }
            this.iPlaneNCI = -1;
        }
        float nan = this.qpc.getNoValue();
        int x1 = this.nPointsX - 1;
        switch (this.iPlaneNCI) {
            case -1: {
                plane = this.yzPlanes[x % 2];
                ++x1;
                break;
            }
            case 3: {
                plane = this.yzPlanesRaw[0];
                this.yzPlanesRaw[0] = this.yzPlanesRaw[1];
                this.yzPlanesRaw[1] = this.yzPlanesRaw[2];
                this.yzPlanesRaw[2] = this.yzPlanesRaw[3];
                this.yzPlanesRaw[3] = plane;
                plane = this.yzPlanesRaw[this.iPlaneNCI];
                break;
            }
            default: {
                ++this.iPlaneNCI;
                plane = this.yzPlanesRaw[this.iPlaneNCI];
            }
        }
        if (x < x1) {
            this.getPlaneVFR(plane, false);
            plane = this.yzPlanes[x % 2];
            this.qpc.calcPlane(x, plane);
            for (int i = 0; i < this.yzCount; ++i) {
                if (plane[i] == nan) continue;
                this.recordData(plane[i]);
            }
        } else {
            for (int i = 0; i < this.yzCount; ++i) {
                plane[i] = Float.NaN;
            }
        }
        return plane;
    }

    private void getPlaneVFR(float[] plane, boolean doRecord) {
        try {
            int ptyz = 0;
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    float v = this.getNextVoxelValue();
                    if (doRecord) {
                        this.recordData(v);
                    }
                    plane[ptyz++] = v;
                    if (this.nSkipX == 0) continue;
                    this.skipVoxels(this.nSkipX);
                }
                if (this.nSkipY == 0) continue;
                this.skipVoxels(this.nSkipY);
            }
            if (this.nSkipZ != 0) {
                this.skipVoxels(this.nSkipZ);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public float getValue(int x, int y, int z, int ptyz) {
        if (this.boundingBox != null) {
            this.volumeData.voxelPtToXYZ(x, y, z, (T3)this.ptTemp);
            if (this.ptTemp.x < this.boundingBox[0].x || this.ptTemp.x > this.boundingBox[1].x || this.ptTemp.y < this.boundingBox[0].y || this.ptTemp.y > this.boundingBox[1].y || this.ptTemp.z < this.boundingBox[0].z || this.ptTemp.z > this.boundingBox[1].z) {
                return Float.NaN;
            }
        }
        return this.getValue2(x, y, z, ptyz);
    }

    private void skipVoxels(int n) throws Exception {
        int i = n;
        while (--i >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BS getVoxelBitSet(int nPoints) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float voxelValue = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int i;
            for (i = 1; i < this.params.fileIndex; ++i) {
                this.nextVoxel();
            }
            voxelValue = this.nextVoxel();
            for (i = this.params.fileIndex; i < this.nSurfaces; ++i) {
                this.nextVoxel();
            }
        } else {
            voxelValue = this.nextVoxel();
        }
        return voxelValue;
    }

    protected float nextVoxel() throws Exception {
        float voxelValue = this.parseFloat();
        if (Float.isNaN(voxelValue)) {
            while (this.rd() != null && Float.isNaN(voxelValue = this.parseFloatStr(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn((String)("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line));
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
        }
        return voxelValue;
    }

    @Override
    protected void gotoData(int n, int nPoints) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + nPoints + " points each"));
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(nPoints);
        }
    }

    protected void skipData(int nPoints) throws Exception {
        this.skipDataVFR(nPoints);
    }

    protected void skipDataVFR(int nPoints) throws Exception {
        for (int iV = 0; iV < nPoints; iV += this.countData(this.rd())) {
        }
    }

    private int countData(String str) {
        int count = 0;
        int ich = 0;
        int ichMax = str.length();
        while (ich < ichMax) {
            char ch;
            while (ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t')) {
                ++ich;
            }
            if (ich < ichMax) {
                ++count;
            }
            while (ich < ichMax && (ch = str.charAt(ich)) != ' ' && ch != '\t') {
                ++ich;
            }
        }
        return count;
    }

    protected static boolean checkAtomLine(boolean isXLowToHigh, boolean isAngstroms, String strAtomCount, String atomLine, SB bs) {
        if (atomLine.indexOf("ANGSTROMS") >= 0) {
            isAngstroms = true;
        }
        int ac = strAtomCount == null ? Integer.MAX_VALUE : PT.parseInt((String)strAtomCount);
        switch (ac) {
            case -2147483648: {
                ac = 0;
                atomLine = " " + atomLine.substring(atomLine.indexOf(" ") + 1);
                break;
            }
            case 0x7FFFFFFF: {
                ac = Integer.MIN_VALUE;
                break;
            }
            default: {
                String s = "" + ac;
                atomLine = atomLine.substring(atomLine.indexOf(s) + s.length());
            }
        }
        if (isAngstroms) {
            if (atomLine.indexOf("ANGSTROM") < 0) {
                atomLine = atomLine + " ANGSTROMS";
            }
        } else if (atomLine.indexOf("BOHR") < 0) {
            atomLine = atomLine + " BOHR";
        }
        atomLine = (ac == Integer.MIN_VALUE ? "" : (isXLowToHigh ? "+" : "-") + Math.abs(ac)) + atomLine + "\n";
        bs.append(atomLine);
        return isAngstroms;
    }

    @Override
    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA, int vB, float[] fReturn, T3 ptReturn) {
        return this.getSPFv(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
    }

    protected float getSPFv(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA, int vB, float[] fReturn, T3 ptReturn) {
        float zero = this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
        if (this.qpc == null || Float.isNaN(zero) || !this.hasColorData) {
            return zero;
        }
        vA = this.marchingCubes.getLinearOffset(x, y, z, vA);
        vB = this.marchingCubes.getLinearOffset(x, y, z, vB);
        return this.qpc.process(vA, vB, fReturn[0]);
    }

    private void scaleIsosurface(float scale) {
        if (this.isScaledAlready) {
            return;
        }
        this.isScaledAlready = true;
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
        if (Float.isNaN(scale)) {
            return;
        }
        Logger.info((String)("applying scaling factor of " + scale));
        this.volumetricOrigin.scaleAdd2((1.0f - scale) / 2.0f, (T3)this.volumetricVectors[0], (T3)this.volumetricOrigin);
        this.volumetricOrigin.scaleAdd2((1.0f - scale) / 2.0f, (T3)this.volumetricVectors[1], (T3)this.volumetricOrigin);
        this.volumetricOrigin.scaleAdd2((1.0f - scale) / 2.0f, (T3)this.volumetricVectors[2], (T3)this.volumetricOrigin);
        this.volumetricVectors[0].scale(scale);
        this.volumetricVectors[1].scale(scale);
        this.volumetricVectors[2].scale(scale);
    }

    protected void swapXZ() {
        V3 v = this.volumetricVectors[0];
        this.volumetricVectors[0] = this.volumetricVectors[2];
        this.volumetricVectors[2] = v;
        int n = this.voxelCounts[0];
        this.voxelCounts[0] = this.voxelCounts[2];
        this.voxelCounts[2] = n;
        this.params.insideOut = !this.params.insideOut;
    }
}

