/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.BS;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;

public class XmlXsdReader
extends XmlReader {
    private BS bsBackbone = new BS();
    private int iChain = -1;
    private int iGroup = 0;
    private int iAtom = 0;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        parent.htParams.put("backboneAtoms", this.bsBackbone);
        this.processXml2(parent, saxReader);
        this.asc.atomSymbolicMap.clear();
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        if ("molecule".equals(localName)) {
            this.asc.newAtomSet();
            this.asc.setAtomSetName((String)this.atts.get("name"));
            return;
        }
        if ("linearchain".equals(localName)) {
            this.iGroup = 0;
            ++this.iChain;
        }
        if ("repeatunit".equals(localName)) {
            ++this.iGroup;
        }
        if ("atom3d".equals(localName)) {
            boolean isBackbone;
            this.atom = new Atom();
            this.atom.elementSymbol = (String)this.atts.get("components");
            this.atom.atomName = (String)this.atts.get("id");
            this.atom.atomSerial = ++this.iAtom;
            if (this.iChain >= 0) {
                this.parent.setChainID(this.atom, "" + (char)((this.iChain - 1) % 26 + 65));
            }
            this.atom.group3 = "UNK";
            if (this.iGroup == 0) {
                this.iGroup = 1;
            }
            this.atom.sequenceNumber = this.iGroup;
            String xyz = (String)this.atts.get("xyz");
            if (xyz != null) {
                String[] tokens = PT.getTokens((String)xyz.replace(',', ' '));
                this.atom.set(this.parseFloatStr(tokens[0]), this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]));
            }
            if (isBackbone = "1".equals(this.atts.get("isbackboneatom"))) {
                this.bsBackbone.set(this.iAtom);
            }
            return;
        }
        if ("bond".equals(localName)) {
            String[] atoms = PT.split((String)((String)this.atts.get("connects")), (String)",");
            int order = 1;
            if (this.atts.containsKey("type")) {
                String type = (String)this.atts.get("type");
                if (type.equals("Double")) {
                    order = 2;
                } else if (type.equals("Triple")) {
                    order = 3;
                }
            }
            this.asc.addNewBondFromNames(atoms[0], atoms[1], order);
            return;
        }
    }

    @Override
    void processEndElement(String localName) {
        if ("atom3d".equalsIgnoreCase(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.setKeepChars(false);
    }
}

