/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class AzimuthalEquidistant
extends AbstractProj {
    public static final double EPS10 = 1.0E-10;
    public static final double TOL = 1.0E-14;
    public static final double HALF_PI = 1.5707963267948966;
    protected double semiMajor;
    protected double semiMinor;
    protected double centralMeridian;
    protected double latitudeOfOrigin;
    protected Mode mode;
    protected double sinph0;
    protected double cosph0;
    protected double mp;

    @Override
    public String getName() {
        return I18n.tr("Azimuthal Equidistant", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "aeqd";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        if (params.lon0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lon_0"));
        }
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.centralMeridian = Math.toRadians(params.lon0);
        this.latitudeOfOrigin = Math.toRadians(params.lat0);
        this.semiMajor = params.ellps.a;
        this.semiMinor = params.ellps.b;
        if (Math.abs(this.latitudeOfOrigin - 1.5707963267948966) < 1.0E-10) {
            this.mode = Mode.NORTH_POLAR;
            this.mp = this.mlfn(1.5707963267948966, 1.0, 0.0);
            this.sinph0 = 1.0;
            this.cosph0 = 0.0;
        } else if (Math.abs(this.latitudeOfOrigin + 1.5707963267948966) < 1.0E-10) {
            this.mode = Mode.SOUTH_POLAR;
            this.mp = this.mlfn(-1.5707963267948966, -1.0, 0.0);
            this.sinph0 = -1.0;
            this.cosph0 = 0.0;
        } else {
            if (Math.abs(this.latitudeOfOrigin) < 1.0E-10) {
                this.mode = Mode.EQUATORIAL;
                this.mp = Double.NaN;
                this.sinph0 = 0.0;
                this.cosph0 = 1.0;
                throw new ProjectionConfigurationException("Equatorial AzimuthalEquidistant not yet supported");
            }
            this.mode = Mode.OBLIQUE;
            this.mp = Double.NaN;
            this.sinph0 = Math.sin(this.latitudeOfOrigin);
            this.cosph0 = Math.cos(this.latitudeOfOrigin);
            throw new ProjectionConfigurationException("Oblique AzimuthalEquidistant not yet supported");
        }
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -180.0, 89.0, 180.0, false);
    }

    @Override
    public double[] project(double latRad, double lonRad) {
        return this.spherical ? this.projectSpherical(latRad, lonRad) : this.projectEllipsoidal(latRad, lonRad);
    }

    @Override
    public double[] invproject(double east, double north) {
        return this.spherical ? this.invprojectSpherical(east, north) : this.invprojectEllipsoidal(east, north);
    }

    double[] projectSpherical(double latRad, double lonRad) {
        double x = 0.0;
        double y = 0.0;
        double sinphi = Math.sin(latRad);
        double cosphi = Math.cos(latRad);
        double coslam = Math.cos(lonRad);
        switch (this.mode) {
            case EQUATORIAL: 
            case OBLIQUE: {
                y = this.mode == Mode.EQUATORIAL ? cosphi * coslam : this.sinph0 * sinphi + this.cosph0 * cosphi * coslam;
                if (Math.abs(Math.abs(y) - 1.0) < 1.0E-14) {
                    if (y < 0.0) {
                        throw new JosmRuntimeException("TOLERANCE_ERROR");
                    }
                    x = 0.0;
                    y = 0.0;
                    break;
                }
                y = Math.acos(y);
                y /= Math.sin(y);
                x = y * cosphi * Math.sin(lonRad);
                y *= this.mode == Mode.EQUATORIAL ? sinphi : this.cosph0 * sinphi - this.sinph0 * cosphi * coslam;
                break;
            }
            case NORTH_POLAR: {
                latRad = -latRad;
                coslam = -coslam;
            }
            case SOUTH_POLAR: {
                if (Math.abs(latRad - 1.5707963267948966) < 1.0E-10) {
                    throw new JosmRuntimeException("TOLERANCE_ERROR");
                }
                y = 1.5707963267948966 + latRad;
                x = y * Math.sin(lonRad);
                y *= coslam;
            }
        }
        return new double[]{x, y};
    }

    double[] invprojectSpherical(double east, double north) {
        double x = east;
        double y = north;
        double lambda = 0.0;
        double phi = 0.0;
        double c_rh = Math.hypot(x, y);
        if (c_rh > Math.PI) {
            if (c_rh - 1.0E-10 > Math.PI) {
                throw new JosmRuntimeException("TOLERANCE_ERROR");
            }
        } else if (c_rh < 1.0E-10) {
            phi = this.latitudeOfOrigin;
            lambda = 0.0;
        } else if (this.mode == Mode.OBLIQUE || this.mode == Mode.EQUATORIAL) {
            double sinc = Math.sin(c_rh);
            double cosc = Math.cos(c_rh);
            if (this.mode == Mode.EQUATORIAL) {
                phi = this.aasin(y * sinc / c_rh);
                x *= sinc;
                y = cosc * c_rh;
            } else {
                phi = this.aasin(cosc * this.sinph0 + y * sinc * this.cosph0 / c_rh);
                y = (cosc - this.sinph0 * Math.sin(phi)) * c_rh;
                x *= sinc * this.cosph0;
            }
            lambda = y == 0.0 ? 0.0 : Math.atan2(x, y);
        } else if (this.mode == Mode.NORTH_POLAR) {
            phi = 1.5707963267948966 - c_rh;
            lambda = Math.atan2(x, -y);
        } else {
            phi = c_rh - 1.5707963267948966;
            lambda = Math.atan2(x, y);
        }
        return new double[]{phi, lambda};
    }

    double[] projectEllipsoidal(double latRad, double lonRad) {
        double x = 0.0;
        double y = 0.0;
        double coslam = Math.cos(lonRad);
        double cosphi = Math.cos(latRad);
        double sinphi = Math.sin(latRad);
        switch (this.mode) {
            case NORTH_POLAR: {
                coslam = -coslam;
            }
            case SOUTH_POLAR: {
                double rho = Math.abs(this.mp - this.mlfn(latRad, sinphi, cosphi));
                x = rho * Math.sin(lonRad);
                y = rho * coslam;
                break;
            }
            case EQUATORIAL: 
            case OBLIQUE: {
                if (!(Math.abs(lonRad) < 1.0E-10) || !(Math.abs(latRad - this.latitudeOfOrigin) < 1.0E-10)) break;
                x = 0.0;
                y = 0.0;
            }
        }
        return new double[]{x, y};
    }

    double[] invprojectEllipsoidal(double east, double north) {
        double x = east;
        double y = north;
        double lambda = 0.0;
        double phi = 0.0;
        double c = Math.hypot(x, y);
        if (c < 1.0E-10) {
            phi = this.latitudeOfOrigin;
            lambda = 0.0;
        } else if (this.mode == Mode.OBLIQUE || this.mode == Mode.EQUATORIAL) {
            lambda -= this.centralMeridian;
        } else {
            phi = this.invMlfn(this.mode == Mode.NORTH_POLAR ? this.mp - c : this.mp + c);
            lambda = Math.atan2(x, this.mode == Mode.NORTH_POLAR ? -y : y);
        }
        return new double[]{phi, lambda};
    }

    public static enum Mode {
        NORTH_POLAR,
        SOUTH_POLAR,
        EQUATORIAL,
        OBLIQUE;

    }
}

