/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.io.UploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.tools.I18n;

public final class AsynchronousUploadPrimitivesTask
extends UploadPrimitivesTask {
    private static AsynchronousUploadPrimitivesTask asynchronousUploadPrimitivesTask;
    private final ProgressTaskId taskId;
    private final OsmDataLayer uploadDataLayer;

    private AsynchronousUploadPrimitivesTask(UploadStrategySpecification uploadStrategySpecification, OsmDataLayer osmDataLayer, APIDataSet apiDataSet, Changeset changeset) {
        super(uploadStrategySpecification, osmDataLayer, apiDataSet, changeset);
        this.uploadDataLayer = osmDataLayer;
        this.taskId = new ProgressTaskId("core", "async-upload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<AsynchronousUploadPrimitivesTask> createAsynchronousUploadTask(UploadStrategySpecification uploadStrategySpecification, OsmDataLayer dataLayer, APIDataSet apiDataSet, Changeset changeset) {
        Class<AsynchronousUploadPrimitivesTask> clazz = AsynchronousUploadPrimitivesTask.class;
        synchronized (AsynchronousUploadPrimitivesTask.class) {
            if (asynchronousUploadPrimitivesTask != null) {
                GuiHelper.runInEDTAndWait(() -> JOptionPane.showMessageDialog(MainApplication.parent, I18n.tr("A background upload is already in progress. Kindly wait for it to finish before uploading new changes", new Object[0])));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return Optional.empty();
            }
            asynchronousUploadPrimitivesTask = new AsynchronousUploadPrimitivesTask(uploadStrategySpecification, dataLayer, apiDataSet, changeset);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return Optional.ofNullable(asynchronousUploadPrimitivesTask);
        }
    }

    public static Optional<AsynchronousUploadPrimitivesTask> getCurrentAsynchronousUploadTask() {
        return Optional.ofNullable(asynchronousUploadPrimitivesTask);
    }

    @Override
    public ProgressTaskId canRunInBackground() {
        return this.taskId;
    }

    @Override
    protected void realRun() {
        GuiHelper.runInEDTAndWait(() -> {
            MainApplication.undoRedo.clean(this.uploadDataLayer.getDataSet());
            MainApplication.getLayerManager().prepareLayerForUpload(this.uploadDataLayer);
            LayerListDialog.getInstance().repaint();
        });
        super.realRun();
    }

    @Override
    protected void cancel() {
        super.cancel();
        asynchronousUploadPrimitivesTask = null;
    }

    @Override
    protected void finish() {
        try {
            GuiHelper.runInEDTAndWait(() -> {
                MainApplication.getLayerManager().processLayerAfterUpload(this.uploadDataLayer);
                LayerListDialog.getInstance().repaint();
            });
            super.finish();
        }
        finally {
            asynchronousUploadPrimitivesTask = null;
        }
    }
}

