/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.importexport.JpgImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class ImportImagesAction
extends AbstractAction {
    private final transient GpxLayer layer;

    public ImportImagesAction(GpxLayer layer) {
        super(I18n.tr("Import images", new Object[0]));
        new ImageProvider("dialogs/geoimage").getResource().attachImageIcon(this, true);
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ImportImages"));
    }

    private static void warnCantImportIntoServerLayer(GpxLayer layer) {
        String msg = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with images.</html>", Utils.escapeReservedCharactersHTML(layer.getName()));
        HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Import not possible", new Object[0]), 2, HelpUtil.ht("/Action/ImportImages#CantImportIntoGpxLayerFromServer"));
    }

    private static void addRecursiveFiles(List<File> files, File ... sel) {
        if (sel == null) {
            return;
        }
        for (File f : sel) {
            if (f.isDirectory()) {
                ImportImagesAction.addRecursiveFiles(files, f.listFiles());
                continue;
            }
            if (!Utils.hasExtension(f, "jpg")) continue;
            files.add(f);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File[] sel;
        if (this.layer.data.fromServer) {
            ImportImagesAction.warnCantImportIntoServerLayer(this.layer);
            return;
        }
        JpgImporter importer = new JpgImporter(this.layer);
        AbstractFileChooser fc = new FileChooserManager(true, "geoimage.lastdirectory", Config.getPref().get("lastDirectory")).createFileChooser(true, null, importer.filter, 2).openFileChooser();
        if (fc != null && (sel = fc.getSelectedFiles()) != null && sel.length > 0) {
            LinkedList<File> files = new LinkedList<File>();
            ImportImagesAction.addRecursiveFiles(files, sel);
            importer.importDataHandleExceptions(files, NullProgressMonitor.INSTANCE);
        }
    }
}

