/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.spi.preferences.Config;

public abstract class StyleElement
implements StyleKeys {
    protected static final int ICON_IMAGE_IDX = 0;
    protected static final int ICON_WIDTH_IDX = 1;
    protected static final int ICON_HEIGHT_IDX = 2;
    protected static final int ICON_OPACITY_IDX = 3;
    protected static final int ICON_OFFSET_X_IDX = 4;
    protected static final int ICON_OFFSET_Y_IDX = 5;
    public float majorZIndex;
    public float zIndex;
    public float objectZIndex;
    public boolean isModifier;
    public boolean defaultSelectedHandling;
    private static volatile String defaultFontName;
    private static volatile Float defaultFontSize;
    private static final Object lock;
    private static final Map<FontDescriptor, Font> FONT_MAP;

    public StyleElement(float majorZindex, float zIndex, float objectZindex, boolean isModifier, boolean defaultSelectedHandling) {
        this.majorZIndex = majorZindex;
        this.zIndex = zIndex;
        this.objectZIndex = objectZindex;
        this.isModifier = isModifier;
        this.defaultSelectedHandling = defaultSelectedHandling;
    }

    protected StyleElement(Cascade c, float defaultMajorZindex) {
        this.majorZIndex = c.get("major-z-index", Float.valueOf(defaultMajorZindex), Float.class).floatValue();
        this.zIndex = c.get("z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.objectZIndex = c.get("object-z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.isModifier = c.get("modifier", Boolean.FALSE, Boolean.class);
        this.defaultSelectedHandling = c.isDefaultSelectedHandling();
    }

    public abstract void paintPrimitive(IPrimitive var1, MapPaintSettings var2, StyledMapRenderer var3, boolean var4, boolean var5, boolean var6);

    public boolean isProperLineStyle() {
        return false;
    }

    protected static Float getWidth(Cascade c, String key, Float relativeTo) {
        Float width = c.get(key, null, Float.class, true);
        if (width != null) {
            if (width.floatValue() > 0.0f) {
                return width;
            }
        } else {
            Instruction.RelativeFloat widthRel;
            Keyword widthKW = c.get(key, null, Keyword.class, true);
            if (Keyword.THINNEST.equals(widthKW)) {
                return Float.valueOf(0.0f);
            }
            if (Keyword.DEFAULT.equals(widthKW)) {
                return Float.valueOf(MapPaintSettings.INSTANCE.getDefaultSegmentWidth());
            }
            if (relativeTo != null && (widthRel = c.get(key, null, Instruction.RelativeFloat.class, true)) != null) {
                return Float.valueOf(relativeTo.floatValue() + widthRel.val);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Float getDefaultFontSize() {
        Float s = defaultFontSize;
        if (s == null) {
            Object object = lock;
            synchronized (object) {
                s = defaultFontSize;
                if (s == null) {
                    defaultFontSize = s = Float.valueOf(Config.getPref().getInt("mappaint.fontsize", 8));
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultFontName() {
        String n = defaultFontName;
        if (n == null) {
            Object object = lock;
            synchronized (object) {
                n = defaultFontName;
                if (n == null) {
                    defaultFontName = n = Config.getPref().get("mappaint.font", "Droid Sans");
                }
            }
        }
        return n;
    }

    private static Font getCachedFont(FontDescriptor fd) {
        Font f = FONT_MAP.get(fd);
        if (f != null) {
            return f;
        }
        f = new Font(fd.name, fd.style, fd.size);
        FONT_MAP.put(fd, f);
        return f;
    }

    private static Font getCachedFont(String name, int style, int size) {
        return StyleElement.getCachedFont(new FontDescriptor(name, style, size));
    }

    protected static Font getFont(Cascade c, String s) {
        Font f;
        String name = c.get("font-family", StyleElement.getDefaultFontName(), String.class);
        float size = c.get("font-size", StyleElement.getDefaultFontSize(), Float.class).floatValue();
        int weight = 0;
        if ("bold".equalsIgnoreCase(c.get("font-weight", null, String.class))) {
            weight = 1;
        }
        int style = 0;
        if ("italic".equalsIgnoreCase(c.get("font-style", null, String.class))) {
            style = 2;
        }
        if ((f = StyleElement.getCachedFont(name, style | weight, Math.round(size))).canDisplayUpTo(s) == -1) {
            return f;
        }
        return StyleElement.getCachedFont("SansSerif", style | weight, Math.round(size));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleElement that = (StyleElement)o;
        return this.isModifier == that.isModifier && Float.compare(that.majorZIndex, this.majorZIndex) == 0 && Float.compare(that.zIndex, this.zIndex) == 0 && Float.compare(that.objectZIndex, this.objectZIndex) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.majorZIndex), Float.valueOf(this.zIndex), Float.valueOf(this.objectZIndex), this.isModifier);
    }

    public String toString() {
        return String.format("z_idx=[%s/%s/%s] ", Float.valueOf(this.majorZIndex), Float.valueOf(this.zIndex), Float.valueOf(this.objectZIndex)) + (this.isModifier ? "modifier " : "");
    }

    static {
        lock = new Object();
        FONT_MAP = new HashMap<FontDescriptor, Font>();
    }

    private static class FontDescriptor {
        public String name;
        public int style;
        public int size;

        FontDescriptor(String name, int style, int size) {
            this.name = name;
            this.style = style;
            this.size = size;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.style, this.size);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FontDescriptor that = (FontDescriptor)obj;
            return this.style == that.style && this.size == that.size && Objects.equals(this.name, that.name);
        }
    }
}

