/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractReader {
    protected DataSet ds = new DataSet();
    protected Changeset uploadChangeset;
    protected final Map<PrimitiveId, OsmPrimitive> externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    protected final Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    protected final Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();

    public DataSet getDataSet() {
        return this.ds;
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive primitive : this.externalIdMap.values()) {
            if (!(primitive instanceof Node)) continue;
            this.ds.addPrimitive(primitive);
        }
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Map.Entry<Long, Collection<Long>> entry : this.ways.entrySet()) {
            Long externalWayId = entry.getKey();
            Way w = (Way)this.externalIdMap.get(new SimplePrimitiveId(externalWayId, OsmPrimitiveType.WAY));
            ArrayList<Node> wayNodes = new ArrayList<Node>();
            for (long id : entry.getValue()) {
                Node n = (Node)this.externalIdMap.get(new SimplePrimitiveId(id, OsmPrimitiveType.NODE));
                if (n == null) {
                    if (id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", Long.toString(externalWayId), Long.toString(id)));
                    }
                    n = (Node)this.ds.getPrimitiveById(id, OsmPrimitiveType.NODE);
                    if (n == null) {
                        n = new Node(id);
                        this.ds.addPrimitive(n);
                    }
                }
                if (n.isDeleted()) {
                    Logging.info(I18n.tr("Deleted node {0} is part of way {1}", Long.toString(id), Long.toString(w.getId())));
                    continue;
                }
                wayNodes.add(n);
            }
            w.setNodes((List<Node>)wayNodes);
            if (w.hasIncompleteNodes()) {
                Logging.info(I18n.tr("Way {0} with {1} nodes is incomplete because at least one node was missing in the loaded data.", Long.toString(externalWayId), w.getNodesCount()));
            }
            this.ds.addPrimitive(w);
        }
    }

    protected void processRelationsAfterParsing() throws IllegalDataException {
        for (Long l : this.relations.keySet()) {
            Relation relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
            this.ds.addPrimitive(relation);
        }
        for (Map.Entry entry : this.relations.entrySet()) {
            Long externalRelationId = (Long)entry.getKey();
            Relation relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(externalRelationId, OsmPrimitiveType.RELATION));
            ArrayList<RelationMember> relationMembers = new ArrayList<RelationMember>();
            for (RelationMemberData rm : (Collection)entry.getValue()) {
                OsmPrimitive primitive = this.externalIdMap.get(new SimplePrimitiveId(rm.getMemberId(), rm.getMemberType()));
                if (primitive == null) {
                    if (rm.getMemberId() <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", Long.toString(externalRelationId), Long.toString(rm.getMemberId())));
                    }
                    primitive = (OsmPrimitive)this.ds.getPrimitiveById(rm.getMemberId(), rm.getMemberType());
                    if (primitive == null) {
                        switch (rm.getMemberType()) {
                            case NODE: {
                                primitive = new Node(rm.getMemberId());
                                break;
                            }
                            case WAY: {
                                primitive = new Way(rm.getMemberId());
                                break;
                            }
                            case RELATION: {
                                primitive = new Relation(rm.getMemberId());
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.ds.addPrimitive(primitive);
                        this.externalIdMap.put(new SimplePrimitiveId(rm.getMemberId(), rm.getMemberType()), primitive);
                    }
                }
                if (primitive.isDeleted()) {
                    Logging.info(I18n.tr("Deleted member {0} is used by relation {1}", Long.toString(primitive.getId()), Long.toString(relation.getId())));
                    continue;
                }
                relationMembers.add(new RelationMember(rm.getRole(), primitive));
            }
            relation.setMembers((List<RelationMember>)relationMembers);
        }
    }

    protected void processChangesetAfterParsing() {
        if (this.uploadChangeset != null) {
            for (Map.Entry<String, String> e : this.uploadChangeset.getKeys().entrySet()) {
                this.ds.addChangeSetTag(e.getKey(), e.getValue());
            }
        }
    }

    protected final void prepareDataSet() throws IllegalDataException {
        this.ds.beginUpdate();
        try {
            this.processNodesAfterParsing();
            this.processWaysAfterParsing();
            this.processRelationsAfterParsing();
            this.processChangesetAfterParsing();
        }
        finally {
            this.ds.endUpdate();
        }
    }

    protected abstract DataSet doParseDataSet(InputStream var1, ProgressMonitor var2) throws IllegalDataException;
}

