/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class Logging {
    public static final Level LEVEL_ERROR = Level.SEVERE;
    public static final Level LEVEL_WARN = Level.WARNING;
    public static final Level LEVEL_INFO = Level.INFO;
    public static final Level LEVEL_DEBUG = Level.FINE;
    public static final Level LEVEL_TRACE = Level.FINEST;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final RememberWarningHandler WARNINGS = new RememberWarningHandler();

    private Logging() {
    }

    public static void setLogLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public static void error(String message) {
        Logging.logPrivate(LEVEL_ERROR, message);
    }

    public static void error(String pattern, Object ... args) {
        Logging.logPrivate(LEVEL_ERROR, pattern, args);
    }

    public static void error(Throwable t) {
        Logging.logWithStackTrace(LEVEL_ERROR, t);
    }

    public static void warn(String message) {
        Logging.logPrivate(LEVEL_WARN, message);
    }

    public static void warn(String pattern, Object ... args) {
        Logging.logPrivate(LEVEL_WARN, pattern, args);
    }

    public static void warn(Throwable t) {
        Logging.logWithStackTrace(LEVEL_WARN, t);
    }

    public static void info(String message) {
        Logging.logPrivate(LEVEL_INFO, message);
    }

    public static void info(String pattern, Object ... args) {
        Logging.logPrivate(LEVEL_INFO, pattern, args);
    }

    public static void info(Throwable t) {
        Logging.logWithStackTrace(LEVEL_INFO, t);
    }

    public static void debug(String message) {
        Logging.logPrivate(LEVEL_DEBUG, message);
    }

    public static void debug(String pattern, Object ... args) {
        Logging.logPrivate(LEVEL_DEBUG, pattern, args);
    }

    public static void debug(Throwable t) {
        Logging.log(LEVEL_DEBUG, t);
    }

    public static void trace(String message) {
        Logging.logPrivate(LEVEL_TRACE, message);
    }

    public static void trace(String pattern, Object ... args) {
        Logging.logPrivate(LEVEL_TRACE, pattern, args);
    }

    public static void trace(Throwable t) {
        Logging.log(LEVEL_TRACE, t);
    }

    public static void log(Level level, Throwable t) {
        Logging.logPrivate(level, () -> Logging.getErrorLog(null, t));
    }

    public static void log(Level level, String message, Throwable t) {
        Logging.logPrivate(level, () -> Logging.getErrorLog(message, t));
    }

    public static void logWithStackTrace(Level level, Throwable t) {
        Logging.logPrivate(level, () -> Logging.getErrorLogWithStack(null, t));
    }

    public static void logWithStackTrace(Level level, String message, Throwable t) {
        Logging.logPrivate(level, () -> Logging.getErrorLogWithStack(message, t));
    }

    public static void logWithStackTrace(Level level, Throwable t, String pattern, Object ... args) {
        Logging.logPrivate(level, () -> Logging.getErrorLogWithStack(MessageFormat.format(pattern, args), t));
    }

    private static void logPrivate(Level level, String pattern, Object ... args) {
        Logging.logPrivate(level, () -> MessageFormat.format(pattern, args));
    }

    private static void logPrivate(Level level, String message) {
        Logging.logPrivate(level, () -> message);
    }

    private static void logPrivate(Level level, Supplier<String> supplier) {
        if (LOGGER.isLoggable(level)) {
            StackTraceElement callingMethod = BugReport.getCallingMethod(1, Logging.class.getName(), name -> !"logPrivate".equals(name));
            LOGGER.logp(level, callingMethod.getClassName(), callingMethod.getMethodName(), supplier);
        }
    }

    public static boolean isLoggingEnabled(Level level) {
        return LOGGER.isLoggable(level);
    }

    public static boolean isDebugEnabled() {
        return Logging.isLoggingEnabled(LEVEL_DEBUG);
    }

    public static boolean isTraceEnabled() {
        return Logging.isLoggingEnabled(LEVEL_TRACE);
    }

    private static String getErrorLog(String message, Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message).append(": ");
        }
        sb.append(Logging.getErrorMessage(t));
        return sb.toString();
    }

    private static String getErrorLogWithStack(String message, Throwable t) {
        StringWriter sb = new StringWriter();
        sb.append(Logging.getErrorLog(message, t));
        if (t != null) {
            sb.append('\n');
            t.printStackTrace(new PrintWriter(sb));
        }
        return sb.toString();
    }

    public static String getErrorMessage(Throwable t) {
        Throwable cause;
        if (t == null) {
            return "(no error)";
        }
        StringBuilder sb = new StringBuilder(t.getClass().getName());
        String msg = t.getMessage();
        if (msg != null) {
            sb.append(": ").append(msg.trim());
        }
        if ((cause = t.getCause()) != null && !cause.equals(t)) {
            sb.append(". ").append(I18n.tr("Cause: ", new Object[0])).append(Logging.getErrorMessage(cause));
        }
        return sb.toString();
    }

    public static void clearLastErrorAndWarnings() {
        WARNINGS.clear();
    }

    public static List<String> getLastErrorAndWarnings() {
        return WARNINGS.getMessages();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    static {
        I18n.setupJavaLocaleProviders();
        LOGGER.setLevel(Level.ALL);
        LOGGER.setUseParentHandlers(false);
        Utils.updateSystemProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT.%1$tL %4$s: %5$s%6$s%n");
        ReacquiringConsoleHandler stderr = new ReacquiringConsoleHandler(() -> System.err, null);
        LOGGER.addHandler(stderr);
        try {
            stderr.setLevel(LEVEL_WARN);
        }
        catch (SecurityException e) {
            System.err.println("Unable to set logging level: " + e.getMessage());
        }
        ReacquiringConsoleHandler stdout = new ReacquiringConsoleHandler(() -> System.out, stderr);
        LOGGER.addHandler(stdout);
        try {
            stdout.setLevel(Level.ALL);
        }
        catch (SecurityException e) {
            System.err.println("Unable to set logging level: " + e.getMessage());
        }
        LOGGER.addHandler(WARNINGS);
        Logging.setLogLevel(LEVEL_INFO);
    }

    private static class RememberWarningHandler
    extends Handler {
        private final String[] log = new String[10];
        private int messagesLogged;

        private RememberWarningHandler() {
        }

        synchronized void clear() {
            this.messagesLogged = 0;
            Arrays.fill(this.log, null);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (record.getLevel().intValue() < LEVEL_WARN.intValue()) {
                return;
            }
            String msg = RememberWarningHandler.getPrefix(record) + record.getMessage();
            int idx = msg.indexOf(10);
            if (idx > 0) {
                msg = msg.substring(0, idx);
            }
            this.log[this.messagesLogged % this.log.length] = msg;
            ++this.messagesLogged;
        }

        private static String getPrefix(LogRecord record) {
            if (record.getLevel().equals(LEVEL_WARN)) {
                return "W: ";
            }
            return "E: ";
        }

        synchronized List<String> getMessages() {
            List<String> logged = Arrays.asList(this.log);
            ArrayList<String> res = new ArrayList<String>();
            int logOffset = this.messagesLogged % this.log.length;
            if (this.messagesLogged > logOffset) {
                res.addAll(logged.subList(logOffset, this.log.length));
            }
            res.addAll(logged.subList(0, logOffset));
            return res;
        }

        @Override
        public synchronized void flush() {
        }

        @Override
        public void close() {
        }
    }

    public static class ReacquiringConsoleHandler
    extends ConsoleHandler {
        private final Supplier<OutputStream> outputStreamSupplier;
        private final Handler prioritizedHandler;
        private OutputStream outputStreamMemo;

        public ReacquiringConsoleHandler(Supplier<OutputStream> outputStreamSupplier, Handler prioritizedHandler) {
            this.outputStreamSupplier = outputStreamSupplier;
            this.prioritizedHandler = prioritizedHandler;
            this.reacquireOutputStream();
        }

        public synchronized void reacquireOutputStream() {
            OutputStream reacquiredStream = this.outputStreamSupplier.get();
            if (reacquiredStream != this.outputStreamMemo) {
                this.setOutputStream(reacquiredStream);
            }
        }

        @Override
        public synchronized void setOutputStream(OutputStream outputStream) {
            this.outputStreamMemo = outputStream;
            super.setOutputStream(outputStream);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (this.prioritizedHandler == null || !this.prioritizedHandler.isLoggable(record)) {
                super.publish(record);
            }
        }
    }
}

