/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class ClosureLocalVariable
extends LocalVariable {
    private boolean definedLocally = true;

    public ClosureLocalVariable(RubySymbol name2, int scopeDepth, int location) {
        super(name2, scopeDepth, location);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClosureLocalVariable)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public int compareTo(Object arg0) {
        int b2;
        if (!(arg0 instanceof ClosureLocalVariable)) {
            return 0;
        }
        int a = this.hashCode();
        return a < (b2 = arg0.hashCode()) ? -1 : (a == b2 ? 0 : 1);
    }

    public boolean isDefinedLocally() {
        return this.definedLocally;
    }

    @Override
    public Variable clone(SimpleCloneInfo ii) {
        ClosureLocalVariable lv = new ClosureLocalVariable(this.name, this.scopeDepth, this.offset);
        lv.definedLocally = this.definedLocally;
        return lv;
    }

    @Override
    public LocalVariable cloneForDepth(int n) {
        ClosureLocalVariable lv = new ClosureLocalVariable(this.name, n, this.offset);
        if (this.definedLocally && n > 0) {
            lv.definedLocally = false;
        }
        return lv;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ClosureLocalVariable(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
    }

    @Override
    public String toString() {
        return this.name + "(" + this.scopeDepth + ":" + this.offset + ":local=" + this.definedLocally + ")";
    }
}

