/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarVirtualFile
extends VirtualFile {
    private final CoreJarHandler myHandler;
    private final CharSequence myName;
    private final long myLength;
    private final long myTimestamp;
    private final VirtualFile myParent;
    private VirtualFile[] myChildren;

    /*
     * WARNING - void declaration
     */
    public CoreJarVirtualFile(@NotNull CoreJarHandler handler2, @NotNull CharSequence name, long length, long timestamp, @Nullable CoreJarVirtualFile coreJarVirtualFile) {
        void parent2;
        if (handler2 == null) {
            CoreJarVirtualFile.$$$reportNull$$$0(0);
        }
        if (name == null) {
            CoreJarVirtualFile.$$$reportNull$$$0(1);
        }
        this.myChildren = VirtualFile.EMPTY_ARRAY;
        this.myHandler = handler2;
        this.myName = name;
        this.myLength = length;
        this.myTimestamp = timestamp;
        this.myParent = parent2;
    }

    void setChildren(VirtualFile[] children2) {
        this.myChildren = children2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName.toString();
        if (string == null) {
            CoreJarVirtualFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myHandler.getFileSystem();
        if (coreJarFileSystem == null) {
            CoreJarVirtualFile.$$$reportNull$$$0(3);
        }
        return coreJarFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            String string = FileUtil.toSystemIndependentName(this.myHandler.getFile().getPath()) + "!/";
            if (string == null) {
                CoreJarVirtualFile.$$$reportNull$$$0(4);
            }
            return string;
        }
        String parentPath = this.myParent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.myName.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.myName);
        String string = answer.toString();
        if (string == null) {
            CoreJarVirtualFile.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.myLength < 0L;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Override
    public VirtualFile[] getChildren() {
        return this.myChildren;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Couple<String> pair = ((CoreJarFileSystem)this.getFileSystem()).splitPath(this.getPath());
        byte[] byArray = this.myHandler.contentsToByteArray((String)pair.second);
        if (byArray == null) {
            CoreJarVirtualFile.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myTimestamp;
    }

    @Override
    public long getLength() {
        return this.myLength;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray());
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

