/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicsKt;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.CompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsics;", "", "()V", "factories", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "intrinsicCache", "", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsics$IntrinsicKey;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "computeAndCache", "key", "getIntrinsic", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "IntrinsicKey", "js.translator"})
public final class BinaryOperationIntrinsics {
    private final Map<IntrinsicKey, BinaryOperationIntrinsic> intrinsicCache;
    private final List<BinaryOperationIntrinsicFactory> factories;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BinaryOperationIntrinsic getIntrinsic(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        void leftType;
        KtToken token;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        CallableDescriptor callableDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2);
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        Pair<KotlinType, KotlinType> pair = BinaryOperationIntrinsicsKt.binaryOperationTypes(expression2, context);
        KotlinType kotlinType = pair.component1();
        KotlinType rightType = pair.component2();
        KtToken ktToken = token = PsiUtils.getOperationToken(expression2);
        Intrinsics.checkExpressionValueIsNotNull(ktToken, "token");
        return this.computeAndCache(new IntrinsicKey(ktToken, descriptor2, (KotlinType)leftType, rightType));
    }

    private final BinaryOperationIntrinsic computeAndCache(IntrinsicKey key) {
        BinaryOperationIntrinsic binaryOperationIntrinsic;
        Map<IntrinsicKey, BinaryOperationIntrinsic> map2;
        block2: {
            Map<IntrinsicKey, BinaryOperationIntrinsic> map3 = this.intrinsicCache;
            map2 = map3;
            if (map2.containsKey(key)) {
                return this.intrinsicCache.get(key);
            }
            Iterable $receiver$iv = this.factories;
            for (Object element$iv : $receiver$iv) {
                BinaryOperationIntrinsicFactory factory2 = (BinaryOperationIntrinsicFactory)element$iv;
                BinaryOperationIntrinsic result$iv = factory2.getSupportTokens().contains(key.getToken()) ? factory2.getIntrinsic(key.getFunction(), key.getLeftType(), key.getRightType()) : null;
                if (result$iv == null) continue;
                binaryOperationIntrinsic = result$iv;
                break block2;
            }
            binaryOperationIntrinsic = null;
        }
        BinaryOperationIntrinsic result2 = binaryOperationIntrinsic;
        map2 = this.intrinsicCache;
        Iterator iterator2 = result2;
        map2.put(key, (BinaryOperationIntrinsic)((Object)iterator2));
        return result2;
    }

    public BinaryOperationIntrinsics() {
        Map map2;
        BinaryOperationIntrinsics binaryOperationIntrinsics = this;
        binaryOperationIntrinsics.intrinsicCache = map2 = (Map)new LinkedHashMap();
        this.factories = CollectionsKt.listOf(CompareToBOIF.INSTANCE, EqualsBOIF.INSTANCE);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J5\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsics$IntrinsicKey;", "", "token", "Lorg/jetbrains/kotlin/lexer/KtToken;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "(Lorg/jetbrains/kotlin/lexer/KtToken;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getFunction", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getLeftType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getRightType", "getToken", "()Lorg/jetbrains/kotlin/lexer/KtToken;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "js.translator"})
    private static final class IntrinsicKey {
        @NotNull
        private final KtToken token;
        @NotNull
        private final FunctionDescriptor function;
        @Nullable
        private final KotlinType leftType;
        @Nullable
        private final KotlinType rightType;

        @NotNull
        public final KtToken getToken() {
            return this.token;
        }

        @NotNull
        public final FunctionDescriptor getFunction() {
            return this.function;
        }

        @Nullable
        public final KotlinType getLeftType() {
            return this.leftType;
        }

        @Nullable
        public final KotlinType getRightType() {
            return this.rightType;
        }

        public IntrinsicKey(@NotNull KtToken token, @NotNull FunctionDescriptor function2, @Nullable KotlinType leftType, @Nullable KotlinType rightType) {
            Intrinsics.checkParameterIsNotNull(token, "token");
            Intrinsics.checkParameterIsNotNull(function2, "function");
            this.token = token;
            this.function = function2;
            this.leftType = leftType;
            this.rightType = rightType;
        }

        @NotNull
        public final KtToken component1() {
            return this.token;
        }

        @NotNull
        public final FunctionDescriptor component2() {
            return this.function;
        }

        @Nullable
        public final KotlinType component3() {
            return this.leftType;
        }

        @Nullable
        public final KotlinType component4() {
            return this.rightType;
        }

        @NotNull
        public final IntrinsicKey copy(@NotNull KtToken token, @NotNull FunctionDescriptor function2, @Nullable KotlinType leftType, @Nullable KotlinType rightType) {
            Intrinsics.checkParameterIsNotNull(token, "token");
            Intrinsics.checkParameterIsNotNull(function2, "function");
            return new IntrinsicKey(token, function2, leftType, rightType);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ IntrinsicKey copy$default(IntrinsicKey intrinsicKey, KtToken ktToken, FunctionDescriptor functionDescriptor, KotlinType kotlinType, KotlinType kotlinType2, int n, Object object) {
            if ((n & 1) != 0) {
                ktToken = intrinsicKey.token;
            }
            if ((n & 2) != 0) {
                functionDescriptor = intrinsicKey.function;
            }
            if ((n & 4) != 0) {
                kotlinType = intrinsicKey.leftType;
            }
            if ((n & 8) != 0) {
                kotlinType2 = intrinsicKey.rightType;
            }
            return intrinsicKey.copy(ktToken, functionDescriptor, kotlinType, kotlinType2);
        }

        public String toString() {
            return "IntrinsicKey(token=" + this.token + ", function=" + this.function + ", leftType=" + this.leftType + ", rightType=" + this.rightType + ")";
        }

        public int hashCode() {
            KtToken ktToken = this.token;
            FunctionDescriptor functionDescriptor = this.function;
            KotlinType kotlinType = this.leftType;
            KotlinType kotlinType2 = this.rightType;
            return (((ktToken != null ? ((Object)ktToken).hashCode() : 0) * 31 + (functionDescriptor != null ? functionDescriptor.hashCode() : 0)) * 31 + (kotlinType != null ? ((Object)kotlinType).hashCode() : 0)) * 31 + (kotlinType2 != null ? ((Object)kotlinType2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IntrinsicKey)) break block3;
                    IntrinsicKey intrinsicKey = (IntrinsicKey)object;
                    if (!Intrinsics.areEqual(this.token, intrinsicKey.token) || !Intrinsics.areEqual(this.function, intrinsicKey.function) || !Intrinsics.areEqual(this.leftType, intrinsicKey.leftType) || !Intrinsics.areEqual(this.rightType, intrinsicKey.rightType)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

