/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Map;
import java.util.regex.Pattern;
import writer2latex.api.Config;
import writer2latex.latex.CharClasses;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.SmToken;
import writer2latex.latex.SmTokenTable;
import writer2latex.latex.TGroup;
import writer2latex.latex.Token;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.i18n.I18n;
import writer2latex.util.Calc;
import writer2latex.util.SimpleInputBuffer;

public final class StarMathConverter
implements writer2latex.api.StarMathConverter {
    private SmTokenTable keywords = new SmTokenTable(SmTokenTable.keywords);
    private SmTokenTable symbols = new SmTokenTable(SmTokenTable.symbols);
    private LaTeXConfig config;
    private Map<String, String> configSymbols;
    private boolean bUseColor;
    private int nMaxMatrixCols = 10;
    private SmToken curToken = new SmToken();
    private SimpleInputBuffer buffer;
    private I18n i18n;
    Pattern numberPattern;
    private boolean bDefeq = false;
    private boolean bLambdabar = false;
    private boolean bDdotsup = false;
    private boolean bMultimapdotbothA = false;
    private boolean bMultimapdotbothB = false;
    private boolean bLlbracket = false;
    private boolean bRrbracket = false;
    private boolean bOiint = false;
    private boolean bOiiint = false;
    private boolean bWideslash = false;
    private boolean bWidebslash = false;
    private boolean bBoldsubformula = false;
    private boolean bNormalsubformula = false;
    private boolean bMultiscripts = false;
    private boolean bMathoverstrike = false;

    private void createNumberPattern() {
        this.numberPattern = Pattern.compile("^[0-9]*\\.?[0-9]*$");
    }

    public StarMathConverter() {
        this.config = new LaTeXConfig();
        this.i18n = new ClassicI18n(this.config);
        this.configSymbols = this.config.getMathSymbols();
        this.bUseColor = this.config.useColor();
        this.createNumberPattern();
    }

    StarMathConverter(I18n i18n, LaTeXConfig config) {
        this.config = config;
        this.i18n = i18n;
        this.configSymbols = config.getMathSymbols();
        this.bUseColor = config.useColor();
        this.createNumberPattern();
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bMultiscripts || this.bMathoverstrike) {
            pack.append("\\usepackage{calc}").nl();
        }
        if (this.config.useOoomath()) {
            pack.append("\\usepackage{ooomath}").nl();
        } else {
            if (this.bDefeq) {
                decl.append("\\newcommand\\defeq{\\stackrel{\\mathrm{def}}{=}}").nl();
            }
            if (this.bLambdabar) {
                decl.append("\\newcommand\\lambdabar{\\mathchar'26\\mkern-10mu\\lambda}").nl();
            }
            if (this.bDdotsup) {
                decl.append("\\newcommand\\ddotsup{\\mathinner{\\mkern1mu\\raise1pt\\vbox{\\kern7pt\\hbox{.}}\\mkern2mu\\raise4pt\\hbox{.}\\mkern2mu\\raise7pt\\hbox{.}\\mkern1mu}}").nl();
            }
            if (this.bMultimapdotbothA) {
                decl.append("\\providecommand\\multimapdotbothA{\\bullet\\kern-0.4em-\\kern-0.4em\\circ}").nl();
            }
            if (this.bMultimapdotbothB) {
                decl.append("\\providecommand\\multimapdotbothB{\\circ\\kern-0.4em-\\kern-0.4em\\bullet}").nl();
            }
            if (this.bLlbracket) {
                decl.append("\\providecommand\\llbracket{[}").nl();
            }
            if (this.bRrbracket) {
                decl.append("\\providecommand\\rrbracket{]}").nl();
            }
            if (this.bOiint) {
                decl.append("\\providecommand\\oiint{\\oint}").nl();
            }
            if (this.bOiiint) {
                decl.append("\\providecommand\\oiiint{\\oint}").nl();
            }
            if (this.bWideslash) {
                decl.append("\\newcommand\\wideslash[2]{{}^{#1}/_{#2}}").nl();
            }
            if (this.bWidebslash) {
                decl.append("\\newcommand\\widebslash[2]{{}_{#1}\\backslash^{#2}}").nl();
            }
            if (this.bBoldsubformula) {
                decl.append("\\newcommand\\boldsubformula[1]{\\text{\\mathversion{bold}$#1$}}").nl();
            }
            if (this.bNormalsubformula) {
                decl.append("\\newcommand\\normalsubformula[1]{\\text{\\mathversion{normal}$#1$}}").nl();
            }
            if (this.bMultiscripts || this.bMathoverstrike) {
                decl.append("\\newlength{\\idxmathdepth}\\newlength{\\idxmathtotal}\\newlength{\\idxmathwidth}\\newlength{\\idxraiseme}").nl();
                decl.append("\\newcommand{\\idxdheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\displaystyle#1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\displaystyle#1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\displaystyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
                decl.append("\\newcommand{\\idxtheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\textstyle #1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\textstyle #1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\textstyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
                decl.append("\\newcommand{\\idxsheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\scriptstyle #1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\scriptstyle #1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\scriptstyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
                decl.append("\\newcommand{\\idxssheight}[1]{\\protect\\settoheight{\\idxmathtotal}{\\(\\scriptscriptstyle #1\\)}\\protect\\settodepth{\\idxmathdepth}{\\(\\scriptscriptstyle #1\\)}\\protect\\settowidth{\\idxmathwidth}{\\(\\scriptscriptstyle#1\\)}\\protect\\addtolength{\\idxmathtotal}{\\idxmathdepth}\\protect\\setlength{\\idxraiseme}{\\idxmathtotal/2-\\idxmathdepth}}").nl();
            }
            if (this.bMultiscripts) {
                decl.append("\\newcommand\\multiscripts[5]{\\mathchoice").append("{\\idxdheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}").append("{\\idxtheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}").append("{\\idxsheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}").append("{\\idxssheight{#4}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#1\\underset{#2}{\\overset{#3}{#4}}\\rule[-\\idxmathdepth]{0mm}{\\idxmathtotal}#5}}").nl();
            }
            if (this.bMathoverstrike) {
                decl.append("\\newcommand\\mathoverstrike[1]{\\mathchoice").append("{\\idxdheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}").append("{\\idxtheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}").append("{\\idxsheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}").append("{\\idxssheight{#1}\\rlap{\\rule[\\idxraiseme]{\\idxmathwidth}{0.4pt}}{#1}}}").nl();
            }
        }
        if (this.nMaxMatrixCols > 10) {
            decl.append("\\setcounter{MaxMatrixCols}{").append(this.nMaxMatrixCols).append("}").nl();
        }
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getPreamble() {
        LaTeXDocumentPortion decl = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion pack = new LaTeXDocumentPortion(false);
        this.i18n.appendDeclarations(pack, decl);
        this.appendDeclarations(pack, decl);
        return pack.toString() + decl.toString();
    }

    private boolean tokenInGroup(TGroup eGroup) {
        return this.curToken.eGroup1 == eGroup || this.curToken.eGroup2 == eGroup;
    }

    private void skipWhiteSpaces() {
        while (Character.isWhitespace(this.buffer.peekChar())) {
            this.buffer.getChar();
        }
    }

    private void skipComment() {
        if (this.buffer.peekChar() != '%' || this.buffer.peekFollowingChar() != '%') {
            return;
        }
        while (!CharClasses.isEndOrLineEnd(this.buffer.peekChar())) {
            this.buffer.getChar();
        }
    }

    private void nextToken() {
        int nStart;
        do {
            nStart = this.buffer.getIndex();
            this.skipWhiteSpaces();
            this.skipComment();
        } while (nStart < this.buffer.getIndex());
        if (this.buffer.peekChar() == '\u0000') {
            this.curToken.assign(Token.END, "", 0);
            return;
        }
        if (this.buffer.peekChar() == '\"') {
            String sText = "";
            this.buffer.getChar();
            while (this.buffer.peekChar() != '\"' && this.buffer.peekChar() != '\u0000') {
                sText = sText + this.buffer.getChar();
            }
            this.buffer.getChar();
            this.curToken.assign(Token.TEXT, this.i18n.convert(sText, false, "en"), 5);
            return;
        }
        if (this.buffer.peekChar() == '%') {
            this.buffer.getChar();
            String sIdent = this.buffer.getIdentifier();
            if (this.configSymbols.containsKey(sIdent)) {
                this.curToken.assign(Token.SPECIAL, this.configSymbols.get(sIdent), 5);
            } else if (!this.symbols.lookup(sIdent, false, this.curToken)) {
                this.curToken.assign(Token.IDENT, this.i18n.convert(sIdent, true, "en"), 5);
            }
        } else {
            if (Character.isLetter(this.buffer.peekChar())) {
                String sIdent = this.buffer.getIdentifier();
                if (!this.keywords.lookup(sIdent, true, this.curToken)) {
                    this.curToken.assign(Token.IDENT, this.i18n.convert(sIdent, true, "en"), 5);
                    this.curToken.bSingleChar = sIdent.length() == 1;
                }
                return;
            }
            if (CharClasses.isDigitOrDot(this.buffer.peekChar())) {
                String sNumber = this.buffer.getNumber();
                this.curToken.assign(Token.NUMBER, sNumber, 5);
                return;
            }
            char cChar = this.buffer.getChar();
            switch (cChar) {
                case '<': {
                    if (this.buffer.peekChar() == '<') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.LL, "\\ll ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '=') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.LE, "\\le ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '>') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.NEQ, "\\neq ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '?' && this.buffer.peekFollowingChar() == '>') {
                        this.buffer.getChar();
                        this.buffer.getChar();
                        this.curToken.assign(Token.PLACE, "\\Box ", TGroup.STANDALONE, 5);
                    } else {
                        this.curToken.assign(Token.LT, "<", TGroup.RELATION, 0);
                    }
                    return;
                }
                case '>': {
                    if (this.buffer.peekChar() == '>') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.GG, "\\gg ", TGroup.RELATION, 0);
                    } else if (this.buffer.peekChar() == '=') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.GE, "\\ge ", TGroup.RELATION, 0);
                    } else {
                        this.curToken.assign(Token.GT, ">", TGroup.RELATION, 0);
                    }
                    return;
                }
                case '[': {
                    this.curToken.assign(Token.LBRACKET, "[", TGroup.LBRACES, 5);
                    return;
                }
                case '\\': {
                    this.curToken.assign(Token.ESCAPE, "", 5);
                    return;
                }
                case ']': {
                    this.curToken.assign(Token.RBRACKET, "]", TGroup.RBRACES, 0);
                    return;
                }
                case '^': {
                    this.curToken.assign(Token.RSUP, "", TGroup.POWER, 0);
                    return;
                }
                case '_': {
                    this.curToken.assign(Token.RSUB, "", TGroup.POWER, 0);
                    return;
                }
                case '`': {
                    this.curToken.assign(Token.SBLANK, "\\;", TGroup.BLANK, 5);
                    return;
                }
                case '{': {
                    this.curToken.assign(Token.LGROUP, "{", 5);
                    return;
                }
                case '|': {
                    this.curToken.assign(Token.OR, "\\vee ", TGroup.SUM, 0);
                    return;
                }
                case '}': {
                    this.curToken.assign(Token.RGROUP, "}", 0);
                    return;
                }
                case '~': {
                    this.curToken.assign(Token.BLANK, "\\ ", TGroup.BLANK, 5);
                    return;
                }
                case '#': {
                    if (this.buffer.peekChar() == '#') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.DPOUND, "", 0);
                    } else {
                        this.curToken.assign(Token.POUND, "", 0);
                    }
                    return;
                }
                case '&': {
                    this.curToken.assign(Token.AND, "\\wedge ", TGroup.PRODUCT, 0);
                    return;
                }
                case '(': {
                    this.curToken.assign(Token.LPARENT, "(", TGroup.LBRACES, 5);
                    return;
                }
                case ')': {
                    this.curToken.assign(Token.RPARENT, ")", TGroup.RBRACES, 0);
                    return;
                }
                case '*': {
                    this.curToken.assign(Token.MULTIPLY, "\\ast ", TGroup.PRODUCT, 0);
                    return;
                }
                case '+': {
                    if (this.buffer.peekChar() == '-') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.PLUSMINUS, "\\pm ", TGroup.UNOPER, TGroup.SUM, 5);
                    } else {
                        this.curToken.assign(Token.PLUS, "+", TGroup.UNOPER, TGroup.SUM, 5);
                    }
                    return;
                }
                case '-': {
                    if (this.buffer.peekChar() == '+') {
                        this.buffer.getChar();
                        this.curToken.assign(Token.MINUSPLUS, "\\mp ", TGroup.UNOPER, TGroup.SUM, 5);
                    } else {
                        this.curToken.assign(Token.MINUS, "-", TGroup.UNOPER, TGroup.SUM, 5);
                    }
                    return;
                }
                case '/': {
                    this.curToken.assign(Token.DIVIDEBY, "/", TGroup.PRODUCT, 0);
                    return;
                }
                case '=': {
                    this.curToken.assign(Token.ASSIGN, "=", TGroup.RELATION, 0);
                    return;
                }
            }
            Character cCharObject = new Character(cChar);
            this.curToken.assign(Token.CHARACTER, this.i18n.convert(cCharObject.toString(), true, "en"), 5);
            return;
        }
    }

    private String table(float fSize, Token eAlign) {
        StringBuilder bufTable = new StringBuilder();
        String sLine = this.line(fSize, eAlign, true);
        if (this.curToken.eType == Token.NEWLINE) {
            bufTable.append("\\begin{gathered}").append(sLine);
            while (this.curToken.eType == Token.NEWLINE) {
                this.nextToken();
                bufTable.append("\\\\");
                sLine = this.line(fSize, eAlign, false);
                if (sLine.length() > 0 && sLine.charAt(0) == '[') {
                    bufTable.append("{}");
                }
                bufTable.append(sLine);
            }
            return bufTable.append("\\end{gathered}").toString();
        }
        return sLine;
    }

    private String align(float fSize, Token eAlign, boolean bUseAlignment, boolean bNeedNull) {
        if (this.tokenInGroup(TGroup.ALIGN)) {
            eAlign = this.curToken.eType;
            this.nextToken();
        }
        if (bUseAlignment && eAlign == Token.ALIGNL) {
            if (bNeedNull) {
                return this.expression(fSize, eAlign) + "\\hfill\\null ";
            }
            return this.expression(fSize, eAlign) + "\\hfill ";
        }
        if (bUseAlignment && eAlign == Token.ALIGNR) {
            return "\\hfill " + this.expression(fSize, eAlign);
        }
        return this.expression(fSize, eAlign);
    }

    private String line(float fSize, Token eAlign, boolean bFirstLine) {
        if (this.curToken.eType != Token.NEWLINE && this.curToken.eType != Token.END) {
            if (this.curToken.eType == Token.TEXT) {
                String sExpression = this.expression(fSize, eAlign);
                if (!bFirstLine || this.curToken.eType == Token.NEWLINE) {
                    return sExpression + "\\hfill ";
                }
                return sExpression;
            }
            return this.align(fSize, eAlign, true, false);
        }
        return "{}";
    }

    private String expression(float fSize, Token eAlign) {
        StringBuilder bufExpression = new StringBuilder().append(this.relation(fSize, eAlign));
        while (this.curToken.nLevel >= 5) {
            bufExpression.append(this.relation(fSize, eAlign));
        }
        return bufExpression.toString();
    }

    private String relation(float fSize, Token eAlign) {
        StringBuilder bufRelation = new StringBuilder().append(this.sum(fSize, eAlign));
        while (this.tokenInGroup(TGroup.RELATION)) {
            if (this.curToken.eType == Token.TRANSL) {
                this.bMultimapdotbothA = true;
            } else if (this.curToken.eType == Token.TRANSR) {
                this.bMultimapdotbothB = true;
            } else if (this.curToken.eType == Token.DEF) {
                this.bDefeq = true;
            }
            bufRelation.append(this.opsubsup(fSize, eAlign)).append(this.sum(fSize, eAlign));
        }
        return bufRelation.toString();
    }

    private String sum(float fSize, Token eAlign) {
        StringBuilder bufSum = new StringBuilder().append(this.product(fSize, eAlign));
        while (this.tokenInGroup(TGroup.SUM)) {
            bufSum.append(this.opsubsup(fSize, eAlign)).append(this.product(fSize, eAlign));
        }
        return bufSum.toString();
    }

    private String product(float fSize, Token eAlign) {
        String sProduct = this.power(fSize, eAlign);
        while (this.tokenInGroup(TGroup.PRODUCT)) {
            if (this.curToken.eType == Token.OVER) {
                this.nextToken();
                sProduct = "\\frac" + this.groupsp(sProduct) + this.groupsp(this.power(fSize, eAlign));
                continue;
            }
            if (this.curToken.eType == Token.BOPER) {
                this.nextToken();
                sProduct = sProduct + this.special() + this.power(fSize, eAlign);
                continue;
            }
            if (this.curToken.eType == Token.OVERBRACE) {
                this.nextToken();
                sProduct = "\\overbrace" + this.groupsp(sProduct) + "^" + this.group(this.power(fSize, eAlign));
                continue;
            }
            if (this.curToken.eType == Token.UNDERBRACE) {
                this.nextToken();
                sProduct = "\\underbrace" + this.groupsp(sProduct) + "_" + this.group(this.power(fSize, eAlign));
                continue;
            }
            if (this.curToken.eType == Token.WIDESLASH) {
                this.bWideslash = true;
                this.nextToken();
                sProduct = "\\wideslash" + this.groupsp(sProduct) + this.group(this.power(fSize, eAlign));
                continue;
            }
            if (this.curToken.eType == Token.WIDEBACKSLASH) {
                this.bWidebslash = true;
                this.nextToken();
                sProduct = "\\widebslash" + this.groupsp(sProduct) + this.group(this.power(fSize, eAlign));
                continue;
            }
            sProduct = sProduct + this.opsubsup(fSize, eAlign) + this.power(fSize, eAlign);
        }
        return sProduct;
    }

    private String tosub(String s) {
        return s != null ? "_" + this.group(s) : "";
    }

    private String tosup(String s) {
        return s != null ? "^" + this.group(s) : "";
    }

    private String subsup(float fSize, Token eAlign, String sBody, TGroup eActiveGroup) {
        String sLsub = null;
        String sLsup = null;
        String sCsub = null;
        String sCsup = null;
        String sRsub = null;
        String sRsup = null;
        while (this.tokenInGroup(eActiveGroup)) {
            Token eScriptType = this.curToken.eType;
            this.nextToken();
            if (eScriptType == Token.FROM) {
                sCsub = this.relation(fSize, eAlign);
                continue;
            }
            if (eScriptType == Token.TO) {
                sCsup = this.relation(fSize, eAlign);
                continue;
            }
            if (eScriptType == Token.LSUB) {
                sLsub = this.term(fSize, eAlign);
                continue;
            }
            if (eScriptType == Token.LSUP) {
                sLsup = this.term(fSize, eAlign);
                continue;
            }
            if (eScriptType == Token.CSUB) {
                sCsub = this.term(fSize, eAlign);
                continue;
            }
            if (eScriptType == Token.CSUP) {
                sCsup = this.term(fSize, eAlign);
                continue;
            }
            if (eScriptType == Token.RSUB) {
                sRsub = this.term(fSize, eAlign);
                continue;
            }
            if (eScriptType != Token.RSUP) continue;
            sRsup = this.term(fSize, eAlign);
        }
        if (sLsub == null && sLsup == null && sCsub == null && sCsup == null && sRsub == null && sRsup == null) {
            return sBody;
        }
        if (eActiveGroup == TGroup.LIMIT) {
            if (sLsub == null && sLsup == null && sRsub == null && sRsup == null) {
                return sBody + this.tosub(sCsub) + this.tosup(sCsup);
            }
            return "\\sideset{" + this.tosub(sLsub) + this.tosup(sLsup) + "}{" + this.tosub(sRsub) + this.tosup(sRsup) + "}" + sBody + "\\limits" + this.tosub(sCsub) + this.tosup(sCsup);
        }
        if (sLsub == null && sLsup == null && sCsub == null && sCsup == null) {
            return sBody + this.tosub(sRsub) + this.tosup(sRsup);
        }
        if (sLsub == null && sLsup == null && sRsub == null && sRsup == null) {
            if (sCsub == null) {
                return "\\overset" + this.groupsp(sCsup) + "{" + sBody + "}";
            }
            if (sCsup == null) {
                return "\\underset" + this.groupsp(sCsub) + "{" + sBody + "}";
            }
            return "\\overset" + this.groupsp(sCsup) + "{\\underset" + this.groupsp(sCsub) + "{" + sBody + "}}";
        }
        this.bMultiscripts = true;
        if (sCsub == null) {
            sCsub = "{}";
        }
        if (sCsup == null) {
            sCsup = "{}";
        }
        return "\\multiscripts{" + this.tosub(sLsub) + this.tosup(sLsup) + "}" + this.group(sCsub) + this.group(sCsup) + "{" + sBody + "}{" + this.tosub(sRsub) + this.tosup(sRsup) + "}";
    }

    private String opsubsup(float fSize, Token eAlign) {
        String sOperator = this.curToken.sLaTeX;
        this.nextToken();
        return this.subsup(fSize, eAlign, sOperator, TGroup.POWER);
    }

    private String power(float fSize, Token eAlign) {
        return this.subsup(fSize, eAlign, this.term(fSize, eAlign), TGroup.POWER);
    }

    private String blank() {
        StringBuilder bufBlank = new StringBuilder();
        while (this.tokenInGroup(TGroup.BLANK)) {
            bufBlank.append(this.curToken.sLaTeX);
            this.nextToken();
        }
        return bufBlank.toString();
    }

    private String term(float fSize, Token eAlign) {
        String sContent;
        if (this.curToken.eType == Token.ESCAPE) {
            return this.escape();
        }
        if (this.curToken.eType == Token.LGROUP) {
            this.nextToken();
            String sContent2 = this.curToken.eType != Token.RGROUP ? this.align(fSize, eAlign, false, false) : "";
            if (this.curToken.eType == Token.RGROUP) {
                this.nextToken();
            }
            return sContent2;
        }
        if (this.curToken.eType == Token.LEFT) {
            return this.scalebrace(fSize, eAlign);
        }
        if (this.tokenInGroup(TGroup.BLANK)) {
            return this.blank();
        }
        if (this.curToken.eType == Token.TEXT) {
            String sContent3 = this.curToken.sLaTeX;
            this.nextToken();
            if (!this.numberPattern.matcher(sContent3).matches()) {
                return "\\text" + this.groupsp(sContent3);
            }
            return sContent3;
        }
        if (this.curToken.eType == Token.CHARACTER || this.curToken.eType == Token.NUMBER || this.tokenInGroup(TGroup.STANDALONE)) {
            if (this.curToken.eType == Token.LAMBDABAR) {
                this.bLambdabar = true;
            }
            if (this.curToken.eType == Token.DOTSUP) {
                this.bDdotsup = true;
            }
            String sContent4 = this.curToken.sLaTeX;
            this.nextToken();
            return sContent4;
        }
        if (this.curToken.eType == Token.IDENT) {
            String sContent5 = this.curToken.sLaTeX;
            boolean bSingleChar = this.curToken.bSingleChar;
            this.nextToken();
            return bSingleChar ? sContent5 : "\\mathit{" + sContent5 + "}";
        }
        if (this.curToken.eType == Token.SPECIAL) {
            return this.special();
        }
        if (this.curToken.eType == Token.BINOM) {
            return this.binom(fSize, eAlign);
        }
        if (this.curToken.eType == Token.STACK) {
            return this.stack(fSize, eAlign);
        }
        if (this.curToken.eType == Token.MATRIX) {
            return this.matrix(fSize, eAlign);
        }
        if (this.tokenInGroup(TGroup.LBRACES)) {
            return this.brace(fSize, eAlign);
        }
        if (this.tokenInGroup(TGroup.OPER)) {
            return this.operator(fSize, eAlign);
        }
        if (this.tokenInGroup(TGroup.UNOPER)) {
            return this.unoper(fSize, eAlign);
        }
        if (this.tokenInGroup(TGroup.ATTRIBUT) || this.tokenInGroup(TGroup.FONTATTR)) {
            return this.attributes(fSize, eAlign);
        }
        if (this.tokenInGroup(TGroup.FUNCTION)) {
            return this.function();
        }
        if (this.tokenInGroup(TGroup.RELATION) || this.tokenInGroup(TGroup.SUM) || this.tokenInGroup(TGroup.PRODUCT)) {
            sContent = this.curToken.sLaTeX;
            if (sContent.length() == 0) {
                sContent = "?";
            }
        } else {
            sContent = "?";
        }
        this.nextToken();
        return sContent;
    }

    private String escape() {
        String sEscape;
        this.nextToken();
        if ((this.tokenInGroup(TGroup.LBRACES) || this.tokenInGroup(TGroup.RBRACES)) && this.curToken.eType != Token.NONE) {
            sEscape = this.curToken.sLaTeX;
            this.nextToken();
        } else if (this.curToken.eType == Token.LGROUP) {
            sEscape = "\\{";
            this.nextToken();
        } else if (this.curToken.eType == Token.RGROUP) {
            sEscape = "\\}";
            this.nextToken();
        } else {
            sEscape = "";
        }
        return sEscape;
    }

    private String operator(float fSize, Token eAlign) {
        String sOperator = this.oper();
        if (this.tokenInGroup(TGroup.LIMIT) || this.tokenInGroup(TGroup.POWER)) {
            return this.subsup(fSize, eAlign, sOperator, this.curToken.eGroup1) + this.power(fSize, eAlign);
        }
        return sOperator + this.power(fSize, eAlign);
    }

    private String oper() {
        String sOper;
        if (this.curToken.eType == Token.LLINT) {
            this.bOiint = true;
        } else if (this.curToken.eType == Token.LLLINT) {
            this.bOiiint = true;
        }
        if (this.curToken.eType == Token.OPER) {
            this.nextToken();
            sOper = this.curToken.eType == Token.SPECIAL ? "\\operatornamewithlimits{" + this.curToken.sLaTeX + "}" : "\\operatornamewithlimits{?}";
        } else {
            sOper = this.curToken.sLaTeX;
        }
        this.nextToken();
        return sOper;
    }

    private String unoper(float fSize, Token eAlign) {
        if (this.curToken.eType == Token.ABS) {
            this.nextToken();
            return "\\left|" + this.power(fSize, eAlign) + "\\right|";
        }
        if (this.curToken.eType == Token.SQRT) {
            this.nextToken();
            return "\\sqrt" + this.groupsp(this.power(fSize, eAlign));
        }
        if (this.curToken.eType == Token.NROOT) {
            this.nextToken();
            return "\\sqrt[" + this.power(fSize, eAlign) + "]" + this.group(this.power(fSize, eAlign));
        }
        if (this.curToken.eType == Token.UOPER) {
            this.nextToken();
            return this.special() + this.power(fSize, eAlign);
        }
        if (this.curToken.eType == Token.FACT) {
            String sOperator = this.opsubsup(fSize, eAlign);
            return this.power(fSize, eAlign) + sOperator;
        }
        return this.opsubsup(fSize, eAlign) + this.power(fSize, eAlign);
    }

    private String attributes(float fSize, Token eAlign) {
        if (this.curToken.eType == Token.FONT) {
            this.nextToken();
            if (this.tokenInGroup(TGroup.FONT)) {
                String sAttribute = this.curToken.sLaTeX;
                this.nextToken();
                return sAttribute + this.groupsp(this.term(fSize, eAlign));
            }
            return "?";
        }
        if (this.curToken.eType == Token.COLOR) {
            this.nextToken();
            if (this.tokenInGroup(TGroup.COLOR)) {
                Token tokenType = this.curToken.eType;
                String sAttribute = this.curToken.sLaTeX;
                this.nextToken();
                if (this.bUseColor) {
                    if (this.config.oldMathColors()) {
                        if (tokenType == Token.RED) {
                            sAttribute = "\\textcolor[rgb]{0.5,0,0}";
                        }
                        if (tokenType == Token.BLUE) {
                            sAttribute = "\\textcolor[rgb]{0,0,0.5}";
                        }
                        if (tokenType == Token.CYAN) {
                            sAttribute = "\\textcolor[rgb]{0,0.5,0.5}";
                        }
                        if (tokenType == Token.MAGENTA) {
                            sAttribute = "\\textcolor[rgb]{0.5,0,0.5}";
                        }
                    }
                    return sAttribute + this.group(this.term(fSize, eAlign));
                }
                return this.term(fSize, eAlign);
            }
            return "?";
        }
        if (this.curToken.eType == Token.SIZE) {
            this.nextToken();
            if (this.curToken.eType == Token.PLUS) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    fSize += Calc.getFloat(this.curToken.sLaTeX, 0.0f);
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.MINUS) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    fSize -= Calc.getFloat(this.curToken.sLaTeX, 0.0f);
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.MULTIPLY) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    fSize *= Calc.getFloat(this.curToken.sLaTeX, 1.0f);
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.DIVIDEBY) {
                this.nextToken();
                if (this.curToken.eType == Token.NUMBER) {
                    float f = Calc.getFloat(this.curToken.sLaTeX, 1.0f);
                    if (f != 0.0f) {
                        fSize /= f;
                    }
                    this.nextToken();
                }
            } else if (this.curToken.eType == Token.NUMBER) {
                fSize = Calc.getFloat(this.curToken.sLaTeX, fSize);
                this.nextToken();
            }
            return this.term(fSize, eAlign);
        }
        if (this.curToken.eType == Token.OVERSTRIKE) {
            this.bMathoverstrike = true;
        } else if (this.curToken.eType == Token.BOLD) {
            this.bBoldsubformula = true;
        } else if (this.curToken.eType == Token.NBOLD) {
            this.bNormalsubformula = true;
        } else if (this.curToken.eType == Token.ITALIC) {
            this.bNormalsubformula = true;
        }
        String sAttribute = this.curToken.sLaTeX;
        this.nextToken();
        return sAttribute + this.groupsp(this.term(fSize, eAlign));
    }

    private String scalebrace(float fSize, Token eAlign) {
        this.nextToken();
        if (this.tokenInGroup(TGroup.LBRACES) || this.tokenInGroup(TGroup.RBRACES)) {
            String sRight;
            if (this.curToken.eType == Token.LDBRACKET) {
                this.bLlbracket = true;
            } else if (this.curToken.eType == Token.RDBRACKET) {
                this.bRrbracket = true;
            }
            String sLeft = new String(this.curToken.sLaTeX);
            this.nextToken();
            String sBody = this.scalebracebody(fSize, eAlign);
            if (this.curToken.eType == Token.RIGHT) {
                this.nextToken();
                if (this.tokenInGroup(TGroup.LBRACES) || this.tokenInGroup(TGroup.RBRACES)) {
                    if (this.curToken.eType == Token.LDBRACKET) {
                        this.bLlbracket = true;
                    } else if (this.curToken.eType == Token.RDBRACKET) {
                        this.bRrbracket = true;
                    }
                    sRight = new String(this.curToken.sLaTeX);
                    this.nextToken();
                } else {
                    sRight = ".";
                }
            } else {
                return ".";
            }
            return "\\left" + sLeft + sBody + "\\right" + sRight;
        }
        return "?";
    }

    private String brace(float fSize, Token eAlign) {
        if (this.curToken.eType == Token.LDBRACKET) {
            this.bLlbracket = true;
        }
        String sLeft = new String(this.curToken.sLaTeX);
        this.nextToken();
        String sBody = this.bracebody(fSize, eAlign);
        if (this.tokenInGroup(TGroup.RBRACES)) {
            if (this.curToken.eType == Token.RDBRACKET) {
                this.bRrbracket = true;
            }
            String sRight = new String(this.curToken.sLaTeX);
            this.nextToken();
            return sLeft + sBody + sRight;
        }
        return sLeft + sBody;
    }

    private String scalebracebody(float fSize, Token eAlign) {
        if (this.curToken.eType == Token.MLINE) {
            this.nextToken();
            return "\\left|" + this.scalebracebody(fSize, eAlign) + "\\right.";
        }
        if (this.curToken.eType != Token.RIGHT && this.curToken.eType != Token.END) {
            return this.align(fSize, eAlign, false, false) + this.scalebracebody(fSize, eAlign);
        }
        return "";
    }

    private String bracebody(float fSize, Token eAlign) {
        if (this.curToken.eType == Token.MLINE) {
            this.nextToken();
            return "|" + this.bracebody(fSize, eAlign);
        }
        if (!this.tokenInGroup(TGroup.RBRACES) && this.curToken.eType != Token.END) {
            return this.align(fSize, eAlign, false, false) + this.bracebody(fSize, eAlign);
        }
        return "";
    }

    private String function() {
        String sFunction;
        if (this.curToken.eType == Token.FUNC) {
            this.nextToken();
            if (this.curToken.eType == Token.IDENT) {
                sFunction = "\\operatorname{" + this.curToken.sLaTeX + "}";
                this.nextToken();
            } else {
                sFunction = "";
            }
        } else {
            sFunction = this.curToken.sLaTeX;
            this.nextToken();
        }
        return sFunction;
    }

    private String binom(float fSize, Token eAlign) {
        this.nextToken();
        return "\\genfrac{}{}{0pt}{0}" + this.group(this.sum(fSize, eAlign)) + this.group(this.sum(fSize, eAlign));
    }

    private String stack(float fSize, Token eAlign) {
        this.nextToken();
        if (this.curToken.eType == Token.LGROUP) {
            StringBuilder bufStack = new StringBuilder().append("\\begin{matrix}");
            this.nextToken();
            bufStack.append(this.align(fSize, eAlign, true, true));
            while (this.curToken.eType == Token.POUND) {
                bufStack.append("\\\\");
                this.nextToken();
                String sAlign = this.align(fSize, eAlign, true, true);
                if (sAlign.length() > 0 && sAlign.charAt(0) == '[') {
                    bufStack.append("{}");
                }
                bufStack.append(sAlign);
            }
            if (this.curToken.eType == Token.RGROUP) {
                this.nextToken();
            }
            return bufStack.append("\\end{matrix}").toString();
        }
        return "";
    }

    private String matrix(float fSize, Token eAlign) {
        this.nextToken();
        if (this.curToken.eType == Token.LGROUP) {
            StringBuilder bufMatrix = new StringBuilder().append("\\begin{matrix}");
            int nCols = 1;
            boolean bProtect = false;
            do {
                this.nextToken();
                String sAlign = this.align(fSize, eAlign, true, true);
                if (bProtect && sAlign.length() > 0 && sAlign.charAt(0) == '[') {
                    bufMatrix.append("{}");
                }
                bufMatrix.append(sAlign);
                if (this.curToken.eType == Token.POUND) {
                    bufMatrix.append("&");
                    ++nCols;
                    bProtect = false;
                    continue;
                }
                if (this.curToken.eType != Token.DPOUND) continue;
                bufMatrix.append("\\\\");
                this.nMaxMatrixCols = Math.max(nCols, this.nMaxMatrixCols);
                nCols = 1;
                bProtect = true;
            } while (this.curToken.eType == Token.POUND || this.curToken.eType == Token.DPOUND);
            if (this.curToken.eType == Token.RGROUP) {
                this.nextToken();
            }
            this.nMaxMatrixCols = Math.max(nCols, this.nMaxMatrixCols);
            return bufMatrix.append("\\end{matrix}").toString();
        }
        return "";
    }

    private String special() {
        String sSpecial = this.curToken.sLaTeX;
        this.nextToken();
        return sSpecial;
    }

    private String group(String sLaTeX) {
        if (sLaTeX.length() != 1) {
            return "{" + sLaTeX + "}";
        }
        return sLaTeX;
    }

    private String groupsp(String sLaTeX) {
        if (sLaTeX.length() != 1 || sLaTeX.charAt(0) == ' ') {
            return "{" + sLaTeX + "}";
        }
        return " " + sLaTeX;
    }

    @Override
    public String convert(String sStarMath) {
        String sExport = "";
        this.buffer = new SimpleInputBuffer(sStarMath);
        this.nextToken();
        sExport = this.table(12.0f, Token.ALIGNC);
        return sExport.length() == 0 ? " " : sExport;
    }
}

