/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.tools.ant.BuildException;

public class IvyBuildNumber
extends IvyTask {
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private String revSep = ".";
    private String prefix = "ivy.";
    private String defaultValue = "0";
    private String defaultBuildNumber = "0";
    private String resolver = null;

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String string) {
        this.defaultValue = string;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String string) {
        this.resolver = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public void doExecute() throws BuildException {
        ArtifactInfo[] artifactInfoArray;
        ModuleRevisionId[] moduleRevisionIdArray;
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy buildnumber task");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy buildnumber task");
        }
        if (this.prefix == null) {
            throw new BuildException("null prefix not allowed");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        if (this.branch == null) {
            this.branch = ivySettings.getDefaultBranch(new ModuleId(this.organisation, this.module));
        }
        if (this.revision == null || this.revision.length() == 0) {
            this.revision = "latest.integration";
        } else if (!this.revision.endsWith("+")) {
            this.revision = this.revision + "+";
        }
        if (!this.prefix.endsWith(".") && this.prefix.length() > 0) {
            this.prefix = this.prefix + ".";
        }
        SearchEngine searchEngine = new SearchEngine(ivySettings);
        PatternMatcher patternMatcher = new PatternMatcher(){
            private PatternMatcher exact = new ExactPatternMatcher();
            private PatternMatcher regexp = new ExactOrRegexpPatternMatcher();

            @Override
            public Matcher getMatcher(String string) {
                if (string.equals(IvyBuildNumber.this.organisation) || string.equals(IvyBuildNumber.this.module) || string.equals(IvyBuildNumber.this.branch)) {
                    return this.exact.getMatcher(string);
                }
                return this.regexp.getMatcher(string);
            }

            @Override
            public String getName() {
                return "buildnumber-matcher";
            }
        };
        if (this.resolver == null) {
            moduleRevisionIdArray = searchEngine.listModules(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, ".*"), patternMatcher);
        } else {
            artifactInfoArray = ivySettings.getResolver(this.resolver);
            if (artifactInfoArray == null) {
                throw new BuildException("Unknown resolver: " + this.resolver);
            }
            moduleRevisionIdArray = searchEngine.listModules((DependencyResolver)artifactInfoArray, ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, ".*"), patternMatcher);
        }
        artifactInfoArray = new ArtifactInfo[moduleRevisionIdArray.length];
        for (int i = 0; i < moduleRevisionIdArray.length; ++i) {
            artifactInfoArray[i] = new ResolvedModuleRevisionArtifactInfo(moduleRevisionIdArray[i]);
        }
        VersionMatcher versionMatcher = ivySettings.getVersionMatcher();
        LatestStrategy latestStrategy = ivySettings.getLatestStrategy("latest-revision");
        List list = latestStrategy.sort(artifactInfoArray);
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision);
        String string = null;
        Object object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            ResolvedModuleRevisionArtifactInfo resolvedModuleRevisionArtifactInfo = (ResolvedModuleRevisionArtifactInfo)object.previous();
            if (!versionMatcher.accept(moduleRevisionId, resolvedModuleRevisionArtifactInfo.rmr)) continue;
            if (versionMatcher.needModuleDescriptor(moduleRevisionId, resolvedModuleRevisionArtifactInfo.rmr)) {
                ResolvedModuleRevision resolvedModuleRevision = ivy.findModule(resolvedModuleRevisionArtifactInfo.rmr);
                if (versionMatcher.accept(moduleRevisionId, resolvedModuleRevision.getDescriptor())) {
                    string = resolvedModuleRevisionArtifactInfo.rmr.getRevision();
                }
            } else {
                string = resolvedModuleRevisionArtifactInfo.rmr.getRevision();
            }
            if (string == null) continue;
            break;
        }
        object = this.computeNewRevision(string);
        this.setProperty("revision", ((NewRevision)object).getRevision());
        this.setProperty("new.revision", ((NewRevision)object).getNewRevision());
        this.setProperty("build.number", ((NewRevision)object).getBuildNumber());
        this.setProperty("new.build.number", ((NewRevision)object).getNewBuildNumber());
    }

    private void setProperty(String string, String string2) {
        if (string2 != null) {
            this.getProject().setProperty(this.prefix + string, string2);
        }
    }

    private NewRevision computeNewRevision(String string) {
        Range range;
        String string2;
        String string3 = string2 = "latest.integration".equals(this.revision) ? "" : this.revision.substring(0, this.revision.length() - 1);
        if (string != null && !string.startsWith(string2)) {
            throw new BuildException("invalid exception found in repository: '" + string + "' for '" + string2 + "'");
        }
        if (string == null) {
            if (string2.length() > 0) {
                return new NewRevision(string, string2 + (string2.endsWith(this.revSep) ? this.defaultBuildNumber : this.revSep + this.defaultBuildNumber), null, this.defaultBuildNumber);
            }
            Range range2 = this.findLastNumber(this.defaultValue);
            if (range2 == null) {
                return new NewRevision(string, this.defaultValue, null, null);
            }
            long l = Long.parseLong(this.defaultValue.substring(range2.getStartIndex(), range2.getEndIndex()));
            return new NewRevision(string, this.defaultValue, null, String.valueOf(l));
        }
        if (string2.length() == 0) {
            range = this.findLastNumber(string);
            if (range == null) {
                return new NewRevision(string, string + (string.endsWith(this.revSep) ? "1" : this.revSep + "1"), null, "1");
            }
        } else {
            range = this.findFirstNumber(string, string2.length());
            if (range == null) {
                return new NewRevision(string, string2 + (string2.endsWith(this.revSep) ? "1" : this.revSep + "1"), null, "1");
            }
        }
        long l = Long.parseLong(string.substring(range.getStartIndex(), range.getEndIndex())) + 1L;
        return new NewRevision(string, string.substring(0, range.getStartIndex()) + l, String.valueOf(l - 1L), String.valueOf(l));
    }

    private Range findFirstNumber(String string, int n) {
        int n2;
        int n3;
        for (n3 = n; n3 < string.length() && !Character.isDigit(string.charAt(n3)); ++n3) {
        }
        if (n3 == string.length()) {
            return null;
        }
        for (n2 = n3 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
        }
        return new Range(n3, n2);
    }

    private Range findLastNumber(String string) {
        int n;
        int n2;
        for (n2 = string.length() - 1; n2 >= 0 && !Character.isDigit(string.charAt(n2)); --n2) {
        }
        int n3 = n = n2 == -1 ? -1 : n2 - 1;
        while (n >= 0 && Character.isDigit(string.charAt(n))) {
            --n;
        }
        if (++n == ++n2) {
            return null;
        }
        return new Range(n, n2);
    }

    public String getRevSep() {
        return this.revSep;
    }

    public void setRevSep(String string) {
        this.revSep = string;
    }

    public String getDefaultBuildNumber() {
        return this.defaultBuildNumber;
    }

    public void setDefaultBuildNumber(String string) {
        this.defaultBuildNumber = string;
    }

    private static class NewRevision {
        private String revision;
        private String newRevision;
        private String buildNumber;
        private String newBuildNumber;

        public NewRevision(String string, String string2, String string3, String string4) {
            this.revision = string;
            this.newRevision = string2;
            this.buildNumber = string3;
            this.newBuildNumber = string4;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getNewRevision() {
            return this.newRevision;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getNewBuildNumber() {
            return this.newBuildNumber;
        }
    }

    private static class Range {
        private int startIndex;
        private int endIndex;

        public Range(int n, int n2) {
            this.startIndex = n;
            this.endIndex = n2;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ModuleRevisionId rmr;

        public ResolvedModuleRevisionArtifactInfo(ModuleRevisionId moduleRevisionId) {
            this.rmr = moduleRevisionId;
        }

        @Override
        public String getRevision() {
            return this.rmr.getRevision();
        }

        @Override
        public long getLastModified() {
            return -1L;
        }
    }
}

