/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionI;
import Ice.ConnectionTimeoutException;
import Ice.Exception;
import Ice.Holder;
import Ice.InvocationTimeoutException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice.OutputStream;
import IceInternal.CallbackBase;
import IceInternal.CancellationHandler;
import IceInternal.CollocatedRequestHandler;
import IceInternal.OutgoingAsyncBase;
import IceInternal.RequestHandler;
import IceInternal.RetryException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class ProxyOutgoingAsyncBase
extends OutgoingAsyncBase {
    protected final ObjectPrxHelperBase _proxy;
    protected RequestHandler _handler;
    protected OperationMode _mode;
    private Future<?> _future;
    private int _cnt;
    private boolean _sent;

    public static ProxyOutgoingAsyncBase check(AsyncResult r, ObjectPrx prx, String operation) {
        ProxyOutgoingAsyncBase.checkImpl(r, prx, operation);
        try {
            return (ProxyOutgoingAsyncBase)r;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + operation + " method");
        }
    }

    public abstract int invokeRemote(ConnectionI var1, boolean var2, boolean var3) throws RetryException;

    public abstract int invokeCollocated(CollocatedRequestHandler var1);

    @Override
    public ObjectPrx getProxy() {
        return this._proxy;
    }

    @Override
    public boolean completed(Exception exc) {
        if (this._childObserver != null) {
            this._childObserver.failed(exc.ice_id());
            this._childObserver.detach();
            this._childObserver = null;
        }
        try {
            this._instance.retryQueue().add(this, this.handleException(exc));
            return false;
        }
        catch (Exception ex) {
            return this.finished(ex);
        }
    }

    public void retryException(Exception ex) {
        block2: {
            try {
                this._proxy._updateRequestHandler(this._handler, null);
                this._instance.retryQueue().add(this, 0);
            }
            catch (Exception exc) {
                if (!this.completed(exc)) break block2;
                this.invokeCompletedAsync();
            }
        }
    }

    public void retry() {
        this.invokeImpl(false);
    }

    @Override
    public void cancelable(CancellationHandler handler) {
        int timeout;
        if (this._proxy._getReference().getInvocationTimeout() == -2 && this._cachedConnection != null && (timeout = this._cachedConnection.timeout()) > 0) {
            this._future = this._instance.timer().schedule(new Runnable(){

                @Override
                public void run() {
                    ProxyOutgoingAsyncBase.this.cancel(new ConnectionTimeoutException());
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        super.cancelable(handler);
    }

    public void abort(Exception ex) {
        assert (this._childObserver == null);
        if (this.finished(ex)) {
            this.invokeCompletedAsync();
        } else if (ex instanceof CommunicatorDestroyedException) {
            throw ex;
        }
    }

    protected ProxyOutgoingAsyncBase(ObjectPrxHelperBase prx, String op, CallbackBase delegate) {
        super(prx.ice_getCommunicator(), prx._getReference().getInstance(), op, delegate);
        this._proxy = prx;
        this._mode = OperationMode.Normal;
        this._cnt = 0;
        this._sent = false;
    }

    protected ProxyOutgoingAsyncBase(ObjectPrxHelperBase prx, String op, CallbackBase delegate, OutputStream os) {
        super(prx.ice_getCommunicator(), prx._getReference().getInstance(), op, delegate, os);
        this._proxy = prx;
        this._mode = OperationMode.Normal;
        this._cnt = 0;
        this._sent = false;
    }

    protected static AsyncResult checkImpl(AsyncResult r, ObjectPrx p, String operation) {
        ProxyOutgoingAsyncBase.check(r, operation);
        if (r.getProxy() != p) {
            throw new IllegalArgumentException("Proxy for call to end_" + operation + " does not match proxy that was used to call corresponding begin_" + operation + " method");
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    protected void invokeImpl(boolean userThread) {
        try {
            if (userThread) {
                invocationTimeout = this._proxy._getReference().getInvocationTimeout();
                if (invocationTimeout > 0) {
                    this._future = this._instance.timer().schedule(new Runnable(){

                        @Override
                        public void run() {
                            ProxyOutgoingAsyncBase.this.cancel(new InvocationTimeoutException());
                        }
                    }, (long)invocationTimeout, TimeUnit.MILLISECONDS);
                }
            } else if (this._observer != null) {
                this._observer.retried();
            }
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    this._sent = false;
                    this._handler = null;
                    this._handler = this._proxy._getRequestHandler();
                    status = this._handler.sendAsyncRequest(this);
                    if ((status & 1) > 0) {
                        if (userThread) {
                            this._sentSynchronously = true;
                            if ((status & 2) > 0) {
                                this.invokeSent();
                            }
                        } else if ((status & 2) > 0) {
                            this.invokeSentAsync();
                        }
                    }
                    return;
                }
                catch (RetryException ex) {
                    this._proxy._updateRequestHandler(this._handler, null);
                }
                catch (Exception ex) {
                    if (this._childObserver != null) {
                        this._childObserver.failed(ex.ice_id());
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    if ((interval = this.handleException(ex)) > 0) {
                        this._instance.retryQueue().add(this, interval);
                        return;
                    }
                    if (this._observer == null) ** GOTO lbl-1000
                    this._observer.retried();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            if (userThread) {
                throw ex;
            }
            if (this.finished(ex)) {
                this.invokeCompletedAsync();
            }
            return;
        }
        ** GOTO lbl-1000
    }

    @Override
    protected boolean sent(boolean done) {
        this._sent = true;
        if (done && this._future != null) {
            this._future.cancel(false);
            this._future = null;
        }
        return super.sent(done);
    }

    @Override
    protected boolean finished(Exception ex) {
        if (this._future != null) {
            this._future.cancel(false);
            this._future = null;
        }
        return super.finished(ex);
    }

    @Override
    protected boolean finished(boolean ok, boolean invoke) {
        if (this._future != null) {
            this._future.cancel(false);
            this._future = null;
        }
        return super.finished(ok, invoke);
    }

    protected int handleException(Exception exc) {
        Holder<Integer> interval = new Holder<Integer>();
        this._cnt = this._proxy._handleException(exc, this._handler, this._mode, this._sent, interval, this._cnt);
        return (Integer)interval.value;
    }
}

