/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.results.ColoredFilter;
import org.netbeans.lib.profiler.ui.results.PackageColorer;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.impl.Bundle;

public abstract class FilterSelector {
    public void show(Component component, FilterName filterName, String string) {
        UI uI = new UI(filterName, string);
        uI.show(component);
    }

    protected abstract void filterChanged(FilterName var1, String var2);

    private static Component createStrut(JComponent jComponent, int n, boolean bl) {
        Insets insets;
        Border border = jComponent.getBorder();
        Insets insets2 = insets = border != null ? border.getBorderInsets(jComponent) : null;
        int n2 = insets == null ? n : Math.max(n - (bl ? insets.left : insets.right), 0);
        return Box.createHorizontalStrut(n2);
    }

    private class UI {
        private JRadioButton noFilterChoice;
        private JRadioButton javaClassesChoice;
        private JRadioButton excludeCustomChoice;
        private JRadioButton includeCustomChoice;
        private TextArea customClasses;
        private PopupButton insertFilter;
        private JPanel panel;

        UI(FilterName filterName, String string) {
            this.populatePopup(filterName, string);
        }

        void show(Component component) {
            int n = 6;
            ProfilerPopup.createRelative((Component)component, (Component)this.panel, (int)4, (int)n).show();
        }

        private void populatePopup(FilterName filterName, String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(Bundle.FilterSelector_outgoingCalls(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
            jPanel.add((Component)jLabel, "North");
            ButtonGroup buttonGroup = new ButtonGroup(){

                @Override
                public void setSelected(ButtonModel buttonModel, boolean bl) {
                    super.setSelected(buttonModel, bl);
                    if (bl && buttonModel.isSelected()) {
                        UI.this.filterChanged(true);
                    }
                }
            };
            JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
            this.noFilterChoice = new JRadioButton(Bundle.FilterSelector_noFilter(), FilterName.NO_FILTER.equals((Object)filterName));
            buttonGroup.add(this.noFilterChoice);
            JPanel jPanel3 = new JPanel(null);
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            jPanel3.add(this.noFilterChoice);
            jPanel2.add(jPanel3);
            this.javaClassesChoice = new JRadioButton(Bundle.FilterSelector_excludeCoreJava(), FilterName.EXCLUDE_JAVA_FILTER.equals((Object)filterName));
            buttonGroup.add(this.javaClassesChoice);
            JLabel jLabel2 = new JLabel("(java.*, javax.*, sun.*, com.sun.*, etc.)", 10);
            jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getSize2D() - 1.0f));
            jLabel2.setEnabled(false);
            JPanel jPanel4 = new JPanel(null);
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            jPanel4.add(this.javaClassesChoice);
            jPanel4.add(FilterSelector.createStrut(this.javaClassesChoice, 5, false));
            jPanel4.add(jLabel2);
            jPanel2.add(jPanel4);
            this.excludeCustomChoice = new JRadioButton(Bundle.FilterSelector_excludeCustomEx(), FilterName.EXCLUDE_CUSTOM_FILTER.equals((Object)filterName));
            buttonGroup.add(this.excludeCustomChoice);
            this.includeCustomChoice = new JRadioButton(Bundle.FilterSelector_includeCustomEx(), FilterName.INCLUDE_CUSTOM_FILTER.equals((Object)filterName));
            buttonGroup.add(this.includeCustomChoice);
            JPanel jPanel5 = new JPanel(null);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jPanel5.add(this.excludeCustomChoice);
            jPanel5.add(FilterSelector.createStrut(this.excludeCustomChoice, 8, false));
            jPanel5.add(this.includeCustomChoice);
            jPanel2.add(jPanel5);
            if (PackageColorer.hasRegisteredColors()) {
                this.insertFilter = new PopupButton(Icons.getIcon((String)"GeneralIcons.Filter")){
                    {
                        this.setToolTipText(Bundle.FilterSelector_insertFilter());
                    }

                    protected void populatePopup(JPopupMenu jPopupMenu) {
                        for (final ColoredFilter coloredFilter : PackageColorer.getRegisteredColors()) {
                            if (coloredFilter.getValue().trim().isEmpty()) continue;
                            Icon icon = coloredFilter.getColor() == null ? null : coloredFilter.getIcon(12, 12);
                            jPopupMenu.add(new JMenuItem(coloredFilter.getName(), icon){

                                @Override
                                protected void fireActionPerformed(ActionEvent actionEvent) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    Object object = coloredFilter.getValues();
                                    int n = ((String[])object).length;
                                    for (int i = 0; i < n; ++i) {
                                        String string = object[i];
                                        if (stringBuilder.length() > 0) {
                                            stringBuilder.append(", ");
                                        }
                                        stringBuilder.append(string);
                                        if (!string.endsWith(".")) continue;
                                        stringBuilder.append("**");
                                    }
                                    Object object2 = object = UI.this.customClasses.showsHint() ? "" : UI.this.customClasses.getText();
                                    if (!((String)object).isEmpty()) {
                                        object = (String)object + "\n";
                                    }
                                    object = (String)object + stringBuilder.toString();
                                    UI.this.customClasses.requestFocusInWindow();
                                    UI.this.customClasses.setText((String)object);
                                }
                            });
                        }
                    }

                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        dimension.width -= 2;
                        dimension.height -= 2;
                        return dimension;
                    }
                };
                jPanel5.add(Box.createHorizontalGlue());
                jPanel5.add((Component)this.insertFilter);
            }
            JPanel jPanel6 = new JPanel(new GridBagLayout());
            int n = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 0, 0, 0);
            jPanel6.add((Component)jPanel2, gridBagConstraints);
            this.customClasses = new TextArea(){

                protected void changed() {
                    UI.this.filterChanged(true);
                }

                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    Container container = this.getParent().getParent();
                    return SwingUtilities.convertPoint(container, 0, container.getHeight(), (Component)((Object)this));
                }

                public void setEnabled(boolean bl) {
                    super.setEnabled(bl);
                    if (UI.this.insertFilter != null) {
                        UI.this.insertFilter.setEnabled(bl);
                    }
                }
            };
            this.customClasses.setFont(new Font("Monospaced", 0, this.customClasses.getFont().getSize()));
            this.customClasses.setRows(0);
            this.customClasses.setColumns(0);
            JScrollPane jScrollPane = new JScrollPane((Component)this.customClasses);
            Dimension dimension = jScrollPane.getPreferredSize();
            this.customClasses.setRows(3);
            this.customClasses.setColumns(56);
            Dimension dimension2 = this.customClasses.getPreferredScrollableViewportSize();
            dimension.width += dimension2.width;
            dimension.height += dimension2.height;
            jScrollPane.setPreferredSize(dimension);
            jScrollPane.setMinimumSize(dimension);
            this.customClasses.setText(string);
            this.customClasses.setHint(Bundle.FilterSelector_filterHint());
            this.customClasses.setToolTipText(Bundle.FilterSelector_filterTooltip());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(3, 20, 0, 0);
            jPanel6.add((Component)jScrollPane, gridBagConstraints);
            this.filterChanged(false);
            jPanel.add((Component)jPanel6, "Center");
            this.panel = jPanel;
        }

        private void filterChanged(boolean bl) {
            String string;
            this.customClasses.setEnabled(this.excludeCustomChoice.isSelected() || this.includeCustomChoice.isSelected());
            if (!bl) {
                return;
            }
            String string2 = string = this.customClasses.showsHint() ? "" : this.customClasses.getText().trim();
            if (this.noFilterChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.NO_FILTER, string);
            } else if (this.javaClassesChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.EXCLUDE_JAVA_FILTER, string);
            } else if (this.excludeCustomChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.EXCLUDE_CUSTOM_FILTER, string);
            } else if (this.includeCustomChoice.isSelected()) {
                FilterSelector.this.filterChanged(FilterName.INCLUDE_CUSTOM_FILTER, string);
            }
        }
    }

    public static enum FilterName {
        NO_FILTER,
        EXCLUDE_JAVA_FILTER,
        EXCLUDE_CUSTOM_FILTER,
        INCLUDE_CUSTOM_FILTER;


        public String toString() {
            switch (this) {
                case NO_FILTER: {
                    return Bundle.FilterSelector_noFilter();
                }
                case EXCLUDE_JAVA_FILTER: {
                    return Bundle.FilterSelector_excludeCoreJava();
                }
                case EXCLUDE_CUSTOM_FILTER: {
                    return Bundle.FilterSelector_excludeCustom();
                }
                case INCLUDE_CUSTOM_FILTER: {
                    return Bundle.FilterSelector_includeCustom();
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

