/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.Stack;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;

public abstract class Injector
extends SingleMethodScaner {
    private static final int MAX_SHORT = Short.MAX_VALUE;
    private static final int MIN_SHORT = Short.MIN_VALUE;
    private static final int STACK_INCREMENT = 2;
    private static Stack changes = new Stack();
    private static byte[] _overwrite = new byte[3];
    private static byte[] reusableExcTable = new byte[100];
    private static final byte[] injProfilePointHitCode = new byte[]{17, 0, 0, -72, 0, 0, 0, 0};
    private static final int injProfilePointHitIDCodeIdx = 1;
    private static final int injProfilePointHitMethodIdx = 4;
    protected byte[] exceptionTable;
    protected int baseCPoolCount;
    protected int excTableEntryCount;
    protected int maxLocals;
    protected int maxStack;
    protected int origBytecodesLength;
    protected int origExcTableEntryCount;
    private boolean changeTypeIsInjectNewInstr;
    private boolean injectionBindsToFollowingInstruction;
    private boolean classChecked;

    protected Injector() {
    }

    protected Injector(DynamicClassInfo dynamicClassInfo, int n) {
        super(dynamicClassInfo, n);
        this.origBytecodesLength = this.bytecodesLength;
        this.maxStack = Injector.getU2(this.origMethodInfo, this.bytecodesStartIdx - 8);
        this.maxLocals = Injector.getU2(this.origMethodInfo, this.bytecodesStartIdx - 6);
        this.initExceptionTable();
        this.origExcTableEntryCount = this.excTableEntryCount;
    }

    public abstract byte[] instrumentMethod();

    protected void addExceptionTableEntry(int n, int n2, int n3, int n4) {
        int n5 = this.excTableEntryCount * 8;
        Injector.putU2(this.exceptionTable, n5, n);
        Injector.putU2(this.exceptionTable, n5 + 2, n2);
        Injector.putU2(this.exceptionTable, n5 + 4, n3);
        Injector.putU2(this.exceptionTable, n5 + 6, n4);
        ++this.excTableEntryCount;
    }

    protected void addGlobalCatchStackMapTableEntry(int n) {
        DynamicClassInfo dynamicClassInfo = (DynamicClassInfo)this.clazz;
        if (!this.classChecked) {
            this.classChecked = true;
            if (!this.clazz.getStackMapTables().hasTable()) {
                DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, 11);
            }
            if (this.clazz.getCPIndexOfClass("java/lang/Throwable") == -1) {
                DynamicConstantPoolExtension.getCPFragment(dynamicClassInfo, 12);
            }
        }
        dynamicClassInfo.addGlobalCatchStackMapTableEntry(this.methodIdx, n);
    }

    protected void appendCode(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.bytecodes, this.bytecodesLength, n);
        this.bytecodesLength += n;
    }

    protected byte[] createPackedMethodInfo() {
        ClassInfo.StackMapTables stackMapTables;
        int n;
        ClassInfo.LocalVariableTypeTables localVariableTypeTables;
        int n2;
        int n3 = this.bytecodesLength - this.origBytecodesLength + (this.excTableEntryCount - this.origExcTableEntryCount) * 8;
        byte[] byArray = new byte[this.origMethodInfo.length + n3];
        System.arraycopy(this.origMethodInfo, 0, byArray, 0, this.bytecodesStartIdx);
        System.arraycopy(this.bytecodes, 0, byArray, this.bytecodesStartIdx, this.bytecodesLength);
        int n4 = Injector.getU4(this.origMethodInfo, this.bytecodesStartIdx - 12);
        Injector.putU4(byArray, this.bytecodesStartIdx - 12, n4 += n3);
        Injector.putU4(byArray, this.bytecodesStartIdx - 4, this.bytecodesLength);
        System.arraycopy(this.origMethodInfo, this.bytecodesStartIdx + this.origBytecodesLength, byArray, this.bytecodesStartIdx + this.bytecodesLength, this.origMethodInfo.length - this.bytecodesStartIdx - this.origBytecodesLength);
        int n5 = this.clazz.getExceptionTableStartOffsetInMethodInfo(this.methodIdx);
        int n6 = n5 + (this.bytecodesLength - this.origBytecodesLength);
        int n7 = this.origExcTableEntryCount * 8;
        int n8 = this.excTableEntryCount * 8;
        if (n7 != n8) {
            System.arraycopy(byArray, n6 + n7, byArray, n6 + n8, this.origMethodInfo.length - n5 - n7);
            Injector.putU2(byArray, n6, this.excTableEntryCount);
        }
        System.arraycopy(this.exceptionTable, 0, byArray, n6 + 2, n8);
        ClassInfo.LocalVariableTables localVariableTables = this.clazz.getLocalVariableTables();
        if (localVariableTables.hasTable()) {
            int n9 = this.clazz.getLocalVariableTableStartOffsetInMethodInfo(this.methodIdx);
            n2 = n9 + n3;
            localVariableTables.writeTable(byArray, n2, this.methodIdx);
        }
        if ((localVariableTypeTables = this.clazz.getLocalVariableTypeTables()).hasTable()) {
            n2 = this.clazz.getLocalVariableTypeTableStartOffsetInMethodInfo(this.methodIdx);
            n = n2 + n3;
            localVariableTypeTables.writeTable(byArray, n, this.methodIdx);
        }
        if ((stackMapTables = this.clazz.getStackMapTables()).hasTable()) {
            n = this.clazz.getStackMapTableStartOffsetInMethodInfo(this.methodIdx);
            byte[] byArray2 = stackMapTables.writeTable(this.methodIdx);
            if (byArray2 != null) {
                int n10;
                int n11 = 0;
                if (n != 0) {
                    n10 = n + n3;
                    int n12 = Injector.getU4(byArray, n10 - 6) - 2;
                    if (byArray2.length > n12) {
                        n11 = byArray2.length - n12;
                        byArray = this.insertBytes(byArray, n10 + n12, n11);
                    }
                    System.arraycopy(byArray2, 0, byArray, n10, byArray2.length);
                } else {
                    byte[] byArray3 = stackMapTables.getAttributeHeader(this.methodIdx);
                    int n13 = this.bytecodesStartIdx - 8 + n4;
                    n11 = byArray3.length + byArray2.length;
                    n10 = n13 + byArray3.length;
                    byArray = this.insertBytes(byArray, n13, n11);
                    System.arraycopy(byArray3, 0, byArray, n10 - byArray3.length, byArray3.length);
                    System.arraycopy(byArray2, 0, byArray, n10, byArray2.length);
                    int n14 = n6 + 2 + n8;
                    Injector.putU2(byArray, n14, Injector.getU2(byArray, n14) + 1);
                }
                if (n11 > 0) {
                    Injector.putU4(byArray, this.bytecodesStartIdx - 12, n4 + n11);
                    Injector.putU4(byArray, n10 - 6, byArray2.length + 2);
                    Injector.putU2(byArray, n10 - 2, stackMapTables.getNumberOfFrames(this.methodIdx));
                }
            }
        }
        Injector.putU2(byArray, this.bytecodesStartIdx - 8, this.maxStack + 2);
        Injector.putU2(byArray, this.bytecodesStartIdx - 6, this.maxLocals);
        return byArray;
    }

    private byte[] insertBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[byArray.length + n2];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (n < byArray.length) {
            System.arraycopy(byArray, n, byArray2, n + n2, byArray.length - n);
        }
        return byArray2;
    }

    protected void injectCodeAndRewrite(byte[] byArray, int n, int n2, boolean bl) {
        this.injectionBindsToFollowingInstruction = bl;
        this.relocateCode(n2, 0, n, true);
        System.arraycopy(byArray, 0, this.bytecodes, n2, n);
        this.handleCodeChanges();
    }

    protected void insertProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, int n) {
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            assert (i == 0 || runtimeProfilingPoint.getBci() >= runtimeProfilingPointArray[i - 1].getBci());
            int n2 = runtimeProfilingPoint.getBci() + i * injProfilePointHitCode.length;
            this.injectProfilePointHit(runtimeProfilingPoint, n2, n);
            this.maxStack = Math.max(this.maxStack, 4);
        }
    }

    void handleJumpWiden(int n, int n2) {
        int n3 = this.rcInstrLen(n);
        if (n3 != 3) {
            return;
        }
        this.relocateCode(n, 3, 2, false);
        int n4 = this.bytecodes[n] & 0xFF;
        switch (n4) {
            case 167: {
                this.bytecodes[n] = -56;
                break;
            }
            case 168: {
                this.bytecodes[n] = -55;
                break;
            }
            default: {
                System.err.println("*** Profiler Engine: error - should not reach here in handleJumpWiden!");
            }
        }
        if (n2 > 0) {
            n2 += 2;
        }
        this.putInt(n + 1, n2);
    }

    private int getOrigSwitchPadding(int n, boolean bl) {
        for (int i = 0; i < changes.size(); ++i) {
            ChangeItem changeItem = (ChangeItem)changes.elementAt(i);
            if (!(changeItem instanceof ChangeSwitchPadding)) continue;
            ChangeSwitchPadding changeSwitchPadding = (ChangeSwitchPadding)changeItem;
            if (changeSwitchPadding.isLookupSwitch != bl || changeSwitchPadding.bci != n) continue;
            return changeSwitchPadding.padding;
        }
        return -1;
    }

    private void changeJump(int n, int n2, boolean bl, int n3, int n4) {
        int n5 = bl ? this.getShort(n2) : this.getInt(n2);
        int n6 = n + n5;
        boolean bl2 = false;
        if (this.changeTypeIsInjectNewInstr) {
            if (n3 == 0) {
                return;
            }
            if (this.injectionBindsToFollowingInstruction) {
                if (n < n3 && n6 > n3 || n >= n3 && n6 <= n3) {
                    bl2 = true;
                }
            } else if (n < n3 && n6 >= n3 || n >= n3 && n6 < n3) {
                bl2 = true;
            }
        } else if (n <= n3 && n6 > n3 || n >= n3 && n6 < n3) {
            bl2 = true;
        }
        if (bl2) {
            int n7;
            int n8 = n7 = n5 > 0 ? n5 + n4 : n5 - n4;
            if (bl && (n7 > Short.MAX_VALUE || n7 < Short.MIN_VALUE)) {
                changes.push(new ChangeJumpWiden(n, n7));
            } else if (bl) {
                this.putShort(n2, (short)n7);
            } else {
                this.putInt(n2, n7);
            }
        }
    }

    private void changeJumps(int n, int n2) {
        int n3 = 0;
        block4: while (n3 < this.bytecodesLength) {
            int n4 = this.bytecodes[n3] & 0xFF;
            if (n4 >= 153 && n4 <= 166 || n4 == 198 || n4 == 199 || n4 == 167 || n4 == 168) {
                this.changeJump(n3, n3 + 1, true, n, n2);
            } else {
                switch (n4) {
                    case 200: 
                    case 201: {
                        this.changeJump(n3, n3 + 1, false, n, n2);
                        break;
                    }
                    case 170: 
                    case 171: {
                        int n5;
                        int n6;
                        int n7;
                        int n8 = this.getOrigSwitchPadding(n3, n4 != 170);
                        int n9 = n7 = n8 != -1 ? n8 : Injector.align(n3 + 1) - (n3 + 1);
                        if (n3 > n && (n6 = Injector.align((n5 = n3 + n2) + 1) - (n5 + 1)) != n7 && n8 == -1) {
                            changes.push(new ChangeSwitchPadding(n3, n7, n4 != 170));
                        }
                        if (n4 == 170) {
                            this.changeJump(n3, n3 + 1 + n7, false, n, n2);
                            n5 = this.getInt(n3 + 1 + n7 + 4);
                            n6 = this.getInt(n3 + 1 + n7 + 8);
                            int n10 = n6 - n5 + 1;
                            for (int i = 0; i < n10; ++i) {
                                this.changeJump(n3, n3 + 1 + n7 + 4 * (i + 3), false, n, n2);
                            }
                            n3 += 1 + n7 + (n10 + 3) * 4;
                            continue block4;
                        }
                        this.changeJump(n3, n3 + 1 + n7, false, n, n2);
                        n5 = this.getInt(n3 + 1 + n7 + 4);
                        for (n6 = 0; n6 < n5; ++n6) {
                            this.changeJump(n3, n3 + 1 + n7 + 4 * (2 + 2 * n6 + 1), false, n, n2);
                        }
                        n3 += 1 + n7 + (2 + n5 * 2) * 4;
                        continue block4;
                    }
                }
            }
            n3 += this.opcodeLength(n3);
        }
    }

    private void handleCodeChanges() {
        while (!changes.empty()) {
            ChangeItem changeItem = (ChangeItem)changes.pop();
            changeItem.handleCodeChange(this);
        }
    }

    private void handleSwitchPadding(int n, int n2, boolean bl) {
        int n3 = this.rcInstrLen(n);
        int n4 = Injector.align(n + 1) - (n + 1);
        int n5 = n4 - n2;
        if (n5 != 0) {
            int n6;
            if (!bl) {
                int n7 = this.getInt(n + 1 + n2 + 4);
                int n8 = this.getInt(n + 1 + n2 + 8);
                n6 = n8 - n7 + 1 + 3;
            } else {
                int n9 = this.getInt(n + 1 + n2 + 4);
                n6 = n9 * 2 + 2;
            }
            this.relocateCode(n, n3, n5, false);
            if (n5 < 0) {
                System.arraycopy(this.bytecodes, n + 1 + n2, this.bytecodes, n + 1 + n4, n6 * 4 + n5);
                System.arraycopy(_overwrite, 0, this.bytecodes, n + 1 + n4 + n6 * 4 + n5, -n5);
            } else {
                System.arraycopy(this.bytecodes, n + 1 + n2, this.bytecodes, n + 1 + n4, n6 * 4);
            }
        }
    }

    private void initExceptionTable() {
        int n = this.clazz.getExceptionTableStartOffsetInMethodInfo(this.methodIdx);
        this.excTableEntryCount = this.clazz.getExceptionTableCount(this.methodIdx);
        int n2 = this.excTableEntryCount * 8;
        if (reusableExcTable.length < n2 + 40) {
            reusableExcTable = new byte[n2 * 2 + 40];
        }
        System.arraycopy(this.origMethodInfo, n + 2, reusableExcTable, 0, n2);
        this.exceptionTable = reusableExcTable;
    }

    private void injectProfilePointHit(RuntimeProfilingPoint runtimeProfilingPoint, int n, int n2) {
        Injector.putU2(injProfilePointHitCode, 4, n2 + this.baseCPoolCount);
        Injector.putU2(injProfilePointHitCode, 1, runtimeProfilingPoint.getId());
        this.injectCodeAndRewrite(injProfilePointHitCode, injProfilePointHitCode.length, n, true);
    }

    private int rcInstrLen(int n) {
        int n2 = this.bytecodes[n] & 0xFF;
        switch (n2) {
            case 170: 
            case 171: {
                int n3 = this.getOrigSwitchPadding(n, n2 == 171);
                if (n3 == -1) {
                    return this.opcodeLength(n);
                }
                switch (n2) {
                    case 170: {
                        int n4 = this.getInt(n + 1 + n3 + 4);
                        int n5 = this.getInt(n + 1 + n3 + 8);
                        int n6 = n5 - n4 + 1;
                        return 1 + n3 + 4 * (3 + n6);
                    }
                    case 171: {
                        int n7 = this.getInt(n + 1 + n3 + 4);
                        return 1 + n3 + 4 * (2 + 2 * n7);
                    }
                }
            }
        }
        return this.opcodeLength(n);
    }

    private void relocateCode(int n, int n2, int n3, boolean bl) {
        this.changeTypeIsInjectNewInstr = bl;
        if (n > 0) {
            this.changeJumps(n, n3);
        }
        if (n3 < 0) {
            System.arraycopy(this.bytecodes, n + n2 + n3, _overwrite, 0, -n3);
        }
        int n4 = n + n2;
        System.arraycopy(this.bytecodes, n4, this.bytecodes, n4 + n3, this.bytecodesLength - n4);
        this.bytecodesLength += n3;
        this.updateExceptionTable(n, n3);
        this.updateLocalVariableTable(n, n3);
        this.updateLocalVariableTypeTable(n, n3);
        this.updateStackMapTable(n, n3);
        for (int i = 0; i < changes.size(); ++i) {
            ChangeItem changeItem = (ChangeItem)changes.elementAt(i);
            changeItem.relocate(n, n3);
        }
    }

    private void updateExceptionTable(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.excTableEntryCount; ++i) {
            int n4 = Injector.getU2(this.exceptionTable, n3);
            int n5 = Injector.getU2(this.exceptionTable, n3 + 2);
            int n6 = Injector.getU2(this.exceptionTable, n3 + 4);
            if (n4 > n) {
                Injector.putU2(this.exceptionTable, n3, n4 += n2);
                Injector.putU2(this.exceptionTable, n3 + 2, n5 += n2);
            } else if (n < n5) {
                Injector.putU2(this.exceptionTable, n3 + 2, n5 += n2);
            }
            if (n6 > n) {
                Injector.putU2(this.exceptionTable, n3 + 4, n6 += n2);
            }
            n3 += 8;
        }
    }

    private void updateLocalVariableTable(int n, int n2) {
        ClassInfo.LocalVariableTables localVariableTables = this.clazz.getLocalVariableTables();
        localVariableTables.updateTable(n, n2, this.methodIdx);
    }

    private void updateLocalVariableTypeTable(int n, int n2) {
        ClassInfo.LocalVariableTypeTables localVariableTypeTables = this.clazz.getLocalVariableTypeTables();
        localVariableTypeTables.updateTable(n, n2, this.methodIdx);
    }

    private void updateStackMapTable(int n, int n2) {
        ClassInfo.StackMapTables stackMapTables = this.clazz.getStackMapTables();
        stackMapTables.updateTable(n, n2, this.methodIdx, this.changeTypeIsInjectNewInstr, this.injectionBindsToFollowingInstruction);
    }

    private static class ChangeSwitchPadding
    extends ChangeItem {
        boolean isLookupSwitch;
        int padding;

        ChangeSwitchPadding(int n, int n2, boolean bl) {
            super(n);
            this.padding = n2;
            this.isLookupSwitch = bl;
        }

        @Override
        void handleCodeChange(Injector injector) {
            injector.handleSwitchPadding(this.bci, this.padding, this.isLookupSwitch);
        }
    }

    private static class ChangeJumpWiden
    extends ChangeItem {
        int delta;

        ChangeJumpWiden(int n, int n2) {
            super(n);
            this.delta = n2;
        }

        @Override
        void handleCodeChange(Injector injector) {
            injector.handleJumpWiden(this.bci, this.delta);
        }
    }

    private static abstract class ChangeItem {
        int bci;

        ChangeItem(int n) {
            this.bci = n;
        }

        abstract void handleCodeChange(Injector var1);

        void relocate(int n, int n2) {
            if (this.bci > n) {
                this.bci += n2;
            }
        }
    }
}

