/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers$WhenMappings;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt$sam$com_intellij_util_Function$0;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.ParameterConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H<0\u00050\u0004\"\u0004\b\u0000\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0\u0004H\u0007J\u0018\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u000201H\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u0010@\u001a\u0002012\u0006\u0010C\u001a\u00020BH\u0007J\u0018\u0010D\u001a\u00020B2\u0006\u0010@\u001a\u0002012\u0006\u0010C\u001a\u00020BH\u0007J\u0016\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u0018\u0010J\u001a\u00020B2\u0006\u0010@\u001a\u0002012\u0006\u0010C\u001a\u00020BH\u0007J\u0018\u0010K\u001a\u00020B2\u0006\u0010@\u001a\u0002012\u0006\u0010L\u001a\u00020BH\u0007J\u0018\u0010M\u001a\u00020,2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020IH\u0002J\u001e\u0010Q\u001a\u00020,2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\u0006\u0010S\u001a\u00020TH\u0002J\u0018\u0010U\u001a\u00020B2\u0006\u0010@\u001a\u0002012\u0006\u0010C\u001a\u00020BH\u0007J\"\u0010V\u001a\u0004\u0018\u00010B2\u0006\u0010@\u001a\u0002012\u0006\u0010C\u001a\u00020B2\u0006\u0010W\u001a\u00020GH\u0002J\f\u0010X\u001a\u00020,*\u00020,H\u0002J\f\u0010X\u001a\u00020,*\u00020YH\u0002R \u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers;", "", "()V", "AMBIGUOUS_CALLS", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "CLASSES_OR_SEPARATED", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "COMPACT", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartDescriptorRenderer;", "COMPACT_WITHOUT_SUPERTYPES", "COMPACT_WITH_MODIFIERS", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_NAME_WITH_KIND", "DEPRECATION_RENDERER", "ELEMENT_TEXT", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "FQ_NAMES_IN_TYPES", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "NAME", "Lorg/jetbrains/kotlin/descriptors/Named;", "NAME_OF_CONTAINING_DECLARATION_OR_FILE", "PLATFORM", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "RENDER_CLASS_OR_OBJECT", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "RENDER_CLASS_OR_OBJECT_NAME", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "RENDER_COLLECTION_OF_TYPES", "Lorg/jetbrains/kotlin/types/KotlinType;", "RENDER_POSITION_VARIANCE", "Lorg/jetbrains/kotlin/types/Variance;", "RENDER_TYPE", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartTypeRenderer;", "RENDER_WHEN_MISSING_CASES", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "SHORT_NAMES_IN_TYPES", "STRING", "", "THROWABLE", "", "TO_STRING", "TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER", "TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER", "TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER", "TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER", "VISIBILITY", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "WHEN_MISSING_LIMIT", "", "WITHOUT_MODIFIERS", "commaSeparated", "T", "itemRenderer", "debugMessage", "message", "inferenceErrorData", "renderCannotCaptureTypeParameterError", "Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;", "result", "renderConflictingSubstitutionsInferenceError", "renderConstraintSystem", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "shortTypeBounds", "", "renderNoInformationForParameterError", "renderParameterConstraintError", "renderer", "renderTypeBounds", "typeBounds", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "short", "renderTypes", "types", "context", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "renderUpperBoundViolatedInferenceError", "renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor", "systemWithoutWeakConstraints", "wrapIntoQuotes", "Lorg/jetbrains/kotlin/name/Name;", "frontend"})
public final class Renderers {
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Object> TO_STRING;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<String> STRING;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Throwable> THROWABLE;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Named> NAME;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<ModuleDescriptor> PLATFORM;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Visibility> VISIBILITY;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<DeclarationDescriptor> DECLARATION_NAME_WITH_KIND;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<DeclarationDescriptor> CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<DeclarationDescriptor> NAME_OF_CONTAINING_DECLARATION_OR_FILE;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<PsiElement> ELEMENT_TEXT;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<KtClassOrObject> RENDER_CLASS_OR_OBJECT;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<ClassifierDescriptorWithTypeParameters> RENDER_CLASS_OR_OBJECT_NAME;
    @JvmField
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Variance> RENDER_POSITION_VARIANCE;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<InferenceErrorData> TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends KotlinType>> RENDER_COLLECTION_OF_TYPES;
    private static final int WHEN_MISSING_LIMIT = 7;
    @JvmField
    @NotNull
    public static final DiagnosticParameterRenderer<List<? extends WhenMissingCase>> RENDER_WHEN_MISSING_CASES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITHOUT_SUPERTYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer WITHOUT_MODIFIERS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer SHORT_NAMES_IN_TYPES;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITH_MODIFIERS;
    @JvmField
    @NotNull
    public static final SmartDescriptorRenderer DEPRECATION_RENDERER;
    public static final Renderers INSTANCE;

    @JvmStatic
    @NotNull
    public static final <T> DiagnosticParameterRenderer<Collection<? extends T>> commaSeparated(@NotNull DiagnosticParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkParameterIsNotNull(itemRenderer, (String)"itemRenderer");
        return DiagnosticParameterRendererKt.ContextDependentRenderer((Function2)new Function2<Collection<? extends T>, RenderingContext, String>(itemRenderer){
            final /* synthetic */ DiagnosticParameterRenderer $itemRenderer;

            @NotNull
            public final String invoke(@NotNull Collection<? extends T> collection, @NotNull RenderingContext context) {
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull(collection, (String)"collection");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                Iterator<T> iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    T next = iterator2.next();
                    $receiver.append(this.$itemRenderer.render(next, context));
                    if (!iterator2.hasNext()) continue;
                    $receiver.append(", ");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
            {
                this.$itemRenderer = diagnosticParameterRenderer;
                super(2);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        CallableDescriptor substitutedDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)inferenceErrorData, (String)"inferenceErrorData");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), INSTANCE.debugMessage("Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor2 : substitutors) {
            CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
            TypeSubstitutor typeSubstitutor2 = substitutor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"substitutor");
            substitutedDescriptor = (CallableDescriptor)callableDescriptor.substitute(typeSubstitutor2);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeVariable firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(inferenceErrorData.constraintSystem);
        if (firstConflictingVariable == null) {
            LOG.error(INSTANCE.debugMessage("There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingVariable.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        Iterator iterator2 = substitutedDescriptors.iterator();
        while (iterator2.hasNext()) {
            CallableDescriptor callableDescriptor = substitutedDescriptor = (CallableDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"substitutedDescriptor");
            KotlinType receiverType = DescriptorUtils.getReceiverParameterType(callableDescriptor.getExtensionReceiverParameter());
            HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<KotlinType> parameterTypes = Lists.newArrayList();
            Iterator<ValueParameterDescriptor> iterator3 = substitutedDescriptor.getValueParameters().iterator();
            while (iterator3.hasNext()) {
                KotlinType actualType;
                ValueParameterDescriptor valueParameterDescriptor;
                ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor = iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2, (String)"valueParameterDescriptor");
                parameterTypes.add(valueParameterDescriptor2.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<KotlinType>)parameterTypes, new Predicate<ConstraintPosition>(errorPositions){
                final /* synthetic */ HashSet $errorPositions;

                public final boolean test(ConstraintPosition it) {
                    return this.$errorPositions.contains(it);
                }
                {
                    this.$errorPositions = hashSet;
                }
            });
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderParameterConstraintError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer renderer) {
        ConstraintError it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)inferenceErrorData, (String)"inferenceErrorData");
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        List<ConstraintError> constraintErrors = inferenceErrorData.constraintSystem.getStatus().getConstraintErrors();
        Iterable iterable = $receiver$iv = (Iterable)constraintErrors;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ConstraintError)element$iv$iv;
            if (!(it instanceof ParameterConstraintError)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ConstraintError)item$iv$iv;
            Collection collection = destination$iv$iv;
            ConstraintPosition constraintPosition = it.getConstraintPosition();
            collection.add(constraintPosition);
        }
        List errorPositions = (List)destination$iv$iv;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, new Predicate<ConstraintPosition>(errorPositions){
            final /* synthetic */ List $errorPositions;

            public final boolean test(ConstraintPosition it) {
                return this.$errorPositions.contains(it);
            }
            {
                this.$errorPositions = list2;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)tabledDescriptorRenderer, (String)"renderer.table(\n        \u2026contains(it) })\n        )");
        return tabledDescriptorRenderer;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)inferenceErrorData, (String)"inferenceErrorData");
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            Iterable $receiver$iv = inferenceErrorData.constraintSystem.getTypeVariables();
            for (Object element$iv : $receiver$iv) {
                TypeVariable variable2 = (TypeVariable)element$iv;
                if (!inferenceErrorData.constraintSystem.getTypeBounds(variable2).getValues().isEmpty()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TypeVariable typeVariable2 = v0;
        if (typeVariable2 == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            TabledDescriptorRenderer $receiver = tabledDescriptorRenderer = result2;
            LOG.error(INSTANCE.debugMessage("There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData));
            return tabledDescriptorRenderer;
        }
        TypeVariable firstUnknownVariable = typeVariable2;
        TabledDescriptorRenderer tabledDescriptorRenderer = result2.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownVariable.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkExpressionValueIsNotNull((Object)tabledDescriptorRenderer, (String)"result\n            .text\u2026plicitly.\")\n            )");
        return tabledDescriptorRenderer;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v3;
        Object $receiver$iv;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status2;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)inferenceErrorData, (String)"inferenceErrorData");
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            status2 = constraintSystem.getStatus();
            LOG.assertTrue(status2.hasViolatedUpperBound(), INSTANCE.debugMessage("Upper bound violated renderer is applied for incorrect status", inferenceErrorData));
            ConstraintSystem constraintSystem2 = constraintSystem;
            Intrinsics.checkExpressionValueIsNotNull((Object)constraintSystem2, (String)"constraintSystem");
            systemWithoutWeakConstraints = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem2, ConstraintPositionKind.TYPE_BOUND_POSITION);
            CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"inferenceErrorData.descriptor");
            List<TypeParameterDescriptor> list2 = callableDescriptor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"inferenceErrorData.descriptor.typeParameters");
            $receiver$iv = list2;
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, it, inferenceErrorData.call, true))) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v3;
        if (typeParameterDescriptor == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            if (inferenceErrorData.descriptor instanceof TypeAliasConstructorDescriptor) {
                TabledDescriptorRenderer tabledDescriptorRenderer2 = INSTANCE.renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(inferenceErrorData, result2, systemWithoutWeakConstraints);
                if (tabledDescriptorRenderer2 != null) {
                    Object it = $receiver$iv = tabledDescriptorRenderer2;
                    return it;
                }
            }
            if (status2.hasConflictingConstraints()) {
                tabledDescriptorRenderer = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
            } else {
                LOG.error(INSTANCE.debugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData));
                tabledDescriptorRenderer = result2;
            }
            return tabledDescriptorRenderer;
        }
        Call call2 = inferenceErrorData.call;
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"inferenceErrorData.call");
        TypeVariable typeVariable2 = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, TypeVariableKt.toHandle(call2), typeParameterDescriptor);
        KotlinType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeVariable2).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(INSTANCE.debugMessage("System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        KotlinType violatedUpperBound = null;
        for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(INSTANCE.debugMessage("Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData));
            return result2;
        }
        RenderingContext context = RenderingContext.Companion.of(inferredValueForTypeParameter, violatedUpperBound);
        DiagnosticParameterRenderer<KotlinType> typeRenderer = result2.getTypeRenderer();
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter, context)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound, context)));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final TabledDescriptorRenderer renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2, ConstraintSystem systemWithoutWeakConstraints) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        CallableDescriptor descriptor2 = inferenceErrorData.descriptor;
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            LOG.error("Type alias constructor descriptor expected: " + descriptor2);
            return result2;
        }
        List<TypeParameterDescriptor> list2 = ((TypeAliasConstructorDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.typeParameters");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            Call call2 = inferenceErrorData.call;
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"inferenceErrorData.call");
            CallHandle callHandle = TypeVariableKt.toHandle(call2);
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            TypeVariable typeVariable2 = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, callHandle, (TypeParameterDescriptor)v3);
            KotlinType kotlinType = systemWithoutWeakConstraints.getTypeBounds(typeVariable2).getValue();
            collection.add(kotlinType);
        }
        List inferredTypesForTypeParameters = (List)destination$iv$iv;
        TypeSubstitutor inferredTypeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(descriptor2, inferredTypesForTypeParameters){
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ List $inferredTypesForTypeParameters;

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                TypeProjectionImpl typeProjectionImpl;
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                ClassifierDescriptor classifierDescriptor = key.getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                    classifierDescriptor = null;
                }
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
                if (typeParameterDescriptor == null) {
                    return null;
                }
                TypeParameterDescriptor typeDescriptor = typeParameterDescriptor;
                if (Intrinsics.areEqual((Object)typeDescriptor.getContainingDeclaration(), (Object)((TypeAliasConstructorDescriptor)this.$descriptor).getTypeAliasDescriptor()) ^ true) {
                    return null;
                }
                KotlinType kotlinType = (KotlinType)this.$inferredTypesForTypeParameters.get(typeDescriptor.getIndex());
                if (kotlinType != null) {
                    KotlinType kotlinType2;
                    KotlinType p1 = kotlinType2 = kotlinType;
                    typeProjectionImpl = new TypeProjectionImpl(p1);
                } else {
                    typeProjectionImpl = null;
                }
                return typeProjectionImpl;
            }
            {
                this.$descriptor = $captured_local_variable$0;
                this.$inferredTypesForTypeParameters = $captured_local_variable$1;
            }
        });
        for (ConstraintError constraintError : inferenceErrorData.constraintSystem.getStatus().getConstraintErrors()) {
            ValidityConstraintForConstituentType validityConstraintForConstituentType = ConstraintPositionKt.getValidityConstraintForConstituentType(constraintError.getConstraintPosition());
            if (validityConstraintForConstituentType == null) {
                continue;
            }
            ValidityConstraintForConstituentType constraintInfo = validityConstraintForConstituentType;
            KotlinType violatedUpperBound = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getBound(), Variance.INVARIANT);
            KotlinType violatingInferredType = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getTypeArgument(), Variance.INVARIANT);
            RenderingContext context = RenderingContext.Companion.of(violatingInferredType, violatedUpperBound);
            DiagnosticParameterRenderer<KotlinType> typeRenderer = result2.getTypeRenderer();
            result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(constraintInfo.getTypeParameter().getName()).normal(" in type inferred from type alias expansion for ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
            result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(violatingInferredType, context)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound, context)));
            return result2;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        boolean it2;
        CapturedTypeConstructor capturedTypeConstructor;
        TypeConstructor typeConstructor2;
        TypeBounds.Bound boundWithCapturedType;
        Object object;
        Object v3;
        TypeVariable typeVariableWithCapturedConstraint;
        block7: {
            Object v0;
            ConstraintSystem system;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)inferenceErrorData, (String)"inferenceErrorData");
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                system = inferenceErrorData.constraintSystem;
                List<ConstraintError> errors = system.getStatus().getConstraintErrors();
                Iterable $receiver$iv = errors;
                for (Object element$iv : $receiver$iv) {
                    if (!(element$iv instanceof CannotCapture)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            CannotCapture cannotCapture = v0;
            TypeVariable typeVariable2 = typeVariableWithCapturedConstraint = cannotCapture != null ? cannotCapture.getTypeVariable() : null;
            if (typeVariableWithCapturedConstraint == null) {
                LOG.error(INSTANCE.debugMessage("An error 'cannot capture type parameter' is not found in errors", inferenceErrorData));
                return result2;
            }
            TypeBounds typeBounds = system.getTypeBounds(typeVariableWithCapturedConstraint);
            Iterable $receiver$iv = typeBounds.getBounds();
            for (Object element$iv : $receiver$iv) {
                TypeBounds.Bound it2 = (TypeBounds.Bound)element$iv;
                if (!CapturedTypeConstructorKt.isCaptured(it2.getConstrainingType())) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        if (!(((object = (boundWithCapturedType = (TypeBounds.Bound)v3)) != null && (object = ((TypeBounds.Bound)object).getConstrainingType()) != null ? ((KotlinType)object).getConstructor() : (typeConstructor2 = null)) instanceof CapturedTypeConstructor)) {
            typeConstructor2 = null;
        }
        if ((capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2) == null) {
            LOG.error(INSTANCE.debugMessage("There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData));
            return result2;
        }
        TypeParameterDescriptor typeParameter = typeVariableWithCapturedConstraint.getOriginalTypeParameter();
        KotlinType upperBound = TypeIntersector.getUpperBoundsAsType(typeParameter);
        boolean bl = it2 = !KotlinBuiltIns.isNullableAny(upperBound) && capturedTypeConstructor.getTypeProjection().getProjectionKind() == Variance.IN_VARIANCE;
        if (_Assertions.ENABLED && !it2) {
            String string = "There is the only reason to report TYPE_INFERENCE_CANNOT_CAPTURE_TYPES";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String explanation = "Type parameter has an upper bound " + INSTANCE.wrapIntoQuotes(result2.getTypeRenderer().render(upperBound, RenderingContext.Companion.of(upperBound))) + " that cannot be satisfied capturing 'in' projection";
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText();
        StringBuilder stringBuilder = new StringBuilder();
        Name name = typeParameter.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"typeParameter.name");
        result2.text(textRenderer.normal(stringBuilder.append(INSTANCE.wrapIntoQuotes(name)).append(" cannot capture ").append("").append(INSTANCE.wrapIntoQuotes(capturedTypeConstructor.getTypeProjection().toString())).append(". ").append(explanation).toString()));
        return result2;
    }

    private final String renderTypes(Collection<? extends KotlinType> types, RenderingContext context) {
        return StringUtil.join(types, (Function)new Function<T, String>(context){
            final /* synthetic */ RenderingContext $context;

            @NotNull
            public final String fun(KotlinType it) {
                KotlinType kotlinType = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it");
                return Renderers.RENDER_TYPE.render(kotlinType, this.$context);
            }
            {
                this.$context = renderingContext;
            }
        }, ", ");
    }

    @NotNull
    public final String renderConstraintSystem(@NotNull ConstraintSystem constraintSystem, boolean shortTypeBounds) {
        Intrinsics.checkParameterIsNotNull((Object)constraintSystem, (String)"constraintSystem");
        LinkedHashSet<TypeBounds> typeBounds = new LinkedHashSet<TypeBounds>();
        for (TypeVariable variable2 : constraintSystem.getTypeVariables()) {
            typeBounds.add(constraintSystem.getTypeBounds(variable2));
        }
        return "type parameter bounds:\n" + StringUtil.join((Collection)typeBounds, (Function)new Function<T, String>(shortTypeBounds){
            final /* synthetic */ boolean $shortTypeBounds;

            @NotNull
            public final String fun(TypeBounds it) {
                TypeBounds typeBounds = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeBounds, (String)"it");
                return Renderers.access$renderTypeBounds(Renderers.INSTANCE, typeBounds, this.$shortTypeBounds);
            }
            {
                this.$shortTypeBounds = bl;
            }
        }, "\n") + "\n\n" + "status:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    private final String renderTypeBounds(TypeBounds typeBounds, boolean bl) {
        String string;
        Function1 renderBound2 = (Function1)new Function1<TypeBounds.Bound, String>(bl){
            final /* synthetic */ boolean $short;

            @NotNull
            public final String invoke(@NotNull TypeBounds.Bound bound) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)bound, (String)"bound");
                switch (Renderers$WhenMappings.$EnumSwitchMapping$1[bound.getKind().ordinal()]) {
                    case 1: {
                        string = ">: ";
                        break;
                    }
                    case 2: {
                        string = "<: ";
                        break;
                    }
                    default: {
                        string = ":= ";
                    }
                }
                String arrow = string;
                DescriptorRenderer renderer = this.$short ? DescriptorRenderer.SHORT_NAMES_IN_TYPES : DescriptorRenderer.FQ_NAMES_IN_TYPES;
                String renderedBound = arrow + renderer.renderType(bound.getConstrainingType()) + (!bound.isProper() ? "*" : "");
                return this.$short ? renderedBound : renderedBound + '(' + bound.getPosition() + ')';
            }
            {
                this.$short = bl;
                super(1);
            }
        };
        Name typeVariableName = typeBounds.getTypeVariable().getName();
        if (typeBounds.getBounds().isEmpty()) {
            String string2 = typeVariableName.asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"typeVariableName.asString()");
        } else {
            Function1 function1 = renderBound2;
            string = "" + typeVariableName + ' ' + StringUtil.join(typeBounds.getBounds(), (Function)new RenderersKt$sam$com_intellij_util_Function$0(function1), ", ");
        }
        return string;
    }

    private final String debugMessage(String message, InferenceErrorData inferenceErrorData) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(message);
        $receiver.append("\nConstraint system: \n");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        Intrinsics.checkExpressionValueIsNotNull((Object)constraintSystem, (String)"inferenceErrorData.constraintSystem");
        $receiver.append(INSTANCE.renderConstraintSystem(constraintSystem, false));
        $receiver.append("\nDescriptor:\n");
        $receiver.append(inferenceErrorData.descriptor);
        $receiver.append("\nExpected type:\n");
        RenderingContext.Empty context = RenderingContext.Empty.INSTANCE;
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            $receiver.append(inferenceErrorData.expectedType);
        } else {
            KotlinType kotlinType = inferenceErrorData.expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"inferenceErrorData.expectedType");
            $receiver.append(RENDER_TYPE.render(kotlinType, (RenderingContext)context));
        }
        $receiver.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            $receiver.append(RENDER_TYPE.render(inferenceErrorData.receiverArgumentType, (RenderingContext)context)).append(".");
        }
        StringBuilder stringBuilder2 = $receiver.append("(");
        List<KotlinType> list2 = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"inferenceErrorData.valueArgumentsTypes");
        stringBuilder2.append(INSTANCE.renderTypes((Collection<? extends KotlinType>)list2, context)).append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String wrapIntoQuotes(@NotNull String $receiver) {
        return '\'' + $receiver + '\'';
    }

    private final String wrapIntoQuotes(@NotNull Name $receiver) {
        return '\'' + $receiver.asString() + '\'';
    }

    private Renderers() {
    }

    static {
        Renderers renderers;
        INSTANCE = renderers = new Renderers();
        LOG = Logger.getInstance(Renderers.class);
        TO_STRING = DiagnosticParameterRendererKt.Renderer(TO_STRING.1.INSTANCE);
        STRING = DiagnosticParameterRendererKt.Renderer(STRING.1.INSTANCE);
        THROWABLE = DiagnosticParameterRendererKt.Renderer(THROWABLE.1.INSTANCE);
        NAME = DiagnosticParameterRendererKt.Renderer(NAME.1.INSTANCE);
        PLATFORM = DiagnosticParameterRendererKt.Renderer(PLATFORM.1.INSTANCE);
        VISIBILITY = DiagnosticParameterRendererKt.Renderer(VISIBILITY.1.INSTANCE);
        DECLARATION_NAME_WITH_KIND = DiagnosticParameterRendererKt.Renderer(DECLARATION_NAME_WITH_KIND.1.INSTANCE);
        CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM = DiagnosticParameterRendererKt.ContextDependentRenderer(CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM.1.INSTANCE);
        NAME_OF_CONTAINING_DECLARATION_OR_FILE = DiagnosticParameterRendererKt.Renderer(NAME_OF_CONTAINING_DECLARATION_OR_FILE.1.INSTANCE);
        ELEMENT_TEXT = DiagnosticParameterRendererKt.Renderer(ELEMENT_TEXT.1.INSTANCE);
        DECLARATION_NAME = DiagnosticParameterRendererKt.Renderer(DECLARATION_NAME.1.INSTANCE);
        RENDER_CLASS_OR_OBJECT = DiagnosticParameterRendererKt.Renderer(RENDER_CLASS_OR_OBJECT.1.INSTANCE);
        RENDER_CLASS_OR_OBJECT_NAME = DiagnosticParameterRendererKt.Renderer(RENDER_CLASS_OR_OBJECT_NAME.1.INSTANCE);
        RENDER_TYPE = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)RENDER_TYPE.1.INSTANCE)));
        RENDER_POSITION_VARIANCE = DiagnosticParameterRendererKt.Renderer(RENDER_POSITION_VARIANCE.1.INSTANCE);
        AMBIGUOUS_CALLS = DiagnosticParameterRendererKt.Renderer(AMBIGUOUS_CALLS.1.INSTANCE);
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER.1.INSTANCE);
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = DiagnosticParameterRendererKt.Renderer(TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER.1.INSTANCE);
        CLASSES_OR_SEPARATED = DiagnosticParameterRendererKt.Renderer(CLASSES_OR_SEPARATED.1.INSTANCE);
        RENDER_COLLECTION_OF_TYPES = DiagnosticParameterRendererKt.ContextDependentRenderer(RENDER_COLLECTION_OF_TYPES.1.INSTANCE);
        WHEN_MISSING_LIMIT = 7;
        RENDER_WHEN_MISSING_CASES = DiagnosticParameterRendererKt.Renderer(RENDER_WHEN_MISSING_CASES.1.INSTANCE);
        FQ_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES);
        COMPACT = RenderersKt.asRenderer(DescriptorRenderer.COMPACT);
        COMPACT_WITHOUT_SUPERTYPES = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITHOUT_SUPERTYPES);
        WITHOUT_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)WITHOUT_MODIFIERS.1.INSTANCE)));
        SHORT_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        COMPACT_WITH_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITH_MODIFIERS);
        DEPRECATION_RENDERER = RenderersKt.asRenderer(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)DEPRECATION_RENDERER.1.INSTANCE)));
    }

    @NotNull
    public static final /* synthetic */ String access$renderTypeBounds(Renderers $this, @NotNull TypeBounds typeBounds, boolean bl) {
        return $this.renderTypeBounds(typeBounds, bl);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(Renderers $this) {
        Renderers renderers = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ String access$wrapIntoQuotes(Renderers $this, @NotNull String $receiver) {
        return $this.wrapIntoQuotes($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$renderTypes(Renderers $this, @NotNull Collection types, @NotNull RenderingContext context) {
        return $this.renderTypes(types, context);
    }

    public static final /* synthetic */ int access$getWHEN_MISSING_LIMIT$p(Renderers $this) {
        Renderers renderers = $this;
        return WHEN_MISSING_LIMIT;
    }
}

