/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ModifiedConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;

    public ModifiedConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        super(conflict.getMy().getDataSet());
        this.conflict = conflict;
    }

    @Override
    public String getDescriptionText() {
        String msg;
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                msg = I18n.marktr("Set the ''modified'' flag for node {0}");
                break;
            }
            case WAY: {
                msg = I18n.marktr("Set the ''modified'' flag for way {0}");
                break;
            }
            case RELATION: {
                msg = I18n.marktr("Set the ''modified'' flag for relation {0}");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return I18n.tr(msg, this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.conflict.getMy().isNew() && this.conflict.getMy().hasEqualSemanticAttributes(this.conflict.getTheir())) {
            this.conflict.getMy().setModified(this.conflict.getTheir().isModified());
        }
        this.getAffectedDataSet().getConflicts().remove(this.conflict);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conflict);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifiedConflictResolveCommand that = (ModifiedConflictResolveCommand)obj;
        return Objects.equals(this.conflict, that.conflict);
    }
}

