/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.io.importexport.JpgImporter;
import org.openstreetmap.josm.gui.io.importexport.NMEAImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.Offset;
import org.openstreetmap.josm.gui.layer.geoimage.Timezone;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.io.nmea.NmeaReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.SAXException;

public class CorrelateGpxWithImages
extends AbstractAction {
    private static List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    private final transient GeoImageLayer yLayer;
    private transient Timezone timezone;
    private transient Offset delta;
    private ExtendedDialog syncDialog;
    private final transient List<GpxDataWrapper> gpxLst = new ArrayList<GpxDataWrapper>();
    private JPanel outerPanel;
    private JosmComboBox<GpxDataWrapper> cbGpx;
    private JosmTextField tfTimezone;
    private JosmTextField tfOffset;
    private JCheckBox cbExifImg;
    private JCheckBox cbTaggedImg;
    private JCheckBox cbShowThumbs;
    private JLabel statusBarText;
    private int lastNumMatched;
    private final transient StatusBarUpdater statusBarUpdater = new StatusBarUpdater(false);
    private final transient StatusBarUpdater statusBarUpdaterWithRepaint = new StatusBarUpdater(true);
    private final transient RepaintTheMapListener repaintTheMap = new RepaintTheMapListener();

    public CorrelateGpxWithImages(GeoImageLayer layer) {
        super(I18n.tr("Correlate to GPX", new Object[0]));
        new ImageProvider("dialogs/geoimage/gpx2img").getResource().attachImageIcon(this, true);
        this.yLayer = layer;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        List<Layer> layerLst = MainApplication.getLayerManager().getLayers();
        this.gpxLst.clear();
        GpxDataWrapper defaultItem = null;
        for (Layer layer : layerLst) {
            if (!(layer instanceof GpxLayer)) continue;
            GpxLayer curGpx = (GpxLayer)layer;
            GpxDataWrapper gdw = new GpxDataWrapper(curGpx.getName(), curGpx.data, curGpx.data.storageFile);
            this.gpxLst.add(gdw);
            if (layer != this.yLayer.gpxLayer) continue;
            defaultItem = gdw;
        }
        for (GpxData gpxData : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(gpxData.storageFile.getName(), gpxData, gpxData.storageFile));
        }
        if (this.gpxLst.isEmpty()) {
            this.gpxLst.add(new GpxDataWrapper(I18n.tr("<No GPX track loaded yet>", new Object[0]), null, null));
        }
        JPanel panelCb = new JPanel();
        panelCb.add(new JLabel(I18n.tr("GPX track: ", new Object[0])));
        this.cbGpx = new JosmComboBox<GpxDataWrapper>(this.gpxLst.toArray(new GpxDataWrapper[0]));
        if (defaultItem != null) {
            this.cbGpx.setSelectedItem(defaultItem);
        } else {
            for (GpxDataWrapper item : this.gpxLst) {
                if (item.file == null) continue;
                this.cbGpx.setSelectedItem(item);
                break;
            }
        }
        this.cbGpx.addActionListener(this.statusBarUpdaterWithRepaint);
        panelCb.add(this.cbGpx);
        JButton jButton = new JButton(I18n.tr("Open another GPX trace", new Object[0]));
        jButton.addActionListener(new LoadGpxDataActionListener());
        panelCb.add(jButton);
        JPanel panelTf = new JPanel(new GridBagLayout());
        try {
            this.timezone = Timezone.parseTimezone(Optional.ofNullable(Config.getPref().get("geoimage.timezone", "0:00")).orElse("0:00"));
        }
        catch (ParseException e) {
            this.timezone = Timezone.ZERO;
        }
        this.tfTimezone = new JosmTextField(10);
        this.tfTimezone.setText(this.timezone.formatTimezone());
        try {
            this.delta = Offset.parseOffset(Config.getPref().get("geoimage.delta", "0"));
        }
        catch (ParseException e) {
            this.delta = Offset.ZERO;
        }
        this.tfOffset = new JosmTextField(10);
        this.tfOffset.setText(this.delta.formatOffset());
        JButton buttonViewGpsPhoto = new JButton(I18n.tr("<html>Use photo of an accurate clock,<br>e.g. GPS receiver display</html>", new Object[0]));
        buttonViewGpsPhoto.setIcon(ImageProvider.get("clock"));
        buttonViewGpsPhoto.addActionListener(new SetOffsetActionListener());
        JButton buttonAutoGuess = new JButton(I18n.tr("Auto-Guess", new Object[0]));
        buttonAutoGuess.setToolTipText(I18n.tr("Matches first photo with first gpx point", new Object[0]));
        buttonAutoGuess.addActionListener(new AutoGuessActionListener());
        JButton buttonAdjust = new JButton(I18n.tr("Manual adjust", new Object[0]));
        buttonAdjust.addActionListener(new AdjustActionListener());
        JLabel labelPosition = new JLabel(I18n.tr("Override position for: ", new Object[0]));
        int numAll = this.getSortedImgList(true, true).size();
        int numExif = numAll - this.getSortedImgList(false, true).size();
        int numTagged = numAll - this.getSortedImgList(true, false).size();
        this.cbExifImg = new JCheckBox(I18n.tr("Images with geo location in exif data ({0}/{1})", numExif, numAll));
        this.cbExifImg.setEnabled(numExif != 0);
        this.cbTaggedImg = new JCheckBox(I18n.tr("Images that are already tagged ({0}/{1})", numTagged, numAll), true);
        this.cbTaggedImg.setEnabled(numTagged != 0);
        labelPosition.setEnabled(this.cbExifImg.isEnabled() || this.cbTaggedImg.isEnabled());
        boolean ticked = this.yLayer.thumbsLoaded || Config.getPref().getBoolean("geoimage.showThumbs", false);
        this.cbShowThumbs = new JCheckBox(I18n.tr("Show Thumbnail images on the map", new Object[0]), ticked);
        this.cbShowThumbs.setEnabled(!this.yLayer.thumbsLoaded);
        int y = 0;
        GBC gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)panelCb, gbc);
        gbc = GBC.eol().fill(2).insets(0, 0, 0, 12);
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)new JSeparator(0), gbc);
        gbc = GBC.std();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)new JLabel(I18n.tr("Timezone: ", new Object[0])), gbc);
        gbc = GBC.std().fill(2);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfTimezone, gbc);
        gbc = GBC.std();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)new JLabel(I18n.tr("Offset:", new Object[0])), gbc);
        gbc = GBC.std().fill(2);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfOffset, gbc);
        gbc = GBC.std().insets(5, 5, 5, 5);
        gbc.gridx = 2;
        gbc.gridy = y - 2;
        gbc.gridheight = 2;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonViewGpsPhoto, gbc);
        gbc = GBC.std().fill(1).insets(5, 5, 5, 5);
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonAutoGuess, gbc);
        gbc.gridx = 3;
        panelTf.add((Component)buttonAdjust, gbc);
        gbc = GBC.eol().fill(2).insets(0, 12, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)new JSeparator(0), gbc);
        gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)labelPosition, gbc);
        gbc = GBC.eol();
        gbc.gridx = 1;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbExifImg, gbc);
        gbc = GBC.eol();
        gbc.gridx = 1;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbTaggedImg, gbc);
        gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)this.cbShowThumbs, gbc);
        JPanel statusBar = new JPanel(new FlowLayout(0, 0, 0));
        statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBarText = new JLabel(" ");
        this.statusBarText.setFont(this.statusBarText.getFont().deriveFont(8));
        statusBar.add(this.statusBarText);
        this.tfTimezone.addFocusListener(this.repaintTheMap);
        this.tfOffset.addFocusListener(this.repaintTheMap);
        this.tfTimezone.getDocument().addDocumentListener(this.statusBarUpdater);
        this.tfOffset.getDocument().addDocumentListener(this.statusBarUpdater);
        this.cbExifImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbTaggedImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.statusBarUpdater.updateStatusBar();
        this.outerPanel = new JPanel(new BorderLayout());
        this.outerPanel.add((Component)statusBar, "Last");
        if (!GraphicsEnvironment.isHeadless()) {
            this.syncDialog = new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("Correlate", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.syncDialog.setContent(panelTf, false);
            this.syncDialog.setButtonIcons("ok", "cancel");
            this.syncDialog.setupDialog();
            this.outerPanel.add((Component)this.syncDialog.getContentPane(), "First");
            this.syncDialog.setContentPane(this.outerPanel);
            this.syncDialog.pack();
            this.syncDialog.addWindowListener(new SyncDialogWindowListener());
            this.syncDialog.showDialog();
        }
    }

    static Pair<Timezone, Offset> autoGuess(List<ImageEntry> imgs, GpxData gpx) throws NoGpxTimestamps {
        long firstExifDate = imgs.get(0).getExifTime().getTime();
        long firstGPXDate = -1L;
        block0: for (GpxTrack trk : gpx.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                for (WayPoint curWp : segment.getWayPoints()) {
                    Date parsedTime = curWp.setTimeFromAttribute();
                    if (parsedTime == null) continue;
                    firstGPXDate = parsedTime.getTime();
                    break block0;
                }
            }
        }
        if (firstGPXDate < 0L) {
            throw new NoGpxTimestamps();
        }
        return Offset.milliseconds(firstExifDate - firstGPXDate).splitOutTimezone();
    }

    private List<ImageEntry> getSortedImgList() {
        return this.getSortedImgList(this.cbExifImg.isSelected(), this.cbTaggedImg.isSelected());
    }

    private List<ImageEntry> getSortedImgList(boolean exif, boolean tagged) {
        if (this.yLayer.data == null) {
            return Collections.emptyList();
        }
        ArrayList<ImageEntry> dateImgLst = new ArrayList<ImageEntry>(this.yLayer.data.size());
        for (ImageEntry e : this.yLayer.data) {
            if (!e.hasExifTime() || e.getExifCoor() != null && !exif || !tagged && e.isTagged() && e.getExifCoor() == null) continue;
            dateImgLst.add(e);
        }
        dateImgLst.sort(Comparator.comparing(ImageEntry::getExifTime));
        return dateImgLst;
    }

    private GpxDataWrapper selectedGPX(boolean complain) {
        Object item = this.cbGpx.getSelectedItem();
        if (item == null || ((GpxDataWrapper)item).file == null) {
            if (complain) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You should select a GPX track", new Object[0]), I18n.tr("No selected GPX track", new Object[0]), 0);
            }
            return null;
        }
        return (GpxDataWrapper)item;
    }

    static int matchGpxTrack(List<ImageEntry> images, GpxData selectedGpx, long offset) {
        int ret = 0;
        for (GpxTrack trk : selectedGpx.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                long prevWpTime = 0L;
                WayPoint prevWp = null;
                for (WayPoint curWp : segment.getWayPoints()) {
                    Date parsedTime = curWp.setTimeFromAttribute();
                    if (parsedTime != null) {
                        long curWpTime = parsedTime.getTime() + offset;
                        ret += CorrelateGpxWithImages.matchPoints(images, prevWp, prevWpTime, curWp, curWpTime, offset);
                        prevWp = curWp;
                        prevWpTime = curWpTime;
                        continue;
                    }
                    prevWp = null;
                    prevWpTime = 0L;
                }
            }
        }
        return ret;
    }

    private static Double getElevation(WayPoint wp) {
        String value = wp.getString("ele");
        if (value != null && !value.isEmpty()) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    static int matchPoints(List<ImageEntry> images, WayPoint prevWp, long prevWpTime, WayPoint curWp, long curWpTime, long offset) {
        ImageEntry curImg;
        long imgTime;
        long interval = prevWpTime > 0L ? Math.abs(curWpTime - prevWpTime) : TimeUnit.SECONDS.toMillis(5L);
        int ret = 0;
        int i = CorrelateGpxWithImages.getLastIndexOfListBefore(images, curWpTime);
        if (i < 0) {
            return 0;
        }
        Double speed = null;
        Double prevElevation = null;
        if (prevWp != null) {
            double distance = prevWp.getCoor().greatCircleDistance(curWp.getCoor());
            if (curWpTime > prevWpTime) {
                speed = 3600.0 * distance / (double)(curWpTime - prevWpTime);
            }
            prevElevation = CorrelateGpxWithImages.getElevation(prevWp);
        }
        Double curElevation = CorrelateGpxWithImages.getElevation(curWp);
        if (prevWpTime == 0L || curWpTime <= prevWpTime) {
            ImageEntry curImg2;
            long time;
            while (i >= 0 && (time = (curImg2 = images.get(i)).getExifTime().getTime()) <= curWpTime && time >= curWpTime - interval) {
                if (curImg2.tmp.getPos() == null) {
                    curImg2.tmp.setPos(curWp.getCoor());
                    curImg2.tmp.setSpeed(speed);
                    curImg2.tmp.setElevation(curElevation);
                    curImg2.tmp.setGpsTime(new Date(curImg2.getExifTime().getTime() - offset));
                    curImg2.tmp.flagNewGpsData();
                    ++ret;
                }
                --i;
            }
            return ret;
        }
        while (i >= 0 && (imgTime = (curImg = images.get(i)).getExifTime().getTime()) >= prevWpTime) {
            if (prevWp != null && curImg.tmp.getPos() == null) {
                double timeDiff = (double)(imgTime - prevWpTime) / (double)interval;
                curImg.tmp.setPos(prevWp.getCoor().interpolate(curWp.getCoor(), timeDiff));
                curImg.tmp.setSpeed(speed);
                if (curElevation != null && prevElevation != null) {
                    curImg.tmp.setElevation(prevElevation + (curElevation - prevElevation) * timeDiff);
                }
                curImg.tmp.setGpsTime(new Date(curImg.getExifTime().getTime() - offset));
                curImg.tmp.flagNewGpsData();
                ++ret;
            }
            --i;
        }
        return ret;
    }

    private static int getLastIndexOfListBefore(List<ImageEntry> images, long searchedTime) {
        int lstSize = images.size();
        if (lstSize == 0 || searchedTime < images.get(0).getExifTime().getTime()) {
            return -1;
        }
        if (searchedTime > images.get(lstSize - 1).getExifTime().getTime()) {
            return lstSize - 1;
        }
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            int curIndex = (endIndex + startIndex) / 2;
            if (searchedTime > images.get(curIndex).getExifTime().getTime()) {
                startIndex = curIndex;
                continue;
            }
            endIndex = curIndex;
        }
        if (searchedTime < images.get(endIndex).getExifTime().getTime()) {
            return startIndex;
        }
        while (endIndex < lstSize - 1 && images.get(endIndex).getExifTime().getTime() == images.get(endIndex + 1).getExifTime().getTime()) {
            ++endIndex;
        }
        return endIndex;
    }

    private class AutoGuessActionListener
    implements ActionListener {
        private AutoGuessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GpxDataWrapper gpxW = CorrelateGpxWithImages.this.selectedGPX(true);
            if (gpxW == null) {
                return;
            }
            GpxData gpx = gpxW.data;
            List imgs = CorrelateGpxWithImages.this.getSortedImgList();
            try {
                Pair<Timezone, Offset> r = CorrelateGpxWithImages.autoGuess(imgs, gpx);
                CorrelateGpxWithImages.this.timezone = (Timezone)r.a;
                CorrelateGpxWithImages.this.delta = (Offset)r.b;
            }
            catch (IndexOutOfBoundsException ex) {
                Logging.debug(ex);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected photos do not contain time information.", new Object[0]), I18n.tr("Photos do not contain time information", new Object[0]), 2);
                return;
            }
            catch (NoGpxTimestamps ex) {
                Logging.debug(ex);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected GPX track does not contain timestamps. Please select another one.", new Object[0]), I18n.tr("GPX Track has no time information", new Object[0]), 2);
                return;
            }
            CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
            CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
            CorrelateGpxWithImages.this.tfOffset.requestFocus();
            CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    static class NoGpxTimestamps
    extends Exception {
        NoGpxTimestamps() {
        }
    }

    private class AdjustActionListener
    implements ActionListener {
        private AdjustActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Offset offset = Offset.milliseconds(CorrelateGpxWithImages.this.delta.getMilliseconds() + Math.round(CorrelateGpxWithImages.this.timezone.getHours() * (double)TimeUnit.HOURS.toMillis(1L)));
            final int dayOffset = offset.getDayOffset();
            Pair<Timezone, Offset> timezoneOffsetPair = offset.withoutDayOffset().splitOutTimezone();
            final JLabel lblMatches = new JLabel();
            final JLabel lblTimezone = new JLabel();
            final JSlider sldTimezone = new JSlider(-24, 24, 0);
            sldTimezone.setPaintLabels(true);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            for (int i = -12; i <= 12; i += 6) {
                ((Dictionary)labelTable).put(i * 2, new JLabel(new Timezone(i).formatTimezone()));
            }
            sldTimezone.setLabelTable(labelTable);
            final JLabel lblMinutes = new JLabel();
            final JSlider sldMinutes = new JSlider(-15, 15, 0);
            sldMinutes.setPaintLabels(true);
            sldMinutes.setMajorTickSpacing(5);
            final JLabel lblSeconds = new JLabel();
            final JSlider sldSeconds = new JSlider(-600, 600, 0);
            sldSeconds.setPaintLabels(true);
            labelTable = new Hashtable();
            for (int i = -60; i <= 60; i += 30) {
                ((Dictionary)labelTable).put(i * 10, new JLabel(Offset.seconds(i).formatOffset()));
            }
            sldSeconds.setLabelTable(labelTable);
            sldSeconds.setMajorTickSpacing(300);
            JPanel p = new JPanel(new GridBagLayout());
            p.setPreferredSize(new Dimension(400, 230));
            p.add((Component)lblMatches, GBC.eol().fill());
            p.add((Component)lblTimezone, GBC.eol().fill());
            p.add((Component)sldTimezone, GBC.eol().fill().insets(0, 0, 0, 10));
            p.add((Component)lblMinutes, GBC.eol().fill());
            p.add((Component)sldMinutes, GBC.eol().fill().insets(0, 0, 0, 10));
            p.add((Component)lblSeconds, GBC.eol().fill());
            p.add((Component)sldSeconds, GBC.eol().fill());
            try {
                sldTimezone.setValue((int)(((Timezone)timezoneOffsetPair.a).getHours() * 2.0));
                sldMinutes.setValue((int)(((Offset)timezoneOffsetPair.b).getSeconds() / 60L));
                long deciSeconds = ((Offset)timezoneOffsetPair.b).getMilliseconds() / 100L;
                sldSeconds.setValue((int)(deciSeconds % 60L));
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                Logging.warn(e);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos.", new Object[0]), I18n.tr("Matching photos to track failed", new Object[0]), 2);
            }
            class SliderListener
            implements ChangeListener {
                SliderListener() {
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    CorrelateGpxWithImages.this.timezone = new Timezone((double)sldTimezone.getValue() / 2.0);
                    lblTimezone.setText(I18n.tr("Timezone: {0}", CorrelateGpxWithImages.this.timezone.formatTimezone()));
                    lblMinutes.setText(I18n.tr("Minutes: {0}", sldMinutes.getValue()));
                    lblSeconds.setText(I18n.tr("Seconds: {0}", Offset.milliseconds(100L * (long)sldSeconds.getValue()).formatOffset()));
                    CorrelateGpxWithImages.this.delta = Offset.milliseconds(100L * (long)sldSeconds.getValue() + TimeUnit.MINUTES.toMillis(sldMinutes.getValue()) + TimeUnit.DAYS.toMillis(dayOffset));
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
                    CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    lblMatches.setText(CorrelateGpxWithImages.this.statusBarText.getText() + "<br>" + I18n.trn("(Time difference of {0} day)", "Time difference of {0} days", Math.abs(dayOffset), Math.abs(dayOffset)));
                    CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                }
            }
            new SliderListener().stateChanged(null);
            sldTimezone.addChangeListener(new SliderListener());
            sldMinutes.addChangeListener(new SliderListener());
            sldSeconds.addChangeListener(new SliderListener());
            new ExtendedDialog(Main.parent, I18n.tr("Adjust timezone and offset", new Object[0]), I18n.tr("Close", new Object[0])).setContent(p).setButtonIcons("ok").showDialog();
        }
    }

    private class RepaintTheMapListener
    implements FocusListener {
        private RepaintTheMapListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class StatusBarUpdater
    implements DocumentListener,
    ItemListener,
    ActionListener {
        private final boolean doRepaint;

        StatusBarUpdater(boolean doRepaint) {
            this.doRepaint = doRepaint;
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            this.updateStatusBar();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.updateStatusBar();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateStatusBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateStatusBar();
        }

        public void updateStatusBar() {
            CorrelateGpxWithImages.this.statusBarText.setText(this.statusText());
            if (this.doRepaint) {
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }

        private String statusText() {
            try {
                CorrelateGpxWithImages.this.timezone = Timezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                CorrelateGpxWithImages.this.delta = Offset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                return e.getMessage();
            }
            if (((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null) {
                for (ImageEntry imageEntry : ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data) {
                    imageEntry.discardTmp();
                }
            }
            List dateImgLst = CorrelateGpxWithImages.this.getSortedImgList();
            for (ImageEntry ie : dateImgLst) {
                ie.createTmp();
                ie.tmp.setPos(null);
            }
            GpxDataWrapper gpxDataWrapper = CorrelateGpxWithImages.this.selectedGPX(false);
            if (gpxDataWrapper == null) {
                return I18n.tr("No gpx selected", new Object[0]);
            }
            long offsetMs = (long)(CorrelateGpxWithImages.this.timezone.getHours() * (double)TimeUnit.HOURS.toMillis(1L)) + CorrelateGpxWithImages.this.delta.getMilliseconds();
            CorrelateGpxWithImages.this.lastNumMatched = CorrelateGpxWithImages.matchGpxTrack(dateImgLst, gpxDataWrapper.data, offsetMs);
            return I18n.trn("<html>Matched <b>{0}</b> of <b>{1}</b> photo to GPX track.</html>", "<html>Matched <b>{0}</b> of <b>{1}</b> photos to GPX track.</html>", dateImgLst.size(), CorrelateGpxWithImages.this.lastNumMatched, dateImgLst.size());
        }
    }

    private class SetOffsetActionListener
    implements ActionListener {
        private SetOffsetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SimpleDateFormat dateFormat = (SimpleDateFormat)DateUtils.getDateTimeFormat(3, 2);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(I18n.tr("<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>", new Object[0])), "North");
            ImageDisplay imgDisp = new ImageDisplay();
            imgDisp.setPreferredSize(new Dimension(300, 225));
            panel.add((Component)imgDisp, "Center");
            JPanel panelTf = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Photo time (from exif):", new Object[0])), gc);
            JLabel lbExifTime = new JLabel();
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.gridwidth = 2;
            panelTf.add((Component)lbExifTime, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Gps time (read from the above photo): ", new Object[0])), gc);
            JosmTextField tfGpsTime = new JosmTextField(12);
            tfGpsTime.setEnabled(false);
            tfGpsTime.setMinimumSize(new Dimension(155, tfGpsTime.getMinimumSize().height));
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            panelTf.add((Component)tfGpsTime, gc);
            gc.gridx = 2;
            gc.weightx = 0.2;
            panelTf.add((Component)new JLabel(" [" + dateFormat.toLocalizedPattern() + ']'), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("I am in the timezone of: ", new Object[0])), gc);
            String[] tmp = TimeZone.getAvailableIDs();
            ArrayList<String> vtTimezones = new ArrayList<String>(tmp.length);
            for (String tzStr : tmp) {
                TimeZone tz = TimeZone.getTimeZone(tzStr);
                String tzDesc = tzStr + " (" + new Timezone((double)tz.getRawOffset() / (double)TimeUnit.HOURS.toMillis(1L)).formatTimezone() + ')';
                vtTimezones.add(tzDesc);
            }
            Collections.sort(vtTimezones);
            JosmComboBox<String> cbTimezones = new JosmComboBox<String>(vtTimezones.toArray(new String[0]));
            String tzId = Config.getPref().get("geoimage.timezoneid", "");
            TimeZone defaultTz = tzId.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(tzId);
            cbTimezones.setSelectedItem(defaultTz.getID() + " (" + new Timezone((double)defaultTz.getRawOffset() / (double)TimeUnit.HOURS.toMillis(1L)).formatTimezone() + ')');
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            gc.fill = 2;
            panelTf.add(cbTimezones, gc);
            panel.add((Component)panelTf, "South");
            JPanel panelLst = new JPanel(new BorderLayout());
            JList<String> imgList = new JList<String>(new AbstractListModel<String>(){

                @Override
                public String getElementAt(int i) {
                    return ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(i).getFile().getName();
                }

                @Override
                public int getSize() {
                    return ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null ? ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.size() : 0;
                }
            });
            imgList.getSelectionModel().setSelectionMode(0);
            imgList.getSelectionModel().addListSelectionListener(evt -> {
                int index = imgList.getSelectedIndex();
                imgDisp.setImage(((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(index));
                Date date = ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(index).getExifTime();
                if (date != null) {
                    DateFormat df = DateUtils.getDateTimeFormat(3, 2);
                    lbExifTime.setText(df.format(date));
                    tfGpsTime.setText(df.format(date));
                    tfGpsTime.setCaretPosition(tfGpsTime.getText().length());
                    tfGpsTime.setEnabled(true);
                    tfGpsTime.requestFocus();
                } else {
                    lbExifTime.setText(I18n.tr("No date", new Object[0]));
                    tfGpsTime.setText("");
                    tfGpsTime.setEnabled(false);
                }
            });
            panelLst.add((Component)new JScrollPane(imgList), "Center");
            JButton openButton = new JButton(I18n.tr("Open another photo", new Object[0]));
            openButton.addActionListener(ae -> {
                AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, false, null, JpgImporter.FILE_FILTER_WITH_FOLDERS, 0, "geoimage.lastdirectory");
                if (fc == null) {
                    return;
                }
                ImageEntry entry = new ImageEntry(fc.getSelectedFile());
                entry.extractExif();
                imgDisp.setImage(entry);
                Date date = entry.getExifTime();
                if (date != null) {
                    lbExifTime.setText(DateUtils.getDateTimeFormat(3, 2).format(date));
                    tfGpsTime.setText(DateUtils.getDateFormat(3).format(date) + ' ');
                    tfGpsTime.setEnabled(true);
                } else {
                    lbExifTime.setText(I18n.tr("No date", new Object[0]));
                    tfGpsTime.setText("");
                    tfGpsTime.setEnabled(false);
                }
            });
            panelLst.add((Component)openButton, "Last");
            panel.add((Component)panelLst, "Before");
            boolean isOk = false;
            while (!isOk) {
                long delta;
                int answer = JOptionPane.showConfirmDialog(Main.parent, panel, I18n.tr("Synchronize time from a photo of the GPS receiver", new Object[0]), 2, 3);
                if (answer == 2) {
                    return;
                }
                try {
                    delta = dateFormat.parse(lbExifTime.getText()).getTime() - dateFormat.parse(tfGpsTime.getText()).getTime();
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing the date.\nPlease use the requested format", new Object[0]), I18n.tr("Invalid date", new Object[0]), 0);
                    continue;
                }
                String selectedTz = (String)cbTimezones.getSelectedItem();
                int pos = selectedTz.lastIndexOf(40);
                tzId = selectedTz.substring(0, pos - 1);
                String tzValue = selectedTz.substring(pos + 1, selectedTz.length() - 1);
                Config.getPref().put("geoimage.timezoneid", tzId);
                CorrelateGpxWithImages.this.tfOffset.setText(Offset.milliseconds(delta).formatOffset());
                CorrelateGpxWithImages.this.tfTimezone.setText(tzValue);
                isOk = true;
            }
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            block26: {
                ExtensionFileFilter gpxFilter = GpxImporter.getFileFilter();
                AbstractFileChooser fc = new FileChooserManager(true, null).createFileChooser(false, null, Arrays.asList(gpxFilter, NMEAImporter.FILE_FILTER), gpxFilter, 0).openFileChooser();
                if (fc == null) {
                    return;
                }
                File sel = fc.getSelectedFile();
                try {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        GpxDataWrapper wrapper = (GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (!sel.equals(wrapper.file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!sel.getName().equals(wrapper.name)) {
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr("File {0} is loaded yet under the name \"{1}\"", sel.getName(), wrapper.name), I18n.tr("Error", new Object[0]), 0);
                        }
                        return;
                    }
                    GpxData data = null;
                    try (InputStream iStream = Compression.getUncompressedFileInputStream(sel);){
                        IGpxReader reader = gpxFilter.accept(sel) ? new GpxReader(iStream) : new NmeaReader(iStream);
                        reader.parse(false);
                        data = reader.getGpxData();
                        data.storageFile = sel;
                    }
                    catch (SAXException ex) {
                        Logging.error(ex);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing {0}", sel.getName()) + ": " + ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException ex) {
                        Logging.error(ex);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read \"{0}\"", sel.getName()) + '\n' + ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    MutableComboBoxModel model = (MutableComboBoxModel)CorrelateGpxWithImages.this.cbGpx.getModel();
                    loadedGpxData.add(data);
                    if (((GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(0)).file == null) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                        model.removeElementAt(0);
                    }
                    GpxDataWrapper elem = new GpxDataWrapper(sel.getName(), data, sel);
                    CorrelateGpxWithImages.this.gpxLst.add(elem);
                    model.addElement(elem);
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class GpxDataWrapper {
        private final String name;
        private final GpxData data;
        private final File file;

        GpxDataWrapper(String name, GpxData data, File file) {
            this.name = name;
            this.data = data;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SyncDialogWindowListener
    extends WindowAdapter {
        private static final int CANCEL = -1;
        private static final int DONE = 0;
        private static final int AGAIN = 1;
        private static final int NOTHING = 2;

        private SyncDialogWindowListener() {
        }

        private int checkAndSave() {
            if (CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                return 2;
            }
            int answer = CorrelateGpxWithImages.this.syncDialog.getValue();
            if (answer != 1) {
                return -1;
            }
            try {
                CorrelateGpxWithImages.this.timezone = Timezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Invalid timezone", new Object[0]), 0);
                return 1;
            }
            try {
                CorrelateGpxWithImages.this.delta = Offset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Invalid offset", new Object[0]), 0);
                return 1;
            }
            if (CorrelateGpxWithImages.this.lastNumMatched == 0 && new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Try Again", new Object[0])).setContent(I18n.tr("No images could be matched!", new Object[0])).setButtonIcons("ok", "dialogs/refresh").showDialog().getValue() == 2) {
                return 1;
            }
            return 0;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            int result = this.checkAndSave();
            switch (result) {
                case 2: {
                    break;
                }
                case -1: {
                    if (CorrelateGpxWithImages.this.yLayer == null) break;
                    if (((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null) {
                        for (ImageEntry ie : ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data) {
                            ie.discardTmp();
                        }
                    }
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    break;
                }
                case 1: {
                    CorrelateGpxWithImages.this.actionPerformed(null);
                    break;
                }
                case 0: {
                    Config.getPref().put("geoimage.timezone", CorrelateGpxWithImages.this.timezone.formatTimezone());
                    Config.getPref().put("geoimage.delta", CorrelateGpxWithImages.this.delta.formatOffset());
                    Config.getPref().putBoolean("geoimage.showThumbs", ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.useThumbs);
                    ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.useThumbs = CorrelateGpxWithImages.this.cbShowThumbs.isSelected();
                    CorrelateGpxWithImages.this.yLayer.startLoadThumbs();
                    boolean boundingBoxedLayerFound = false;
                    for (Layer l : MainApplication.getLayerManager().getLayers()) {
                        if (l == CorrelateGpxWithImages.this.yLayer) continue;
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        l.visitBoundingBox(bbox);
                        if (bbox.getBounds() == null) continue;
                        boundingBoxedLayerFound = true;
                        break;
                    }
                    if (!boundingBoxedLayerFound) {
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        CorrelateGpxWithImages.this.yLayer.visitBoundingBox(bbox);
                        MainApplication.getMap().mapView.zoomTo(bbox);
                    }
                    if (((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null) {
                        for (ImageEntry ie : ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data) {
                            ie.applyTmp();
                        }
                    }
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

