/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.DefaultImmutableAttributes;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.CoercingStringValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultImmutableAttributesFactory
implements ImmutableAttributesFactory {
    private final ImmutableAttributes root;
    private final Map<ImmutableAttributes, List<DefaultImmutableAttributes>> children;
    private final IsolatableFactory isolatableFactory;
    private NamedObjectInstantiator instantiator;

    public DefaultImmutableAttributesFactory(IsolatableFactory isolatableFactory, NamedObjectInstantiator instantiator) {
        this.isolatableFactory = isolatableFactory;
        this.instantiator = instantiator;
        this.root = ImmutableAttributes.EMPTY;
        this.children = Maps.newHashMap();
        this.children.put(this.root, new ArrayList());
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public AttributeContainerInternal mutable() {
        return new DefaultMutableAttributeContainer(this);
    }

    @Override
    public AttributeContainerInternal mutable(AttributeContainerInternal parent) {
        return new DefaultMutableAttributeContainer(this, parent);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.concat(this.root, key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, T value) {
        return this.doConcatIsolatable(node, key, this.isolate(value));
    }

    private <T> Isolatable<T> isolate(T value) {
        if (value instanceof String) {
            return new CoercingStringValueSnapshot((String)value, this.instantiator);
        }
        return this.isolatableFactory.isolate(value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        return this.doConcatIsolatable(node, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ImmutableAttributes doConcatIsolatable(ImmutableAttributes node, Attribute<?> key, Isolatable<?> value) {
        DefaultImmutableAttributesFactory defaultImmutableAttributesFactory = this;
        synchronized (defaultImmutableAttributesFactory) {
            ArrayList nodeChildren = this.children.get(node);
            if (nodeChildren == null) {
                nodeChildren = Lists.newArrayList();
                this.children.put(node, nodeChildren);
            }
            for (DefaultImmutableAttributes child : nodeChildren) {
                if (!child.attribute.equals(key) || !child.value.equals(value)) continue;
                return child;
            }
            DefaultImmutableAttributes child = new DefaultImmutableAttributes((DefaultImmutableAttributes)node, key, value);
            nodeChildren.add(child);
            return child;
        }
    }

    public ImmutableAttributes getRoot() {
        return this.root;
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) {
        if (attributes1 == ImmutableAttributes.EMPTY) {
            return attributes2;
        }
        if (attributes2 == ImmutableAttributes.EMPTY) {
            return attributes1;
        }
        ImmutableAttributes current = attributes2;
        for (Attribute attribute : attributes1.keySet()) {
            if (current.findEntry(attribute.getName()).isPresent()) continue;
            if (attributes1 instanceof DefaultImmutableAttributes) {
                current = this.doConcatIsolatable(current, attribute, ((DefaultImmutableAttributes)attributes1).getIsolatableAttribute(attribute));
                continue;
            }
            current = this.concat(current, attribute, attributes1.getAttribute(attribute));
        }
        return current;
    }

    @Override
    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        if (attributes1 == ImmutableAttributes.EMPTY) {
            return attributes2;
        }
        if (attributes2 == ImmutableAttributes.EMPTY) {
            return attributes1;
        }
        ImmutableAttributes current = attributes2;
        for (Attribute attribute : attributes1.keySet()) {
            Object existingAttribute;
            Object currentAttribute;
            AttributeValue<?> entry = current.findEntry(attribute.getName());
            if (entry.isPresent() && !(currentAttribute = entry.get()).equals(existingAttribute = attributes1.getAttribute(attribute))) {
                throw new AttributeMergingException(attribute, existingAttribute, currentAttribute);
            }
            if (attributes1 instanceof DefaultImmutableAttributes) {
                current = this.doConcatIsolatable(current, attribute, ((DefaultImmutableAttributes)attributes1).getIsolatableAttribute(attribute));
                continue;
            }
            current = this.concat(current, attribute, attributes1.getAttribute(attribute));
        }
        return current;
    }
}

