/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.V3;
import org.jmol.symmetry.CIPChirality;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class CIPData {
    static final float TRIGONALITY_MIN = 0.2f;
    public boolean testRule6Full;
    Viewer vwr;
    SimpleNode[] atoms;
    BS bsAtoms;
    BS bsMolecule;
    BS bsAromatic;
    BS bsXAromatic = new BS();
    BS bsNegativeAromatic = new BS();
    BS bsAzacyclic;
    BS bsAtropisomeric = new BS();
    BS bsHelixM;
    BS bsHelixP;
    BS[] lstSmallRings;
    BS bsKekuleAmbiguous = new BS();
    BS bsEnes = new BS();
    protected V3 vNorm = new V3();
    protected V3 vTemp = new V3();

    protected boolean isTracker() {
        return false;
    }

    boolean isSmiles() {
        return false;
    }

    public CIPData set(Viewer vwr, BS bsAtoms) {
        this.vwr = vwr;
        this.atoms = vwr.ms.at;
        this.bsAtoms = bsAtoms;
        this.bsMolecule = vwr.ms.getMoleculeBitSet(bsAtoms);
        this.init();
        return this;
    }

    protected void init() {
        try {
            BS lstRing = this.match("[r]");
            this.lstSmallRings = lstRing.isEmpty() ? new BS[0] : this.getList("*1**1||*1***1||*1****1||*1*****1||*1******1");
            this.bsAromatic = this.match("a");
            if (!this.bsAromatic.isEmpty()) {
                this.bsAtropisomeric = this.match("[!H](.t1:-20,20)a{a(.t2:-20,20)-a}a[!H]");
                this.bsHelixM = this.match("A{a}(.t:-10,-40)a(.t:-10,-40)aaa");
                this.bsHelixP = this.match("A{a}(.t:10,40)a(.t:10,40)aaa");
                this.bsXAromatic = this.match("[r5v3n+0,r5v2o+0]");
                this.bsNegativeAromatic = this.match("[a-]");
                if (!this.match("[n+1,o+1]").isEmpty() && !this.bsXAromatic.isEmpty()) {
                    this.bsKekuleAmbiguous.or(this.match("a1[n+,o+]a[n,o]a1"));
                    this.bsKekuleAmbiguous.or(this.match("a1[n+,o+][n,o]aa1"));
                }
                if (!this.bsNegativeAromatic.isEmpty()) {
                    this.bsKekuleAmbiguous.or(this.match("a1=a[a-]a=a1"));
                }
                BS[] lstR6a = this.getList("a1aaaaa1");
                int i = lstR6a.length;
                while (--i >= 0) {
                    this.bsKekuleAmbiguous.or(lstR6a[i]);
                }
            }
            this.getAzacyclic();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BS[] getList(String smarts) throws Exception {
        int level = Logger.getLogLevel();
        Logger.setLogLevel(Math.min(level, 4));
        BS[] list = this.vwr.getSubstructureSetArray(smarts, this.bsMolecule, 2);
        Logger.setLogLevel(level);
        return list;
    }

    protected BS match(String smarts) throws Exception {
        int level = Logger.getLogLevel();
        Logger.setLogLevel(Math.min(level, 4));
        BS bs = this.vwr.getSmartsMatch(smarts, this.bsMolecule);
        Logger.setLogLevel(level);
        return bs;
    }

    void getEneKekule() {
        if (this.bsEnes.cardinality() < 8) {
            return;
        }
        BS bsAllEnes = (BS)this.bsEnes.clone();
        BS bsPath = new BS();
        this.bsEnes.andNot(this.bsKekuleAmbiguous);
        BS bsEneAtom1 = new BS();
        int i = this.bsEnes.nextSetBit(0);
        while (i >= 0) {
            bsPath.clearAll();
            bsEneAtom1.clearAll();
            this.checkEne(bsAllEnes, bsPath, -1, i, 2, bsEneAtom1);
            i = this.bsEnes.nextSetBit(i + 1);
        }
    }

    private int checkEne(BS bsAllEnes, BS bsPath, int iLast, int iAtom, int order, BS bsEneAtom1) {
        if (bsPath.get(iAtom)) {
            return bsEneAtom1.get(iAtom) == (order == 2) ? iAtom : -1;
        }
        bsPath.set(iAtom);
        SimpleNode a = this.atoms[iAtom];
        int isLoop = -1;
        SimpleEdge[] edges = a.getEdges();
        if (order == 2) {
            bsEneAtom1.set(iAtom);
        }
        int ib = a.getBondCount();
        while (--ib >= 0) {
            SimpleNode b;
            int iNext;
            if (this.getBondOrder(edges[ib]) == order && (iNext = (b = edges[ib].getOtherNode(a)).getIndex()) != iLast && bsAllEnes.get(iNext) && (isLoop = this.checkEne(bsAllEnes, bsPath, iAtom, iNext, 3 - order, bsEneAtom1)) < 0) continue;
        }
        if (isLoop >= 0) {
            this.bsKekuleAmbiguous.set(iAtom);
            this.bsEnes.clear(iAtom);
        }
        return isLoop == iAtom ? -1 : isLoop;
    }

    private void getAzacyclic() {
        int i = this.bsAtoms.nextSetBit(0);
        while (i >= 0) {
            SimpleNode atom = this.atoms[i];
            if (atom.getElementNumber() == 7 && atom.getCovalentBondCount() == 3 && !this.bsKekuleAmbiguous.get(i)) {
                Lst<BS> nRings = new Lst<BS>();
                int j = this.lstSmallRings.length;
                while (--j >= 0) {
                    BS bsRing = this.lstSmallRings[j];
                    if (!bsRing.get(i)) continue;
                    nRings.addLast(bsRing);
                }
                int nr = nRings.size();
                if (nr >= 2) {
                    BS bsSubs = new BS();
                    SimpleEdge[] bonds = atom.getEdges();
                    int b = bonds.length;
                    while (--b >= 0) {
                        if (!bonds[b].isCovalent()) continue;
                        bsSubs.set(bonds[b].getOtherNode(atom).getIndex());
                    }
                    BS bsBoth = new BS();
                    BS bsAll = new BS();
                    for (int j2 = 0; j2 < nr - 1 && bsAll != null; ++j2) {
                        BS bs1 = (BS)nRings.get(j2);
                        for (int k = j2 + 1; k < nr && bsAll != null; ++k) {
                            BS bs2 = (BS)nRings.get(k);
                            BSUtil.copy2(bs1, bsBoth);
                            bsBoth.and(bs2);
                            if (bsBoth.cardinality() <= 2) continue;
                            BSUtil.copy2(bs1, bsAll);
                            bsAll.or(bs2);
                            bsAll.and(bsSubs);
                            if (bsAll.cardinality() != 3) continue;
                            if (this.bsAzacyclic == null) {
                                this.bsAzacyclic = new BS();
                            }
                            this.bsAzacyclic.set(i);
                            bsAll = null;
                        }
                    }
                }
            }
            i = this.bsAtoms.nextSetBit(i + 1);
        }
    }

    boolean couldBeChiralAtom(SimpleNode a) {
        boolean mustBePlanar = false;
        block0 : switch (a.getCovalentBondCount()) {
            default: {
                System.out.println("?? too many bonds! " + a);
                return false;
            }
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return a.getElementNumber() == 7;
            }
            case 3: {
                switch (a.getElementNumber()) {
                    case 7: {
                        if (this.bsAzacyclic != null && this.bsAzacyclic.get(a.getIndex())) break block0;
                        return false;
                    }
                    case 6: {
                        mustBePlanar = true;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: 
                    case 83: 
                    case 84: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 4: 
        }
        SimpleEdge[] edges = a.getEdges();
        int nH = 0;
        boolean haveDouble = false;
        int j = edges.length;
        while (--j >= 0) {
            if (mustBePlanar && edges[j].getCovalentOrder() == 2) {
                haveDouble = true;
            }
            if (edges[j].getOtherNode(a).getIsotopeNumber() != 1) continue;
            ++nH;
        }
        return nH < 2 && (haveDouble || this.isSmiles() || mustBePlanar == Math.abs(this.getTrigonality(a, this.vNorm)) < 0.2f);
    }

    int couldBeChiralAlkene(SimpleNode a, SimpleEdge edge) {
        SimpleNode b = edge == null ? null : edge.getOtherNode(a);
        switch (a.getCovalentBondCount()) {
            default: {
                return -1;
            }
            case 2: {
                if (a.getElementNumber() == 7) break;
                return -1;
            }
            case 3: {
                if (CIPChirality.isFirstRow(a)) break;
                return -1;
            }
        }
        SimpleEdge[] bonds = a.getEdges();
        int n = 0;
        int i = bonds.length;
        while (--i >= 0) {
            if (this.getBondOrder(bonds[i]) != 2) continue;
            if (++n > 1) {
                return 17;
            }
            SimpleNode other = bonds[i].getOtherNode(a);
            if (!CIPChirality.isFirstRow(other)) {
                return -1;
            }
            if (b == null || other == b && b.getCovalentBondCount() != 1) continue;
            return -1;
        }
        return 13;
    }

    float getTrigonality(SimpleNode a, V3 vNorm) {
        int n;
        P3[] pts = new P3[4];
        SimpleEdge[] bonds = a.getEdges();
        int i = n = bonds.length;
        int pt = 0;
        while (--i >= 0 && pt < 4) {
            if (!bonds[i].isCovalent()) continue;
            pts[pt++] = bonds[i].getOtherNode(a).getXYZ();
        }
        P4 plane = Measure.getPlaneThroughPoints(pts[0], pts[1], pts[2], vNorm, this.vTemp, new P4());
        return Measure.distanceToPlane(plane, pts[3] == null ? a.getXYZ() : pts[3]);
    }

    int isCis(CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, CIPChirality.CIPAtom c, CIPChirality.CIPAtom d) {
        Measure.getNormalThroughPoints(a.atom.getXYZ(), b.atom.getXYZ(), c.atom.getXYZ(), this.vNorm, this.vTemp);
        V3 vNorm2 = new V3();
        Measure.getNormalThroughPoints(b.atom.getXYZ(), c.atom.getXYZ(), d.atom.getXYZ(), vNorm2, this.vTemp);
        return this.vNorm.dot(vNorm2) > 0.0f ? 13 : 14;
    }

    int isPositiveTorsion(CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, CIPChirality.CIPAtom c, CIPChirality.CIPAtom d) {
        float angle = Measure.computeTorsion(a.atom.getXYZ(), b.atom.getXYZ(), c.atom.getXYZ(), d.atom.getXYZ(), true);
        return angle > 0.0f ? 18 : 17;
    }

    int getBondOrder(SimpleEdge bond) {
        return bond.getCovalentOrder();
    }

    boolean setCoord(SimpleNode atom1, CIPChirality.CIPAtom[] atoms) {
        return true;
    }

    int checkHandedness(CIPChirality.CIPAtom a) {
        CIPChirality.CIPAtom[] atoms = a.atoms;
        if (!this.setCoord(a.atom, atoms)) {
            return 0;
        }
        P3 p0 = (atoms[3].atom == null ? a.atom : atoms[3].atom).getXYZ();
        P3 p1 = atoms[0].atom.getXYZ();
        P3 p2 = atoms[1].atom.getXYZ();
        P3 p3 = atoms[2].atom.getXYZ();
        Measure.getNormalThroughPoints(p1, p2, p3, this.vNorm, this.vTemp);
        this.vTemp.setT(p0);
        this.vTemp.sub(p1);
        return this.vTemp.dot(this.vNorm) > 0.0f ? 1 : 2;
    }

    void track(CIPChirality cip, CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, int sphere, int finalScore, boolean trackTerminal) {
    }

    String getRootTrackerResult(CIPChirality.CIPAtom root) {
        return null;
    }

    public void setRule6Full(boolean rrrr) {
        this.testRule6Full = rrrr;
    }
}

