/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataUpdateSettingsService
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ThreadPool threadPool;

    @Inject
    public MetaDataUpdateSettingsService(Settings settings, ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ThreadPool threadPool) {
        super(settings);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.clusterService.addListener(this);
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        int dataNodeCount = event.state().nodes().getDataNodes().size();
        HashMap nrReplicasChanged = new HashMap();
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            AutoExpandReplicas autoExpandReplicas = IndexMetaData.INDEX_AUTO_EXPAND_REPLICAS_SETTING.get(indexMetaData.getSettings());
            if (!autoExpandReplicas.isEnabled()) continue;
            int min = autoExpandReplicas.getMinReplicas();
            int max = autoExpandReplicas.getMaxReplicas(dataNodeCount);
            int numberOfReplicas = dataNodeCount - 1;
            if (numberOfReplicas < min) {
                numberOfReplicas = min;
            } else if (numberOfReplicas > max) {
                numberOfReplicas = max;
            }
            if (numberOfReplicas == indexMetaData.getNumberOfReplicas() || numberOfReplicas < min || numberOfReplicas > max) continue;
            if (!nrReplicasChanged.containsKey(numberOfReplicas)) {
                nrReplicasChanged.put(numberOfReplicas, new ArrayList());
            }
            ((List)nrReplicasChanged.get(numberOfReplicas)).add(indexMetaData.getIndex());
        }
        if (nrReplicasChanged.size() > 0) {
            for (final Integer fNumberOfReplicas : nrReplicasChanged.keySet()) {
                Settings settings = Settings.builder().put("index.number_of_replicas", fNumberOfReplicas).build();
                final List indices = (List)nrReplicasChanged.get(fNumberOfReplicas);
                UpdateSettingsClusterStateUpdateRequest updateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(indices.toArray(new Index[indices.size()]))).settings(settings).ackTimeout(TimeValue.timeValueMillis(0L))).masterNodeTimeout(TimeValue.timeValueMinutes(10L));
                this.updateSettings(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                    @Override
                    public void onResponse(ClusterStateUpdateResponse response) {
                        for (Index index : indices) {
                            MetaDataUpdateSettingsService.this.logger.info("{} auto expanded replicas to [{}]", (Object)index, (Object)fNumberOfReplicas);
                        }
                    }

                    @Override
                    public void onFailure(Exception t) {
                        for (Index index : indices) {
                            MetaDataUpdateSettingsService.this.logger.warn("{} fail to auto expand replicas to [{}]", (Object)index, (Object)fNumberOfReplicas);
                        }
                    }
                });
            }
        }
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false);
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        this.clusterService.submitStateUpdateTask("update-settings", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Settings finalSettings;
                Settings.Builder indexSettings;
                Settings.Builder updates;
                IndexMetaData indexMetaData;
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closeIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                for (int i = 0; i < request.indices().length; ++i) {
                    Index index = request.indices()[i];
                    actualIndices[i] = index.getName();
                    IndexMetaData metaData = currentState.metaData().getIndexSafe(index);
                    if (metaData.getState() == IndexMetaData.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                int updatedNumberOfReplicas = openSettings.getAsInt("index.number_of_replicas", -1);
                if (updatedNumberOfReplicas != -1 && !preserveExisting) {
                    routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    metaDataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    MetaDataUpdateSettingsService.this.logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_READ_ONLY_BLOCK, IndexMetaData.INDEX_READ_ONLY_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK, IndexMetaData.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_METADATA_BLOCK, IndexMetaData.INDEX_BLOCKS_METADATA_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_WRITE_BLOCK, IndexMetaData.INDEX_BLOCKS_WRITE_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_READ_BLOCK, IndexMetaData.INDEX_BLOCKS_READ_SETTING, openSettings);
                if (!openIndices.isEmpty()) {
                    for (Index index : openIndices) {
                        indexMetaData = metaDataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetaData.getSettings());
                        if (!MetaDataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetaData.getSettings());
                        }
                        finalSettings = indexSettings.build();
                        MetaDataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetaDataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(finalSettings));
                    }
                }
                if (!closeIndices.isEmpty()) {
                    for (Index index : closeIndices) {
                        indexMetaData = metaDataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetaData.getSettings());
                        if (!MetaDataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetaData.getSettings());
                        }
                        finalSettings = indexSettings.build();
                        MetaDataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetaDataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(finalSettings));
                    }
                }
                ClusterState updatedState = ClusterState.builder(currentState).metaData(metaDataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
                updatedState = MetaDataUpdateSettingsService.this.allocationService.reroute(updatedState, "settings update");
                try {
                    IndexMetaData updatedMetaData;
                    IndexMetaData currentMetaData;
                    for (Index index : openIndices) {
                        currentMetaData = currentState.getMetaData().getIndexSafe(index);
                        updatedMetaData = updatedState.metaData().getIndexSafe(index);
                        MetaDataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetaData, updatedMetaData);
                    }
                    for (Index index : closeIndices) {
                        currentMetaData = currentState.getMetaData().getIndexSafe(index);
                        updatedMetaData = updatedState.metaData().getIndexSafe(index);
                        MetaDataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetaData, updatedMetaData);
                        MetaDataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetaData, updatedMetaData);
                    }
                }
                catch (IOException iOException) {
                    throw ExceptionsHelper.convertToElastic(iOException);
                }
                return updatedState;
            }
        });
    }

    private static void maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        if (setting.exists(openSettings)) {
            boolean updateReadBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateReadBlock) {
                    blocks.addIndexBlock(index, block);
                    continue;
                }
                blocks.removeIndexBlock(index, block);
            }
        }
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetaData indexMetaData = metaDataBuilder.get(index);
                    if (indexMetaData == null || Version.CURRENT.equals(indexMetaData.getCreationVersion())) continue;
                    metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(Settings.builder().put(indexMetaData.getSettings()).put("index.version.upgraded", entry.getValue().v1())));
                }
                return ClusterState.builder(currentState).metaData(metaDataBuilder).build();
            }
        });
    }
}

