/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.DamagedHomeIOException;
import com.eteks.sweethome3d.io.DefaultHomeInputStream;
import com.eteks.sweethome3d.io.DefaultHomeOutputStream;
import com.eteks.sweethome3d.io.HomeXMLExporter;
import com.eteks.sweethome3d.io.HomeXMLHandler;
import com.eteks.sweethome3d.model.DamagedHomeRecorderException;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.NotEnoughSpaceRecorderException;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class HomeFileRecorder
implements HomeRecorder {
    private final int compressionLevel;
    private final boolean includeOnlyTemporaryContent;
    private final UserPreferences preferences;
    private final boolean preferPreferencesContent;
    private final boolean preferXmlEntry;
    private final boolean acceptUrl;

    public HomeFileRecorder() {
        this(0);
    }

    public HomeFileRecorder(int n) {
        this(n, false);
    }

    public HomeFileRecorder(int n, boolean bl) {
        this(n, bl, null, false);
    }

    public HomeFileRecorder(int n, boolean bl, UserPreferences userPreferences, boolean bl2) {
        this(n, bl, userPreferences, bl2, false);
    }

    public HomeFileRecorder(int n, boolean bl, UserPreferences userPreferences, boolean bl2, boolean bl3) {
        this(n, bl, userPreferences, bl2, bl3, false);
    }

    public HomeFileRecorder(int n, boolean bl, UserPreferences userPreferences, boolean bl2, boolean bl3, boolean bl4) {
        this.compressionLevel = n;
        this.includeOnlyTemporaryContent = bl;
        this.preferences = userPreferences;
        this.preferPreferencesContent = bl2;
        this.preferXmlEntry = bl3;
        this.acceptUrl = bl4;
    }

    public void writeHome(Home home, String string) throws RecorderException {
        FileOutputStream fileOutputStream;
        File file = new File(string);
        if (file.exists() && !file.canWrite()) {
            throw new RecorderException("Can't write over file " + string);
        }
        FilterOutputStream filterOutputStream = null;
        File file2 = null;
        try {
            file2 = OperatingSystem.createTemporaryFile("save", ".sweethome3d");
            filterOutputStream = new DefaultHomeOutputStream(new FileOutputStream(file2), this.compressionLevel, this.includeOnlyTemporaryContent ? ContentRecording.INCLUDE_TEMPORARY_CONTENT : ContentRecording.INCLUDE_ALL_CONTENT, true, this.preferXmlEntry ? this.getHomeXMLExporter() : null);
            ((DefaultHomeOutputStream)filterOutputStream).writeHome(home);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedRecorderException("Save " + string + " interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't save home " + string, iOException);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close temporary file " + string, iOException);
            }
        }
        try {
            long l = (Long)File.class.getMethod("getUsableSpace", new Class[0]).invoke((Object)file, new Object[0]);
            long l2 = file2.length();
            if (file.exists()) {
                l2 -= file.length();
            }
            if (l != 0L && l < l2) {
                throw new NotEnoughSpaceRecorderException("Not enough disk space to save file " + string, l2 - l);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NotEnoughSpaceRecorderException notEnoughSpaceRecorderException) {
            if (file2 != null) {
                file2.delete();
            }
            throw notEnoughSpaceRecorderException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file2 != null) {
                file2.delete();
            }
            throw new RecorderException("Can't save file " + string, fileNotFoundException);
        }
        byte[] byArray = new byte[8192];
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file2);
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't copy file " + file2 + " to " + string);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close file " + string, iOException);
            }
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                    file2.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected HomeXMLExporter getHomeXMLExporter() {
        return new HomeXMLExporter();
    }

    public Home readHome(String string) throws RecorderException {
        FilterInputStream filterInputStream = null;
        try {
            Object object;
            InputStream inputStream;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.acceptUrl) {
                    object = new URL(string).openConnection();
                    ((URLConnection)object).setUseCaches(false);
                    inputStream = ((URLConnection)object).getInputStream();
                }
                throw fileNotFoundException;
            }
            filterInputStream = new DefaultHomeInputStream(inputStream, ContentRecording.INCLUDE_ALL_CONTENT, this.preferXmlEntry ? this.getHomeXMLHandler() : null, this.preferences, this.preferPreferencesContent);
            Home home = ((DefaultHomeInputStream)filterInputStream).readHome();
            object = home;
            return object;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedRecorderException("Read " + string + " interrupted");
        }
        catch (DamagedHomeIOException damagedHomeIOException) {
            throw new DamagedHomeRecorderException(damagedHomeIOException.getDamagedHome(), damagedHomeIOException.getInvalidContent());
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't read home from " + string, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RecorderException("Missing classes to read home from " + string, classNotFoundException);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close file " + string, iOException);
            }
        }
    }

    protected HomeXMLHandler getHomeXMLHandler() {
        return new HomeXMLHandler(this.preferences);
    }

    public boolean exists(String string) throws RecorderException {
        return new File(string).exists();
    }
}

